/*
 * HMailServerModel.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.fw.util.mail;

import javax.mail.Authenticator;

import jp.hrtdotnet.fw.common.HMailDefine;
import jp.hrtdotnet.fw.common.HNetCheck;

/**
 * [T[ȍ̃NXłB
 *
 * @version 2.1
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.1
 */
public class HSendMailServerModel {

    private boolean auth = false;
    private String hostName = null;
    private int smtpPort = HMailDefine.SMTP_PORT;
    private String userName = null;
    private String password = null;
    private Authenticator authenticator = null;
    private boolean sslSmtp = false;
    private int sslSmtpPort = HMailDefine.SMTP_PORT_SSL;
    private boolean tls = false;
    private boolean popBeforeSmtp = false;
    private String popHostName = null;
    private String popUserName = null;
    private String popPassword = null;

    /**
     * RXgN^B
     * @param hostName [T[õzXg
     * @param smtpPort [M|[gԍ
     * @throws NullPointerException hostNamenull
     * @throws IllegalArgumentException hostName󕶎A
     *                                  smtpPort0ȉ
     */
    public HSendMailServerModel(String hostName, int smtpPort) {
        //zXg
        if (hostName == null) {
            throw new NullPointerException("Host-name is null.");
        } else if (hostName.length() == 0) {
            throw new IllegalArgumentException("Host-name is empty-string.");
        }
        //SMTP|[gԍ
        if (HNetCheck.isRangeOfPort(smtpPort) == false) {
            throw new IllegalArgumentException("SMTP PORT invalid range.");
        }
        this.hostName = hostName;
        this.smtpPort = smtpPort;
    }


    /**
     * RXgN^B
     * @param hostName [T[õzXg
     * @throws NullPointerException hostNamenull
     * @throws IllegalArgumentException hostName󕶎
     */
    public HSendMailServerModel(String hostName) {
        this(hostName, HMailDefine.SMTP_PORT);
    }
    
    /**
     * F؃tO擾܂B
     * F؂sꍇtrueAȊOfalsełB
     * @return auth F؃tO
     */
    public boolean isAuth() {
        return auth;
    }
    /**
     * F؃tOݒ肵܂B
     * F؂sꍇtrueAȊOfalsełB
     * @param auth F؃tO
     */
    public void setAuth(boolean auth) {
        this.auth = auth;
    }
    /**
     * [T[õzXg擾܂B
     * @return hostName [T[õzXg
     */
    public String getHostName() {
        return hostName;
    }
    /**
     * [M|[gԍ擾܂B
     * @return smtpPort [M|[gԍ
     */
    public int getSmtpPort() {
        return smtpPort;
    }
    
    /**
     * F؃[U擾܂B
     * @return userName F؃[U
     */
    public String getUserName() {
        return userName;
    }
    /**
     * F؃[Uݒ肵܂B
     * @param userName F؃[U
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }
    /**
     * F؃pX[h擾܂B
     * @return password F؃pX[h
     */
    public String getPassword() {
        return password;
    }
    /**
     * F؃pX[hݒ肵܂B
     * @param password F؃pX[h
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * F؃[UƃpX[hݒ肵܂B
     * @param userName F؃[U
     * @param password F؃pX[h
     */
    public void setAuthentication (String userName, String password) {
        setUserName(userName);
        setPassword(password);
    }
    
    /**
     * F؏擾܂B
     * @return authenticator F؏
     */
    public Authenticator getAuthenticator() {
        return authenticator;
    }

    /**
     * F؏ݒ肵܂B
     * @param authenticator F؏
     */
    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    /**
     * SSL[MtO擾܂B
     * sꍇtrueAȊOfalsełB
     * @return ssl sꍇtrueAȊOfalse
     */
    public boolean isSslSmtp() {
        return sslSmtp;
    }

    /**
     * SSL[MtOݒ肵܂B
     * sꍇtrueAȊOfalsełB
     * @param sslSmtp SSL[MtO
     */
    public void setSslSmtp(boolean sslSmtp) {
        this.sslSmtp = sslSmtp;
    }

    /**
     * [M|[gԍ(SSL)擾܂B
     * @return sslSmtpPort [M|[gԍ(SSL)
     */
    public int getSslSmtpPort() {
        return sslSmtpPort;
    }

    /**
     * [M|[gԍ(SSL)ݒ肵܂B
     * @param sslSmtpPort [M|[gԍ(SSL)
     */
    public void setSslSmtpPort(int sslSmtpPort) {
        if (HNetCheck.isRangeOfPort(sslSmtpPort) == false) {
            throw new IllegalArgumentException("SMTP(SSL) PORT invalid Range.");
        }
        this.sslSmtpPort = sslSmtpPort;
    }

    /**
     * TLStO擾܂B
     * TLS𗘗pꍇtrueAȊOfalsełB
     * @return tls TLStO
     */
    public boolean isTls() {
        return tls;
    }

    /**
     * TLStOݒ肵܂B
     * TLS𗘗pꍇtrueAȊOfalsełB
     * @param tls TLStO
     */
    public void setTls(boolean tls) {
        this.tls = tls;
    }

    /**
     * POP before SMTPF؂̃tO擾܂B
     * @return POPF؂̃tO
     */
    public boolean isPopBeforeSmtp() {
        return popBeforeSmtp;
    }


    /**
     * POP before SMTPF؂̃tOݒ肵܂B
     * @param popBeforeSmtp POPF؂̃tO
     */
    public void setPopBeforeSmtp(boolean popBeforeSmtp) {
        this.popBeforeSmtp = popBeforeSmtp;
    }


    /**
     * POP before SMTPF؂s[T[o擾܂B
     * @return POP[T[o
     */
    public String getPopHostName() {
        return popHostName;
    }


    /**
     * POP before SMTPF؂s[T[oݒ肵܂B
     * @param popHostName POP[T[o
     */
    public void setPopHostName(String popHostName) {
        this.popHostName = popHostName;
    }

    /**
     * POP before SMTPF؂s[U擾܂B
     * @return POP[U
     */
    public String getPopUserName() {
        return popUserName;
    }

    /**
     * POP before SMTPF؂s[Uݒ肵܂B
     * @param popUserName POP[U
     */
    public void setPopUserName(String popUserName) {
        this.popUserName = popUserName;
    }

    /**
     * POP before SMTPF؂spX[h擾܂B
     * @return POPpX[h
     */
    public String getPopPassword() {
        return popPassword;
    }

    /**
     * POP before SMTPF؂spX[hݒ肵܂B
     * @param popPassword POPpX[h
     */
    public void setPopPassword(String popPassword) {
        this.popPassword = popPassword;
    }

    /**
     * POP before SMTPF؂s[UƃpX[hݒ肵܂B
     * @param popUserName POP[U
     * @param popPassword POPpX[h
     */
    public void setPopAuthentication (String popUserName, String popPassword) {
        setPopUserName(popUserName);
        setPopPassword(popPassword);
    }
    

}
