/*
 * HFile.java
 * 
 * Author: http://www.hrtdotnet.jp/
 *
 */
package jp.hrtdotnet.java.io;

import java.io.*;

/**
 * t@C̑NXłB
 * ̃NX𗘗păfBNg𑀍삷邱Ƃ͋֎~Ă܂B
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class HFile extends File {
    
    private static final long serialVersionUID = -8719547187991724396L;
    private static final String DOT = ".";

    /**
     * RXgN^B
     * 
     * @param filePath t@CpX
     * @throws IOException filePathsȏꍇ
     * @since 2.0
     */
    public HFile(String filePath)  throws IOException { 
        super(filePath);
        this.constructor();
    }

    /**
     * RXgN^B
     * 
     * @param parent fBNgpX
     * @param child t@C
     * @throws IOException w肵t@Csȏꍇ
     * @since 2.0
     */
    public HFile(String parent, String child) throws IOException {
        super(parent, child);
        this.constructor();
    }

    /**
     * IuWFNgɊ֘At@C̊gq擾܂B
     * gqȂt@CɊւĂ͋󕶎擾܂B
     * 
     * @return gq
     * @since 2.0
     */
    public String getExtension() {
        String fileName = getName();
        return getExtension(fileName);
    }


    /**
     * t@CIuWFNgƓpX̃t@C݂ꍇA
     * ut@CpXv+uGCAXv+uw茅̃V[PXԍ v+ugqv̕擾܂B
     * ̃t@C݂Ȃꍇ̓t@CIuWFNg̃t@CpX擾܂B
     * <br>
     * ȂIuWFNgg̃t@CpXύX킯ł͂܂B
     * 
     * @param alias GCAX
     * @param digit V[PXԍ̌
     * @return ut@Cv+uGCAXv+uw茅̃V[PXԍv+ugq̕v
     * @since 2.0
     */
    public String getOtherFileName(String alias, int digit) {

        String extension = getExtension();

        // GCAX null ͋󕶎̏ꍇ͎Aԋ@\Lɂ͂łȂB
        // ܂AԌ 0 ̏ꍇAԋ@\Lɂ͂łȂ̂ł̂܂ܕԂB
        if(alias == null || alias.length() < 1 || digit <= 0){
            return getAbsolutePath();
        }        
        
        if (exists()) {
            String oldFileName = null;
            
            if(extension.length() > 0){            
                oldFileName = getAbsolutePath().substring(0, getAbsolutePath().length() - (extension.length() + 1));
            } else {
                oldFileName = getAbsolutePath();
            }

            String strNum = alias;
            
            for (int i = 0; i < digit; i++) {
                strNum += "0";
            }
            String newFileName = oldFileName + strNum + "." + extension;

            if (new File(newFileName).exists()) {
                int num = (int) Math.pow(10, digit);
                for (int i = 1; i < num; i++) {

                    strNum = alias;
                    newFileName = oldFileName;
                    for (int j = digit - 1; j > 0; j--) {
                        if (i / (int) Math.pow(10, j) == 0) {
                            strNum += "0";
                        } else {
                            break;
                        }
                    }
                    newFileName += (strNum + i + "." + extension);
                    if (!new File(newFileName).exists()) {
                        break;
                    }
                }
            }
   
            return newFileName;
        } else {
            return getAbsolutePath();
        }
    }

    
    /**
     * t@CIuWFNgƓpX̃t@C݂ꍇA
     * ut@Cv+uGCAXv+uV[PXԍv+ugqv̕擾܂B
     * ̃t@C݂Ȃꍇ̓t@CIuWFNg̃t@CpX擾܂B
     * <br>
     * ȂIuWFNgg̃t@CpXύX킯ł͂܂B
     * 
     * @param alias GCAX
     * @return ut@Cv+uGCAXv+uV[PXԍv+ugqv̕
     * @since 2.0
     */
    public String getOtherFileName(String alias) {

        String extension = getExtension();

        // GCAX null ͋󕶎̏ꍇ͎Aԋ@\Lɂ͂łȂ
        if (alias == null || alias.length() < 1) {
            return getAbsolutePath();
        }

        // t@C݂ꍇ
        if (exists()) {
            String oldFileName = null;
            if(extension.length() > 0){
                // t@CIuWFNgɊgq݂ꍇ͊gq؂̂
                oldFileName = getAbsolutePath().substring(0, getAbsolutePath().length() - (extension.length() + 1));
            } else {
                oldFileName = getAbsolutePath();
            }

            int num = 1; // ԍ̏l 1 ɐݒ
            String strNum = alias + num; // t@Cɕt镶 "alias + 1"

            String newFileName = oldFileName + strNum + "." + extension;
            while (new File(newFileName).exists()) {
                num++;
                strNum = alias + num;
                newFileName = oldFileName + strNum + "." + extension;
            }
   
            return newFileName;

        // t@C݂Ȃꍇ͂̂܂ܕԂB
        } else {
            return getAbsolutePath();
        }
    }
    


    /**
     * t@CsłȂ`ǂ`FbN܂B
     * <br><br>
     * ȉ̏ɓĂ͂܂Ƃst@CƔf܂B
     * <ol>
     * <li>null</li>
     * <li>0oCgi󕶎jA256oCgȏ</li>
     * <li>召ʂɓuCON.vuAUX.vuPRN.vuNUL.vn܂</li>
     * <li>gqOuCOM[0-9]vuLPT[0-9]v̂́i[0-9]0`9̂ǂꂩj</li>
     * <li>u/vu\vu:vu*vu?vu&quot;vu&lt;vu&gt;vu|v܂</li>
     * <li>u.vihbgj</li>
     * </ol>
     * 
     * @param fileName t@C
     * @return trueAsfalse
     * @since 2.0
     */
    public static boolean checkFileName(String fileName){

        // t@CnullfalseԂ
        if (fileName == null) {
            return false;
        }

        // t@C󕶎falseԂ
        if (fileName.length() < 1 || fileName.getBytes().length > 255) {
            return false;
        }

        String upperStr = fileName.toUpperCase();
        
        if (upperStr.startsWith("CON.")
                || upperStr.startsWith("AUX.")
                || upperStr.startsWith("PRN.")
                || upperStr.startsWith("NUL.")) {
            return false;
        }

        if(upperStr.matches("COM[0-9]\\..*") 
                || upperStr.matches("LPT[0-9]\\..*")
                || upperStr.matches("COM[0-9]")
                || upperStr.matches("LPT[0-9]")) {
            return false;
        }

        if (upperStr.indexOf("/") != -1 || upperStr.indexOf("\\") != -1
                || upperStr.indexOf(":") != -1 || upperStr.indexOf("*") != -1
                || upperStr.indexOf("?") != -1 || upperStr.indexOf("\"") != -1
                || upperStr.indexOf("<") != -1 || upperStr.indexOf(">") != -1
                || upperStr.indexOf("|") != -1) {
            return false;
        }

        // t@C̍Ōオ "." ͕s
        if (fileName.endsWith(".")) {
            return false;
        }
        return true;
    }

    
    /**
     * t@CIuWFNgƂ̃t@C̊gqw肵gqɕϊ܂B
     * IuWFNĝ݂݂̑ł΃IuWFNg̊gqϊ܂B
     * 
     * @param newExtension ϊgq
     * @return ϊtrueAsfalse
     * @throws IllegalArgumentException newExtensionnullÁu.v(hbg)̏ꍇ
     * @since 2.0
     */
    public boolean renameExtension(String newExtension) throws IllegalArgumentException {
        if(newExtension == null || newExtension.endsWith(".")){
            throw new IllegalArgumentException("Arguments are illegal-values.");
        }
        String newFilePath = null;
        String oldFilePath = getAbsolutePath();
        String oldExtension = getExtension();
        if (oldExtension.length() < 1) {
            if (newExtension.length() > 0) {
                newFilePath = oldFilePath + "." + newExtension;                
            } else {
                newFilePath = oldFilePath;
            }
        } else {
            if (newExtension.length() > 0) {
                newFilePath = oldFilePath.substring(0, oldFilePath.length() - oldExtension.length()) + newExtension;
            } else {
                newFilePath = oldFilePath.substring(0, oldFilePath.length() - oldExtension.length() - 1);
            }            
        }
        File newFile = null;
        try {
            newFile = new HFile(newFilePath);
        } catch (IOException e) {
            return false;
        }
        return renameTo(newFile);        
    }
    
    /**
     * ̃\bh͗pĂ͂Ȃ܂B
     * pꍇAFile#mkdir()Ɠs܂B
     * 
     * @deprecated ̃\bh͗pĂ͂Ȃ܂B
     * @since 2.0
     */
    public boolean mkdir() {
        return super.mkdir();
    }
    
    /**
     * ̃\bh͗pĂ͂Ȃ܂B
     * pꍇAFile#mkdirs()Ɠs܂B
     * 
     * @deprecated ̃\bh͗pĂ͂Ȃ܂B
     * @since 2.0
     */
    public boolean mkdirs() {
        return super.mkdirs();
    }

    /**
     * IuWFNgɊ֘AĂt@CXg[ɏo͂܂B
     * 
     * @param out o̓Xg[
     * @throws IOException
     *          IuWFNgɊ֘AĂt@C݂ȂA܂̓Xg[IOɎsꍇ
     * @throws NullPointerException
     *          outnull̏ꍇ
     * @since 2.0
     */
    public void copy(OutputStream out) throws IOException {
        FileInputStream is = null;
        try {
            if (!this.exists()) {
                throw new IOException("The file to have been in this object with the relation doesn't exist.");
            }
            is = new FileInputStream(this);
            copy(is, out);
        } finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /**
     * IuWFNgɊ֘AĂt@CRs[ƂăRs[܂B
     * Rs[Ƀt@C݂Ăꍇɏ㏑邱ƂȂOX[܂B
     * 
     * @param out Rs[t@C
     * @throws IOException
     *          outɑ݂A̓Rs[IOɎsꍇ
     * @throws NullPointerException
     *          outnull̏ꍇ
     * @since 2.0
     */
    public void copy(File out) throws IOException {
        copy(this, out);
    }
    
    /**
     * ̓Xg[o̓Xg[ɏo͂܂B
     * 
     * @param in ̓Xg[
     * @param out o̓Xg[
     * @throws IOException
     *          IOɎsꍇ
     * @throws NullPointerException
     *          inoutnull̏ꍇ
     * @since 2.0
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        if (in == null || out == null) {
            throw new NullPointerException("Stream-object is a null.");
        }
        int read;
        while ((read = in.read()) != -1) {
            out.write(read);
        }
        out.flush();
    }

    /**
     * t@CRs[܂B
     * Rs[Ƀt@C݂Ăꍇɏ㏑邱ƂȂOX[܂B
     * 
     * @param in Rs[t@C
     * @param out Rs[t@C
     * @throws IOException
     *          outɑ݂A̓Rs[IOɎsꍇ
     * @throws FileNotFoundException
     *          in݂Ȃꍇ
     * @throws NullPointerException
     *          inoutnull̏ꍇ
     * @since 2.0
     */
    public static void copy(File in, File out) throws IOException {
        copy(in, out, false);
    }

    /**
     * t@CRs[܂B
     * Rs[Ƀt@C݂Ăꍇɏ㏑邩ǂw肷邱Ƃł܂B
     * 
     * @param in Rs[t@C
     * @param out Rs[t@C
     * @param overwrite Ƀt@C݂Ăꍇɏ㏑Ȃ trueAOX[Ȃ false
     * @throws IOException
     *          outɑ݂A̓Rs[IOɎsꍇ
     * @throws FileNotFoundException
     *          in݂Ȃꍇ
     * @throws NullPointerException
     *          inoutnull̏ꍇ
     * @since 2.0
     */
    public static void copy(File in, File out, boolean overwrite) throws IOException {
        if (in == null || out == null) {
            throw new NullPointerException("File-object is a null.");
        }
        
        if (!in.exists()) {
            throw new FileNotFoundException("The input-file doesn't exist.");
        }        
        if (!overwrite) {
            if (out.exists()) {
                throw new IOException("The output-file exists already.");
            }
        }
        
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(in);
            os = new FileOutputStream(out);
            int read;
            while ((read = is.read()) != -1) {
                os.write(read);
            }
            os.flush();
        } finally {
            if (is != null) {
                try {
                    is.close();
                } finally {
                    if (os != null) {
                        os.close();
                    }
                }
            }
        }
    }
    

    private void constructor() throws IOException {
        if (exists() && isDirectory()) {
            throw new IOException("File is directory.");
        }
        if (checkFileName(getName()) == false) {
            throw new IOException("File-name is invalid.");
        }
    }
    
    /**
     * t@Cgq𒊏o܂B
     * ȂfBNgpX܂܂Ăꍇ͊gq𐳂擾邱Ƃ͂ł܂B
     * 
     * @param fileName t@C
     * @return ogq
     * @throws NullPointerException
     *          fileNamenull̏ꍇ
     * @since 2.0
     */
    public static String getExtension(String fileName) throws NullPointerException {
        if (fileName == null) {
            throw new NullPointerException("file name is null.");
        }
        int pDot = fileName.lastIndexOf(DOT);
        if(pDot == -1){
            return "";
        }
        return fileName.substring(pDot + 1);
    }
    
}
