package jp.hrtdotnet.java.util;

import java.util.Calendar;

import junit.framework.TestCase;

public class DateUtilTest extends TestCase {

    /* ( Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /* ( Javadoc)
     * @see junit.framework.TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getYesterday()} ̂߂̃eXgE\bhB
     */
    public void testGetYesterday() {
        Calendar c = DateUtil.getYesterday();
        System.out.println("Yesterday:" + c.get(Calendar.YEAR) + "-" + c.get(Calendar.MONTH) + "-" + c.get(Calendar.DAY_OF_MONTH));
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getYesterday(java.util.Calendar)} ̂߂̃eXgE\bhB
     */
    public void testGetYesterday_Calendar() {
        Calendar c = Calendar.getInstance();
        c.set(Calendar.YEAR, 2007);
        c.set(Calendar.MONTH, 0);
        c.set(Calendar.DAY_OF_MONTH, 1);
        Calendar c2 = DateUtil.getYesterday(c);
        assertEquals(c2.get(Calendar.YEAR), 2006);
        assertEquals(c2.get(Calendar.MONTH), 11);
        assertEquals(c2.get(Calendar.DAY_OF_MONTH), 31);
        c.set(Calendar.YEAR, 2007);
        c.set(Calendar.MONTH, 2);
        c.set(Calendar.DAY_OF_MONTH, 1);
        c2 = DateUtil.getYesterday(c);
        assertEquals(c2.get(Calendar.YEAR), 2007);
        assertEquals(c2.get(Calendar.MONTH), 1);
        assertEquals(c2.get(Calendar.DAY_OF_MONTH), 28);
        c.set(Calendar.YEAR, 2007);
        c.set(Calendar.MONTH, 0);
        c.set(Calendar.DAY_OF_MONTH, 7);
        c2 = DateUtil.getYesterday(c);
        assertEquals(c2.get(Calendar.YEAR), 2007);
        assertEquals(c2.get(Calendar.MONTH), 0);
        assertEquals(c2.get(Calendar.DAY_OF_MONTH), 6);
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getTomorrow()} ̂߂̃eXgE\bhB
     */
    public void testGetTomorrow() {
        Calendar c = DateUtil.getTomorrow();
        System.out.println("Tommorow:" + c.get(Calendar.YEAR) + "-" + c.get(Calendar.MONTH) + "-" + c.get(Calendar.DAY_OF_MONTH));
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getTomorrow(java.util.Calendar)} ̂߂̃eXgE\bhB
     */
    public void testGetTomorrow_Calendar() {
        Calendar c = Calendar.getInstance();
        c.set(Calendar.YEAR, 2006);
        c.set(Calendar.MONTH, 11);
        c.set(Calendar.DAY_OF_MONTH, 31);
        Calendar c2 = DateUtil.getTomorrow(c);
        assertEquals(c2.get(Calendar.YEAR), 2007);
        assertEquals(c2.get(Calendar.MONTH), 0);
        assertEquals(c2.get(Calendar.DAY_OF_MONTH), 1);
        c.set(Calendar.YEAR, 2007);
        c.set(Calendar.MONTH, 1);
        c.set(Calendar.DAY_OF_MONTH, 28);
        c2 = DateUtil.getTomorrow(c);
        assertEquals(c2.get(Calendar.YEAR), 2007);
        assertEquals(c2.get(Calendar.MONTH), 2);
        assertEquals(c2.get(Calendar.DAY_OF_MONTH), 1);
        c.set(Calendar.YEAR, 2007);
        c.set(Calendar.MONTH, 0);
        c.set(Calendar.DAY_OF_MONTH, 7);
        c2 = DateUtil.getTomorrow(c);
        assertEquals(c2.get(Calendar.YEAR), 2007);
        assertEquals(c2.get(Calendar.MONTH), 0);
        assertEquals(c2.get(Calendar.DAY_OF_MONTH), 8);
    }


    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getString(java.util.Calendar, java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testGetString_CalendarString() {
        Calendar c = Calendar.getInstance();
        System.out.println(DateUtil.getString(c, DateUtil.FORMAT_YYYYMMDD));
        c.set(Calendar.YEAR, 2007);
        c.set(Calendar.MONTH, 0);
        c.set(Calendar.DAY_OF_MONTH, 5);
        assertEquals(DateUtil.getString(c, DateUtil.FORMAT_YYYYMMDD), "20070105");
        assertEquals(DateUtil.getString(c, DateUtil.FORMAT_YYYYMM), "200701");
        assertEquals(DateUtil.getString(c, DateUtil.FORMAT_YYMMDD), "070105");
        assertEquals(DateUtil.getString(c, DateUtil.FORMAT_MMDD), "0105");
        assertEquals(DateUtil.getString(c, DateUtil.FORMAT_YYMM), "0701");
        assertEquals(DateUtil.getString(c, DateUtil.FORMAT_YYYY), "2007");
        assertEquals(DateUtil.getString(c, DateUtil.FORMAT_YY), "07");
        assertEquals(DateUtil.getString(c, DateUtil.FORMAT_MM), "01");
        assertEquals(DateUtil.getString(c, DateUtil.FORMAT_DD), "05");
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getString(java.util.Calendar)} ̂߂̃eXgE\bhB
     */
    public void testGetString_Calendar() {
        Calendar c = Calendar.getInstance();
        c.set(Calendar.YEAR, 2007);
        c.set(Calendar.MONTH, 0);
        c.set(Calendar.DAY_OF_MONTH, 5);
        assertEquals(DateUtil.getString(c), "20070105");
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getYesetdayString(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testGetYesetday_StringString() {
        Calendar c = DateUtil.getYesterday();
        assertEquals(DateUtil.getYesetdayString(DateUtil.FORMAT_YYYYMM), DateUtil.getString(c, DateUtil.FORMAT_YYYYMM));
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getYesetdayString()} ̂߂̃eXgE\bhB
     */
    public void testGetYesetday_String() {
        Calendar c = DateUtil.getYesterday();
        assertEquals(DateUtil.getYesetdayString(), DateUtil.getString(c));
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getTomorrowString(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testGetTomorrow_StringString() {
        Calendar c = DateUtil.getTomorrow();
        assertEquals(DateUtil.getTomorrowString(DateUtil.FORMAT_YYYYMM), DateUtil.getString(c, DateUtil.FORMAT_YYYYMM));
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getTomorrowString()} ̂߂̃eXgE\bhB
     */
    public void testGetTomorrow_String() {
        Calendar c = DateUtil.getTomorrow();
        assertEquals(DateUtil.getTomorrowString(), DateUtil.getString(c));
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getTodayString(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testGetToday_StringString() {
        Calendar c = Calendar.getInstance();
        assertEquals(DateUtil.getTodayString(DateUtil.FORMAT_YYYYMM), DateUtil.getString(c, DateUtil.FORMAT_YYYYMM));
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getTodayString()} ̂߂̃eXgE\bhB
     */
    public void testGetTodayString() {
        Calendar c = Calendar.getInstance();
        assertEquals(DateUtil.getTodayString(), DateUtil.getString(c));
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getLastMonth(java.util.Calendar)} ̂߂̃eXgE\bhB
     */
    public void testGetLastMonth_Calendar() {
        Calendar c = Calendar.getInstance();
        c.set(Calendar.YEAR, 2007);
        c.set(Calendar.MONTH, 0);
        c.set(Calendar.DAY_OF_MONTH, 5);
        c = DateUtil.getLastMonth(c);
        assertEquals(c.get(Calendar.YEAR), 2006);
        assertEquals(c.get(Calendar.MONTH), 11);
        assertEquals(c.get(Calendar.DAY_OF_MONTH), 5);
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getLastMonth()} ̂߂̃eXgE\bhB
     */
    public void testGetLastMonth() {
        Calendar c = DateUtil.getLastMonth();
        System.out.println(c.get(Calendar.YEAR) + "-" + c.get(Calendar.MONTH) + "-" + c.get(Calendar.DAY_OF_MONTH));
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getNextMonth(java.util.Calendar)} ̂߂̃eXgE\bhB
     */
    public void testGetNextMonth_Calendar() {
        Calendar c = Calendar.getInstance();
        c.set(Calendar.YEAR, 2007);
        c.set(Calendar.MONTH, 0);
        c.set(Calendar.DAY_OF_MONTH, 5);
        c = DateUtil.getNextMonth(c);
        assertEquals(c.get(Calendar.YEAR), 2007);
        assertEquals(c.get(Calendar.MONTH), 1);
        assertEquals(c.get(Calendar.DAY_OF_MONTH), 5);
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getNextMonth()} ̂߂̃eXgE\bhB
     */
    public void testGetNextMonth() {
        Calendar c = DateUtil.getNextMonth();
        System.out.println(c.get(Calendar.YEAR) + "-" + c.get(Calendar.MONTH) + "-" + c.get(Calendar.DAY_OF_MONTH));
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getLastMonthString(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testGetLastMonth_StringString() {
        Calendar c = DateUtil.getLastMonth();
        assertEquals(DateUtil.getLastMonthString(DateUtil.FORMAT_YYYYMMDD), DateUtil.getString(c, DateUtil.FORMAT_YYYYMMDD));
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getLastMonthString()} ̂߂̃eXgE\bhB
     */
    public void testGetLastMonth_String() {
        Calendar c = DateUtil.getLastMonth();
        assertEquals(DateUtil.getLastMonthString(), DateUtil.getString(c, DateUtil.FORMAT_YYYYMM));
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getNextMonthString(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testGetNextMonth_StringString() {
        Calendar c = DateUtil.getNextMonth();
        assertEquals(DateUtil.getNextMonthString(DateUtil.FORMAT_YYYYMMDD), DateUtil.getString(c, DateUtil.FORMAT_YYYYMMDD));
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getNextMonthString()} ̂߂̃eXgE\bhB
     */
    public void testGetNextMonth_String() {
        Calendar c = DateUtil.getNextMonth();
        assertEquals(DateUtil.getNextMonthString(), DateUtil.getString(c, DateUtil.FORMAT_YYYYMM));
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getThisMonthString(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testGetThisMonth_StringString() {
        Calendar c = Calendar.getInstance();
        assertEquals(DateUtil.getThisMonthString(DateUtil.FORMAT_YYYYMMDD), DateUtil.getString(c, DateUtil.FORMAT_YYYYMMDD));
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#getThisMonthString()} ̂߂̃eXgE\bhB
     */
    public void testGetThisMonthString() {
        Calendar c = Calendar.getInstance();
        assertEquals(DateUtil.getThisMonthString(), DateUtil.getString(c, DateUtil.FORMAT_YYYYMM));
    }

    /**
     * {@link jp.hrtdotnet.java.util.DateUtil#toDayOfWeek(java.lang.String)} ̂߂̃eXgE\bhB
     */
    public void testToDayOfWeek() {
        assertEquals(DateUtil.toDayOfWeek(""), Calendar.MONDAY);
        assertEquals(DateUtil.toDayOfWeek(""), Calendar.TUESDAY);
        assertEquals(DateUtil.toDayOfWeek(""), Calendar.WEDNESDAY);
        assertEquals(DateUtil.toDayOfWeek(""), Calendar.THURSDAY);
        assertEquals(DateUtil.toDayOfWeek(""), Calendar.FRIDAY);
        assertEquals(DateUtil.toDayOfWeek("y"), Calendar.SATURDAY);
        assertEquals(DateUtil.toDayOfWeek(""), Calendar.SUNDAY);
        try {
            DateUtil.toDayOfWeek("ZZZ");
            fail();
        } catch (IllegalArgumentException e) {            
        }
    }

}
