/*
 * IntegerUtil.java
 * 
 * Author: http://www.hrtdotnet.jp/
 * 
 */
package jp.hrtdotnet.java.util;

/**
 * Integer, intɊւ郆[eBeBNXłB
 * 
 * @version 2.0
 * @author hrtdotnet.jp
 * <br>http://www.hrtdotnet.jp/
 * @since 2.0
 */
public class IntegerUtil {

    /**
     * rbglɑ΂Ďw肵rbgtÕZbg̗L𔻒肵܂B
     * 
     * @param bitInteger rbgl
     * @param bitFlag rbgtO
     * @return ZbgĂꍇtrueAZbgĂȂꍇfalse
     * @since 2.0
     */
    public static boolean isBitFlag(int bitInteger, int bitFlag) {
        bitInteger = bitInteger ^ bitFlag;
        return (bitInteger & bitFlag) == 0;
    }

    /**
     * rbglɑ΂Ďw肵rbgtÕZbg/AZbgs܂B
     * tOZbgꍇAłɃZbgĂrbgtO͉ς܂B
     * tOAZbgꍇArbgtOZbgĂȂ̂łΉς܂B
     * 
     * @param bitInteger rbgl
     * @param bitFlag rbgtO
     * @param b ZbgꍇtrueAAZbgꍇfalse
     * @return Zbg/AZbgsrbgl
     * @since 2.0
     */
    public static int setBitFlag(int bitInteger, int bitFlag, boolean b) {
        bitInteger = bitInteger | bitFlag;
        if (!b) {
            bitInteger = bitInteger ^ bitFlag;
        }
        return bitInteger;
    }

    /**
     * rbglɑ΂Ďw肵rbgtÕZbg/AZbg𔽓]܂B
     * tOZbgĂꍇ̓AZbgAZbgĂȂꍇ̓Zbg܂B
     * 
     * @param bitInteger rbgl
     * @param bitFlag rbgtO
     * @return Zbg/AZbgsrbgl
     * @since 2.0
     */
    public static int setBitFlag(int bitInteger, int bitFlag) {
        bitInteger = bitInteger ^ bitFlag;
        return bitInteger;
    }
    
    /**
     * char^Ήint^̐lɕϊ܂B
     * w\ȕ݂͐̂łB
     * pESp̗ɑΉ܂B
     * 
     * @param c int^ɕϊchar
     * @return ϊll
     * @throws NumberFormatException
     *          cłȂꍇ
     * @since 2.0
     */
    public static int toNumber(char c) {
    
        // pɕϊ
        StringUtil.toSingleByteChar(c);
        
        if (c == '\u0030') return 0;
        else if (c == '\u0031') return 1;
        else if (c == '\u0032') return 2;
        else if (c == '\u0033') return 3;
        else if (c == '\u0034') return 4;
        else if (c == '\u0035') return 5;
        else if (c == '\u0036') return 6;
        else if (c == '\u0037') return 7;
        else if (c == '\u0038') return 8;
        else if (c == '\u0039') return 9;
        throw new NumberFormatException("Char is not a number.");
    }

    /**
     * int^lɕϊ܂B
     * ȊOw肷邱Ƃ͂ł܂B
     * Integer.parseInt𗘗pق̂ł𐄏܂B
     * 
     * @param str ɕϊ镶
     * @return ϊl
     * @throws IllegalArgumentException
     *          strłȂꍇ
     * @since 2.0
     */
    public static int toInt(String str) {
        if (!IntegerUtil.isInt(str)) {
            throw new IllegalArgumentException("Default value is not a integer.");
        }
        return Integer.parseInt(str);
    }

    /**
     * int^lɕϊ܂B
     * ȊOw肳ꂽꍇ0擾܂B
     * 
     * @param str ɕϊ镶
     * @return ϊl
     * @since 2.0
     */
    public static int toIntIgnoreError(String str) {
        return IntegerUtil.toInt(str, 0);
    }

    /**
     * int^lɕϊ܂B
     * ɐȊOw肳ꂽꍇ̓ftHgl擾܂B
     * 
     * @param str ɕϊ镶
     * @param defaultValue ftHglAȊOw肳ꂽꍇɕԂ
     * @return ϊl
     * @since 2.0
     */
    public static int toInt(String str, int defaultValue) {
        if (!IntegerUtil.isInt(str)) {
            return defaultValue;
        }
        return toInt(str);
    }

    /**
     * int^̎Rlɕϊ܂B
     * ̃\bhł̎R0ȏ̐lƂ܂B
     * ɎRȊOw肳ꂽꍇ̓ftHgl擾܂B
     * 
     * @param str Rɕϊ镶
     * @param defaultValue ftHglARȊOw肳ꂽꍇɕԂR
     * @return ϊRl
     * @throws IllegalArgumentException
     *          defaultValueRȊȌꍇ
     * @since 2.0
     */
    public static int toNatural(String str, int defaultValue) {
        if (defaultValue < 0) {
            throw new IllegalArgumentException("Default value is not a natural number.");
        }
        try {
            return IntegerUtil.toNatural(str);
        } catch (Exception e) {
        }
        return defaultValue;
    }

    /**
     * int^̎Rlɕϊ܂B
     * ̃\bhł̎R0ȏ̐lƂ܂B
     * RȊO͎wł܂B
     * 
     * @param str Rɕϊ镶
     * @return ϊRl
     * @throws IllegalArgumentException
     *          strRȊȌꍇ
     * @since 2.0
     */
    public static int toNatural(String str) {
        if (!IntegerUtil.isNumber(str)) {
            throw new IllegalArgumentException("Argument is not a natural number.");
        }
        return Integer.parseInt(str);
    }

    /**
     * int^̎Rlɕϊ܂B
     * ̃\bhł̎R0ȏ̐lƂ܂B
     * RȊO͎wł܂B
     * ɎRȊOw肳ꂽꍇ0擾܂B
     * 
     * @param str Rɕϊ镶
     * @return ϊRl
     * @since 2.0
     */
    public static int toNaturalIgnoreError(String str)  {
        return toNatural(str, 0);
    }

    /**
     * 񂪑Sp̐ǂ肵܂B
     * ͑Spƃ}CiXLip̂݁jłB
     * int^Ƃ͌܂B
     * 
     * @param str ̕
     * @return łtrueAłȂfalse
     * @since 2.0
     */
    public static boolean isInteger(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
    
        char[] c = str.toCharArray();
    
        for (int i = 0; i < c.length; i++) {
            if (IntegerUtil.isNumber(c[i]) == false) {                
                if(i == 0 && c[0] == '-' && c.length > 1) continue;
                return false;
            }
        }
    
        return true;
    }

    /**
     * 񂪔p̐ǂ肵܂B
     * ͔pƃ}CiXLip̂݁jłB
     * int^Ƃ͌܂B
     * 
     * @param str ̕
     * @return łtrueAłȂfalse
     * @since 2.0
     */    
    public static boolean isIntegerSingleByte(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        char[] c = str.toCharArray();
        for (int i = 0; i < c.length; i++) {
            if (IntegerUtil.isNumberSingleByte(c[i]) == false) {                
                if(i == 0 && c[0] == '-' && c.length > 1) continue;
                return false;
            }
        }
        return true;
    }

    /**
     * 񂪑Sp̐ǂ肵܂B
     * ͑Spƃ}CiXLiSp̂݁jłB
     * int^Ƃ͌܂B
     * 
     * @param str ̕
     * @return ł trueAłȂ false
     * @since 2.0
     */    
    public static boolean isIntegerMultiByte(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        char[] c = str.toCharArray();
        for (int i = 0; i < c.length; i++) {
            if (IntegerUtil.isNumberMultiByte(c[i]) == false) {                
                if(i == 0 && c.length > 1) {
                    if (c[0] == '\u2212' || c[0] == '\uFF0D') continue;
                }
                return false;
            }
        }
        return true;
    }

    /**
     * charSp̐ǂ肵܂B
     * ͔p[0-9]ƑSp[O-X]Ƃ܂B
     * 
     * @param c 肷镶
     * @return łtrueAłȂfalse
     * @since 2.0
     */
    public static boolean isNumber(char c) {            
        if ((c >= '\u0030' && c <= '\u0039') || (c >= '\uFF10' && c <= '\uFF19')){
                return true;
        }
        return false;
    }

    /**
     * charpǂ肵܂B
     * ͔p[0-9]Ƃ܂B
     * 
     * @param c 肷镶
     * @return łtrueAłȂfalse
     * @since 2.0
     */
    public static boolean isNumberSingleByte(char c) {            
        if (c >= '\u0030' && c <= '\u0039'){
                return true;
        }
        return false;
    }

    /**
     * charǂ肵܂B
     * Sp[O-X]Ƃ܂B
     * 
     * @param c 肷镶
     * @return łtrueAłȂfalse
     * @since 2.0
     */
    public static boolean isNumberMultiByte(char c) {            
        if (c >= '\uFF10' && c <= '\uFF19'){
                return true;
        }
        return false;
    }

    /**
     * 񂪐݂̂ō\Ă邩肵܂B
     * ͔p[0-9]ƑSp[O-X]Ƃ܂B
     * ܂KRIɎRǂ̔ƂȂ܂B
     * 
     * @param str 肷镶
     * @return łtrueAłȂfalse
     * @since 2.0
     */
    public static boolean isNumber(String str) {        
        if (str == null || str.length() < 1){
            return false;
        }        
        for (int i = 0; i < str.length(); i++) {
            if(!isNumber(str.charAt(i))){
                return false;
            }
        }
        return true;
    }

    /**
     * 񂪑Sp݂̂ō\Ă邩肵܂B
     * ͔p[0-9]ƑSp[O-X]Ƃ܂B
     * ܂KRIɎRǂ̔ƂȂ܂B
     * 
     * @param str 肷镶w肵܂B
     * @return łtrueAłȂfalseԂ܂B
     * @since 2.0
     */
    public static boolean isNumberMultiByte(String str) {
        
        if (str == null || str.length() < 1){
            return false;
        }
        
        for (int i = 0; i < str.length(); i++) {
            if(!isNumberMultiByte(str.charAt(i))){
                return false;
            }
        }
        return true;
    }

    /**
     * 񂪔p݂̂ō\Ă邩肵܂B
     * ͔p[0-9]Ƃ܂B
     * ܂KRIɎRǂ̔ƂȂ܂B
     * 
     * @param str ̕
     * @return łtrueAłȂfalse
     * @since 2.0
     */
    public static boolean isNumberSingleByte(String str) {
        
        if (str == null || str.length() < 1){
            return false;
        }
        
        for (int i = 0; i < str.length(); i++) {
            if(!isNumberSingleByte(str.charAt(i))){
                return false;
            }
        }
        return true;
    }

    /**
     * 񂪑Spint^̐ǂ肵܂B
     * ͑Spƃ}CiXLip̂݁jłB
     * 
     * @param str 肷镶
     * @return int^̐łtrueAłȂfalse
     * @since 2.0
     */
    public static boolean isInt(String str) {
        if (!isInteger(str)) {
            return false;
        }
        return isIntLocal(str);
    }

    /**
     * 񂪔pint^̐ǂ肵܂B
     * ͔pƃ}CiXLip̂݁jłB
     * 
     * @param str 肷镶
     * @return int^̐łtrueAłȂfalse
     * @since 2.0
     */
    public static boolean isIntSingleByte(String str) {
        if (!isIntegerSingleByte(str)) {
            return false;
        }
        return isIntLocal(str);
    }

    /**
     * 񂪑Spint^̐ǂ肵܂B
     * ͑Spƃ}CiXLiSp̂݁jłB
     * 
     * @param str 肷镶
     * @return int^̐łtrueAłȂfalse
     * @since 2.0
     */
    public static boolean isIntMultiByte(String str) {
        if (!isIntegerMultiByte(str)) {
            return false;
        }
        return isIntLocal(str);
    }

    
    // `FbN͂Ȃ
    private static boolean isIntLocal(String str) {
        if (!Comparison.comparisonIntegerLocal(str, Integer.toString(Integer.MIN_VALUE)) ) {
            return false;
        }
        if (!Comparison.comparisonIntegerLocal(Integer.toString(Integer.MAX_VALUE), str) ) {
            return false;
        }
        return true;
    }    
}
