/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.java.util;

import jp.hrtdotnet.java.util.IntegerUtil;
import jp.hrtdotnet.java.util.StringUtil;

public class Comparison {
    public static final int VERSION = 0;
    public static final int VERSION_SINCE = 1;
    public static final int VERSION_BEFORE = 2;
    public static final int OS_WINDOWS = 0;
    public static final int OS_LINUX = 1;

    public static boolean version(String version, String comparison, String delim, int param) {
        if (version == null || comparison == null || delim == null) {
            throw new NullPointerException("Arguments are null.");
        }
        if (version.length() == 0 || comparison.length() == 0 || delim.length() == 0) {
            throw new IllegalArgumentException("Arguments are illegal-values.");
        }
        if (param != 1 && param != 0 && param != 2) {
            throw new IllegalArgumentException("The param is invalid value.");
        }
        int[] intVersion = Comparison.getToIntArray(StringUtil.split(version, delim));
        int[] intComparison = Comparison.getToIntArray(StringUtil.split(comparison, delim));
        int len = Math.max(intVersion.length, intComparison.length);
        for (int i = 0; i < len; ++i) {
            int s;
            int v = i < intVersion.length ? intVersion[i] : 0;
            int n = s = i < intComparison.length ? intComparison[i] : 0;
            if (param == 1) {
                if (v < s) {
                    return false;
                }
                if (v <= s) continue;
                return true;
            }
            if (param == 2) {
                if (v > s) {
                    return false;
                }
                if (v >= s) continue;
                return true;
            }
            if (param != 0 || v == s) continue;
            return false;
        }
        return param == 1 || param == 0;
    }

    public static boolean os(int osParam) {
        String osName = System.getProperty("os.name");
        osName = osName.toLowerCase();
        if (osParam == 0) {
            if (osName.startsWith("windows")) {
                return true;
            }
        } else if (osParam == 1) {
            if (osName.startsWith("linux")) {
                return true;
            }
        } else {
            throw new IllegalArgumentException("The osParam is invalid value.");
        }
        return false;
    }

    private static int[] getToIntArray(String[] strArray) throws NumberFormatException {
        int[] intArray = new int[strArray.length];
        for (int i = 0; i < strArray.length; ++i) {
            intArray[i] = Integer.parseInt(strArray[i]);
        }
        return intArray;
    }

    public static boolean comparisonInteger(String big, String small) {
        if (!IntegerUtil.isInteger(big) || !IntegerUtil.isInteger(small)) {
            throw new NumberFormatException("Not a integer.");
        }
        return Comparison.comparisonIntegerLocal(big, small);
    }

    public static boolean equalsInteger(String str1, String str2) {
        if (!IntegerUtil.isInteger(str1) || !IntegerUtil.isInteger(str2)) {
            throw new NumberFormatException("Not a integer.");
        }
        return (str1 = StringUtil.toSingleByteString(str1)).compareTo(str2 = StringUtil.toSingleByteString(str2)) == 0;
    }

    static boolean comparisonIntegerLocal(String big, String small) {
        big = StringUtil.toSingleByteString(big);
        small = StringUtil.toSingleByteString(small);
        boolean bigSign = IntegerUtil.isNumber(big);
        boolean smallSign = IntegerUtil.isNumber(small);
        if (bigSign && !smallSign) {
            return true;
        }
        if (!bigSign && smallSign) {
            return false;
        }
        String a = null;
        String b = null;
        if (bigSign && smallSign) {
            a = big;
            b = small;
        } else {
            b = big.substring(1);
            a = small.substring(1);
        }
        if (a.length() > b.length()) {
            return true;
        }
        if (a.length() < b.length()) {
            return false;
        }
        for (int i = 0; i < a.length(); ++i) {
            if (IntegerUtil.toNumber(a.charAt(i)) < IntegerUtil.toNumber(b.charAt(i))) {
                return false;
            }
            if (IntegerUtil.toNumber(a.charAt(i)) <= IntegerUtil.toNumber(b.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

