/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.java.io;

import java.io.File;
import java.io.IOException;

public class HDirectory
extends File {
    private static final long serialVersionUID = -1822934435075769490L;

    public HDirectory(String directoryPath) throws IOException {
        super(directoryPath);
        if (this.exists() && this.isFile()) {
            throw new IOException("Directory is file.");
        }
        if (!HDirectory.checkDirectoryName(directoryPath)) {
            throw new IOException("Directory-path is invalid.");
        }
    }

    public static boolean checkDirectoryName(String directory) {
        if (directory == null || directory.length() < 1) {
            return false;
        }
        directory = directory.replaceAll("\\\\", "/");
        String[] dirArray = directory.split("/");
        for (int i = 0; i < dirArray.length; ++i) {
            if (dirArray[i] == null || dirArray.length < 1) continue;
            if (dirArray[i].length() > 255) {
                return false;
            }
            String upperStr = dirArray[i].toUpperCase();
            if (upperStr.startsWith("CON.") || upperStr.startsWith("AUX.") || upperStr.startsWith("PRN.") || upperStr.startsWith("NUL.")) {
                return false;
            }
            if (upperStr.matches("COM[0-9]\\..*") || upperStr.matches("LPT[0-9]\\..*") || upperStr.matches("COM[0-9]") || upperStr.matches("LPT[0-9]")) {
                return false;
            }
            if (!(i == 0 && upperStr.matches("[a-zA-Z]:")) && upperStr.indexOf(":") != -1) {
                return false;
            }
            if (upperStr.indexOf("*") != -1 || upperStr.indexOf("?") != -1 || upperStr.indexOf("\"") != -1 || upperStr.indexOf("<") != -1 || upperStr.indexOf(">") != -1 || upperStr.indexOf("|") != -1) {
                return false;
            }
            if (!dirArray[i].endsWith(".")) continue;
            return false;
        }
        return true;
    }

    public boolean createNewFile() throws IOException {
        return super.createNewFile();
    }
}

