/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.java.util;

import java.util.Timer;
import java.util.TimerTask;
import jp.hrtdotnet.java.util.MemoryCheckTimerTask;

public class SystemUtil {
    public static final int MAXIMIZE_USEDMEMORY_SIZE = 1;
    public static final int MAXIMIZE_USEDMEMORY_PERCENTAGE = 2;
    protected long maximizeMemorySize = 0L;
    protected int maximizeMemoryPercentage = 0;
    private int status = 0;
    private boolean maximizeUsedMemorySizeFlg = false;
    private boolean maximizeUsedMemoryPercentageFlg = false;
    private Timer timer;

    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static long getUsedMemory() {
        return SystemUtil.getTotalMemory() - SystemUtil.getFreeMemory();
    }

    public SystemUtil(int status, long maximizeMemorySize, int maximizeMemoryPercentage) {
        this.status = status;
        this.setStatus();
        this.maximizeMemorySize = maximizeMemorySize;
        if (this.maximizeUsedMemorySizeFlg && maximizeMemorySize <= 0L) {
            throw new IllegalArgumentException();
        }
        this.maximizeMemoryPercentage = maximizeMemoryPercentage;
        if (this.maximizeUsedMemoryPercentageFlg && maximizeMemoryPercentage <= 0) {
            throw new IllegalArgumentException();
        }
    }

    public boolean check() {
        if (this.maximizeUsedMemorySizeFlg && !this.usedMemorySizeCheck()) {
            return false;
        }
        return !this.maximizeUsedMemoryPercentageFlg || this.usedMemoryPercentageCheck();
    }

    public boolean usedMemorySizeCheck() {
        try {
            return SystemUtil.usedMemorySizeCheck(this.maximizeMemorySize);
        }
        catch (IllegalArgumentException et) {
            throw new IllegalStateException("The maximizeMemorySize is illegal status.");
        }
    }

    public static boolean usedMemorySizeCheck(long maximizeMemorySize) {
        if (maximizeMemorySize <= 0L) {
            throw new IllegalArgumentException("Memory-size <= 0.");
        }
        return maximizeMemorySize >= SystemUtil.getUsedMemory();
    }

    public boolean usedMemoryPercentageCheck() {
        try {
            return SystemUtil.usedMemoryPercentageCheck(this.maximizeMemoryPercentage);
        }
        catch (IllegalArgumentException et) {
            throw new IllegalStateException("The maximizeMemorySize is illegal status.");
        }
    }

    public static boolean usedMemoryPercentageCheck(int maximizeMemoryPercentage) {
        if (maximizeMemoryPercentage <= 0 || maximizeMemoryPercentage > 100) {
            throw new IllegalArgumentException("Memory-size <= 0 or Memory-size > 100.");
        }
        return !((double)maximizeMemoryPercentage < (double)SystemUtil.getUsedMemory() / (double)SystemUtil.getTotalMemory() * 100.0);
    }

    public synchronized void timerStart(long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException("Timer is equal to or less than 0 milliseconds.");
        }
        if (this.timer != null) {
            throw new IllegalStateException("Timer is starting now.");
        }
        MemoryCheckTimerTask tt = new MemoryCheckTimerTask(this);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)tt, 0L, period);
    }

    public synchronized void timerCancel() {
        if (this.timer == null) {
            throw new IllegalStateException("Timer is not starting now");
        }
        this.timer.cancel();
        this.timer = null;
    }

    public synchronized boolean isRunTimer() {
        return this.timer != null;
    }

    protected void setStatus() {
        int stat = this.status;
        if (stat % 2 == 1) {
            this.maximizeUsedMemorySizeFlg = true;
        }
        if ((stat /= 2) % 2 == 1) {
            this.maximizeUsedMemoryPercentageFlg = true;
        }
    }

    protected void runCheckFalse() {
    }

    protected void runCheckTrue() {
    }
}

