/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.java.net;

import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;

public class HttpUtil {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String HTTP2 = "http://";
    private static final String HTTPS2 = "https://";
    private static final String DELIMITER = "/";
    private static final String DOT = ".";

    private HttpUtil() {
    }

    public static void setReferer(HttpURLConnection connection, String referer) {
        if (connection == null) {
            throw new NullPointerException("HttpURLConnection-object is null.");
        }
        connection.setRequestProperty("Referer", referer);
    }

    public static String getReferer(HttpURLConnection connection) {
        if (connection == null) {
            throw new NullPointerException("HttpURLConnection-object is null.");
        }
        return connection.getRequestProperty("Referer");
    }

    public static void setUserAgent(HttpURLConnection connection, String userAgent) {
        if (connection == null) {
            throw new NullPointerException("HttpURLConnection-object is null.");
        }
        connection.setRequestProperty("User-Agent", userAgent);
    }

    public static String getUserAgent(HttpURLConnection connection) {
        if (connection == null) {
            throw new NullPointerException("HttpURLConnection-object is null.");
        }
        return connection.getRequestProperty("User-Agent");
    }

    public static void setAuthentication(String user, String pass) {
        if (user == null) {
            throw new NullPointerException("User is null.");
        }
        if (pass == null) {
            throw new NullPointerException("Pass is null.");
        }
        class InAuth
        extends Authenticator {
            private final /* synthetic */ String val$user;
            private final /* synthetic */ String val$pass;

            InAuth(String val$user, String val$pass) {
                this.val$user = val$user;
                this.val$pass = val$pass;
            }

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(this.val$user, this.val$pass.toCharArray());
            }
        }
        InAuth auth = new InAuth(user, pass);
        Authenticator.setDefault(auth);
    }

    public static boolean checkFormat(String url) {
        if (url == null) {
            throw new NullPointerException("URL is null.");
        }
        String lUrl = url.toLowerCase();
        return lUrl.startsWith(HTTP2) || lUrl.startsWith(HTTPS2);
        {
        }
    }

    public static boolean checkProtocol(URL url) throws NullPointerException {
        if (url == null) {
            throw new NullPointerException("URL is null.");
        }
        return HttpUtil.checkProtocol(url.getProtocol());
    }

    public static boolean checkProtocol(String protocol) {
        if (protocol == null) {
            throw new NullPointerException("Protocol is null.");
        }
        if (protocol.compareToIgnoreCase(HTTP) == 0) {
            return true;
        }
        return protocol.compareToIgnoreCase(HTTPS) == 0;
    }

    public static String getExtension(String url) throws NullPointerException, IllegalArgumentException {
        if (url == null) {
            throw new NullPointerException("URL is null.");
        }
        String extension = null;
        String lUrl = url.toLowerCase();
        if (lUrl.startsWith(HTTP2)) {
            extension = HttpUtil.getExtension2(url, HTTP2);
        } else if (lUrl.startsWith(HTTPS2)) {
            extension = HttpUtil.getExtension2(url, HTTPS2);
        } else {
            throw new IllegalArgumentException("URL is not a http-format.");
        }
        return extension;
    }

    private static String getExtension2(String url, String protocol) {
        StringBuffer sbUrl = new StringBuffer(url);
        if (sbUrl.length() > protocol.length()) {
            sbUrl.delete(0, protocol.length());
            int pos = sbUrl.lastIndexOf(DELIMITER);
            if (pos == -1 && protocol.length() > 0) {
                return null;
            }
            if (pos == sbUrl.length() - 1) {
                return null;
            }
            if (pos == -1) {
                pos = 0;
            }
            sbUrl.delete(0, pos + 1);
            pos = sbUrl.lastIndexOf(DOT);
            if (pos == -1) {
                return "";
            }
            if (pos == sbUrl.length() - 1) {
                return "";
            }
            return sbUrl.delete(0, pos + 1).toString();
        }
        throw new IllegalArgumentException("url is not a " + protocol);
    }

    public static boolean isHttpUrl(String str) {
        if (str == null) {
            return false;
        }
        return (str = str.toLowerCase()).startsWith(HTTP2) || str.startsWith(HTTPS2);
    }
}

