/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.java.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HFile
extends File {
    private static final long serialVersionUID = -8719547187991724396L;
    private static final String DOT = ".";

    public HFile(String filePath) throws IOException {
        super(filePath);
        this.constructor();
    }

    public HFile(String parent, String child) throws IOException {
        super(parent, child);
        this.constructor();
    }

    public String getExtension() {
        String fileName = this.getName();
        return HFile.getExtension(fileName);
    }

    public String getOtherFileName(String alias, int digit) {
        String extension = this.getExtension();
        if (alias == null || alias.length() < 1 || digit <= 0) {
            return this.getAbsolutePath();
        }
        if (this.exists()) {
            String oldFileName = null;
            oldFileName = extension.length() > 0 ? this.getAbsolutePath().substring(0, this.getAbsolutePath().length() - (extension.length() + 1)) : this.getAbsolutePath();
            String strNum = alias;
            for (int i = 0; i < digit; ++i) {
                strNum = strNum + "0";
            }
            String newFileName = oldFileName + strNum + DOT + extension;
            if (new File(newFileName).exists()) {
                int num = (int)Math.pow(10.0, digit);
                for (int i = 1; i < num; ++i) {
                    strNum = alias;
                    newFileName = oldFileName;
                    for (int j = digit - 1; j > 0 && i / (int)Math.pow(10.0, j) == 0; --j) {
                        strNum = strNum + "0";
                    }
                    if (!new File(newFileName = newFileName + strNum + i + DOT + extension).exists()) break;
                }
            }
            return newFileName;
        }
        return this.getAbsolutePath();
    }

    public String getOtherFileName(String alias) {
        String extension = this.getExtension();
        if (alias == null || alias.length() < 1) {
            return this.getAbsolutePath();
        }
        if (this.exists()) {
            String oldFileName = null;
            oldFileName = extension.length() > 0 ? this.getAbsolutePath().substring(0, this.getAbsolutePath().length() - (extension.length() + 1)) : this.getAbsolutePath();
            int num = 1;
            String strNum = alias + num;
            String newFileName = oldFileName + strNum + DOT + extension;
            while (new File(newFileName).exists()) {
                strNum = alias + ++num;
                newFileName = oldFileName + strNum + DOT + extension;
            }
            return newFileName;
        }
        return this.getAbsolutePath();
    }

    public static boolean checkFileName(String fileName) {
        if (fileName == null) {
            return false;
        }
        if (fileName.length() < 1 || fileName.getBytes().length > 255) {
            return false;
        }
        String upperStr = fileName.toUpperCase();
        if (upperStr.startsWith("CON.") || upperStr.startsWith("AUX.") || upperStr.startsWith("PRN.") || upperStr.startsWith("NUL.")) {
            return false;
        }
        if (upperStr.matches("COM[0-9]\\..*") || upperStr.matches("LPT[0-9]\\..*") || upperStr.matches("COM[0-9]") || upperStr.matches("LPT[0-9]")) {
            return false;
        }
        if (upperStr.indexOf("/") != -1 || upperStr.indexOf("\\") != -1 || upperStr.indexOf(":") != -1 || upperStr.indexOf("*") != -1 || upperStr.indexOf("?") != -1 || upperStr.indexOf("\"") != -1 || upperStr.indexOf("<") != -1 || upperStr.indexOf(">") != -1 || upperStr.indexOf("|") != -1) {
            return false;
        }
        return !fileName.endsWith(DOT);
    }

    public boolean renameExtension(String newExtension) throws IllegalArgumentException {
        if (newExtension == null || newExtension.endsWith(DOT)) {
            throw new IllegalArgumentException("Arguments are illegal-values.");
        }
        String newFilePath = null;
        String oldFilePath = this.getAbsolutePath();
        String oldExtension = this.getExtension();
        newFilePath = oldExtension.length() < 1 ? (newExtension.length() > 0 ? oldFilePath + DOT + newExtension : oldFilePath) : (newExtension.length() > 0 ? oldFilePath.substring(0, oldFilePath.length() - oldExtension.length()) + newExtension : oldFilePath.substring(0, oldFilePath.length() - oldExtension.length() - 1));
        HFile newFile = null;
        try {
            newFile = new HFile(newFilePath);
        }
        catch (IOException e) {
            return false;
        }
        return this.renameTo(newFile);
    }

    public boolean mkdir() {
        return super.mkdir();
    }

    public boolean mkdirs() {
        return super.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(OutputStream out) throws IOException {
        FileInputStream is = null;
        try {
            if (!this.exists()) {
                throw new IOException("The file to have been in this object with the relation doesn't exist.");
            }
            is = new FileInputStream(this);
            HFile.copy(is, out);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void copy(File out) throws IOException {
        HFile.copy(this, out);
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        if (in == null || out == null) {
            throw new NullPointerException("Stream-object is a null.");
        }
        while ((read = in.read()) != -1) {
            out.write(read);
        }
        out.flush();
    }

    public static void copy(File in, File out) throws IOException {
        HFile.copy(in, out, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copy(File in, File out, boolean overwrite) throws IOException {
        if (in == null || out == null) {
            throw new NullPointerException("File-object is a null.");
        }
        if (!in.exists()) {
            throw new FileNotFoundException("The input-file doesn't exist.");
        }
        if (!overwrite && out.exists()) {
            throw new IOException("The output-file exists already.");
        }
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            int read;
            is = new FileInputStream(in);
            os = new FileOutputStream(out);
            while ((read = is.read()) != -1) {
                os.write(read);
            }
            os.flush();
            Object var7_6 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
        try {
            is.close();
            return;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private void constructor() throws IOException {
        if (this.exists() && this.isDirectory()) {
            throw new IOException("File is directory.");
        }
        if (!HFile.checkFileName(this.getName())) {
            throw new IOException("File-name is invalid.");
        }
    }

    public static String getExtension(String fileName) throws NullPointerException {
        if (fileName == null) {
            throw new NullPointerException("file name is null.");
        }
        int pDot = fileName.lastIndexOf(DOT);
        if (pDot == -1) {
            return "";
        }
        return fileName.substring(pDot + 1);
    }
}

