// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		GUIUtility.java
//	DATE:		2003.6.4
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.framework.util;

import java.awt.Component;
import java.io.File;

/**
 *	GUIɊւUtility֐Q
 */
public class GUIUtility {
	public static final String INITIAL_TITLE = "<untitled>";
	
	/**
	 *	w肵Componentʒɔzu
	 */
	public static void LayoutToCenter(java.awt.Component inCompo) {
		java.awt.Dimension dialogSize = inCompo.getSize();
		java.awt.Dimension screenSize = getEffectiveScreenSize();

		inCompo.setLocation(
				(screenSize.width-dialogSize.width)/2,
				(screenSize.height-dialogSize.height)/2);
	
	}
	
	/**
	 *	XN[̗LTCYvZ
	 *	LTCYƂ́AWindows̏ꍇA^XNo[TCYł
	 *
	 *	@return	LXN[TCY
	 */
	public static java.awt.Dimension getEffectiveScreenSize() {
		java.awt.GraphicsEnvironment aEnv = 
			java.awt.GraphicsEnvironment.getLocalGraphicsEnvironment();
		
		java.awt.GraphicsConfiguration aConf =
			aEnv.getDefaultScreenDevice().getDefaultConfiguration();
		
		java.awt.Toolkit aKit = java.awt.Toolkit.getDefaultToolkit();
		
		// ScreenInsetsiTaskBar̃TCYjo		
		java.awt.Insets aInsets = aKit.getScreenInsets(aConf);
		
		// Screen sizeo
		java.awt.Dimension aSize = aKit.getScreenSize();

		return new java.awt.Dimension(
			aSize.width-aInsets.left-aInsets.right, 
			aSize.height-aInsets.top-aInsets.bottom
		);
	} 
	
	/**
	 *	FileChooser쐬
	 *	̎ł́Acurrent directory ./problem ƂĂ
	 *
	 *	@return	javax.swing.JFileChooser
	 */
	public static javax.swing.JFileChooser createFileChooser() {
		final javax.swing.JFileChooser aChooser = new javax.swing.JFileChooser() {
			public void approveSelection() {
				// Save{^ƂAw肵t@Cɑ݂ƂAlerto
				// ݂Ȃꍇ́Aʏǂ̎sB
				File aOutFile = getSelectedFile();
				if (! aOutFile.exists()) {
					super.approveSelection();
					return;
				}

				final int aSignal = GUIUtility.showFileExsitingNotice(this, aOutFile.getAbsolutePath());
				
				if (aSignal == javax.swing.JOptionPane.NO_OPTION) return;
				
				super.approveSelection();
			}
		};
		
		// current directoryZbg
		aChooser.setCurrentDirectory(new File("problem"));

		// FileFilterZbg	 
		aChooser.setFileFilter(new javax.swing.filechooser.FileFilter() 
		{
			public boolean accept(java.io.File inFile) {
				if (inFile.isDirectory()) return true;
				
				final int aIndex = inFile.getName().toLowerCase().indexOf(".xml");

				return (0 < aIndex) ? true : false;
			}
			
			public String getDescription() {
				return "XML file (version 1.0)";
			}
		});				
		
		return aChooser;
	}
	
	/**
	 *	Board̕ύXt@CɕۑOɃEChEꂽꍇ
	 *	܂́Aʂ̃t@Cǂݍ܂悤ƂꍇA
	 *	t@Cɕۑ邩ǂq˂_CAO\
	 *
	 *	@param	inOwner	̃_CAÕI[i[R|[lg
	 *	@param	inFileName ۑƂȂt@C
	 *	@param	inIsClosing frameclosełtruen
	 *
	 *	@return	Iꂽ{^ɑ΂VOilԂBVOil͈ȉ3ނB
	 *			javax.swing.JOptionPane.YES_OPTION 		ۑꍇɕԂB
	 *			javax.swing.JOptionPane.NO_OPTION 		ۑȂꍇɕԂB
	 *			javax.swing.JOptionPane.CANCEL_OPTION 	鏈LZꍇɕԂB
	 */		
	public static int showBoardModifiedNotice(Component inOwner, String inFileName, boolean inIsClosing) {
		StringBuffer aBuf = new StringBuffer(128);
		
		aBuf.append("t@C").append(inFileName).append("͕ύXĂ܂B\n");
		if (inIsClosing) {
			aBuf.append("O");
		}
		aBuf.append("ۑ܂ ?");
		
		String aMessage = new String(aBuf);
		String aTitle = ""; 
		
		return javax.swing.JOptionPane.showConfirmDialog(
								inOwner, aMessage, aTitle, 
								javax.swing.JOptionPane.YES_NO_CANCEL_OPTION, 
								javax.swing.JOptionPane.WARNING_MESSAGE
		);
	}
	
	/**
	 *	ۑt@Cɑ݂ĂꍇɁA
	 *	㏑邩ǂq˂_CAO\
	 *
	 *	@return	Iꂽ{^ɑ΂VOilԂBVOil͈ȉ3ނB
	 *			javax.swing.JOptionPane.YES_OPTION 		㏑ꍇɕԂB
	 *			javax.swing.JOptionPane.NO_OPTION 		㏑ȂꍇɕԂB
	 */		
	public static int showFileExsitingNotice(Component inOwner, String inFileName) {
		String aMessage = 
				inFileName 
				+ "t@C͊ɑ݂܂B\nۑ܂ ?";
		String aTitle = "Oĕۑ";
		
		return javax.swing.JOptionPane.showConfirmDialog(
								inOwner, aMessage, aTitle, 
								javax.swing.JOptionPane.YES_NO_OPTION, 
								javax.swing.JOptionPane.WARNING_MESSAGE
		);
	}
}