// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		UtilityFuncs.java
//	DATE:		2003.5.12	initial version
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.util;

import java.awt.event.KeyEvent;

import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

public class UtilityFuncs {
	private static final Direction[] DIRECTIONS = {
		Direction.WEST, Direction.EAST, 
		Direction.NORTH, Direction.SOUTH, 
	};
	
	/** 
	 *	󔒏Ԃł邱ƂAStateEventCodeԂ
	 *
	 *	@return	StateEventCode̎
	 */
	public static StateEventCode createSpaceCode() {
		return HashikakeStateEventCode.createSpaceCode();
	}
	
	/** 
	 *	w肵ɑΉAStateEventCodeԂ
	 *
	 *	@return	StateEventCode̎
	 */
	public static StateEventCode createNumberCodeOf(final int inNum) {
		return HashikakeStateEventCode.createNumberCodeOf(inNum);
	}
	
	/**
	 *	IꂽɑΉAStateEventCodeԂ
	 *
	 *	@param	inDirection 
	 *	@return	StateEventCode̎
	 */
	public static StateEventCode getSelectDirectionEventCode(Direction inDirection) {
		return DirectionStateEventCode.createSelectDirectionCode(inDirection);
	}
	
	/**
	 *	肳ꂽɑΉAStateEventCodeԂ
	 *
	 *	@param	inDirection 
	 *	@return	StateEventCode̎
	 */
	public static StateEventCode getDetermineDirectionEventCode(Direction inDirection) {
		return DirectionStateEventCode.createDetermineDirectionCode(inDirection);
	}

	/**
	 *	w肳ꂽStateEventCodeDirectionStateEventCodełAIԂł邩ǂ`FbN
	 *
	 *	@param	CxgR[h
	 *	@return	DirectionStateEventCode̎̂ł΁AtrueԂ
	 */
	public static boolean isSelectionType(StateEventCode inEventCode) {
		if (inEventCode instanceof DirectionStateEventCode) {
			return DirectionStateEventCode.isSelectionType((DirectionStateEventCode)inEventCode);
		}
		
		return false;
	}
	
	/**
	 *	w肳ꂽStateEventCodeDirectionStateEventCodełAԂł邩ǂ`FbN
	 *
	 *	@param	CxgR[h
	 *	@return	DirectionStateEventCode̎̂ł΁AtrueԂ
	 */
	public static boolean isDeterminationType(StateEventCode inEventCode) {
		if (inEventCode instanceof DirectionStateEventCode) {
			return DirectionStateEventCode.isDeterminationType((DirectionStateEventCode)inEventCode);
		}
		
		return false;
	}
	
	/**
	 *	IԂɑΉStateEventCodeԂ
	 *
	 *	@return	StateEventCode̎
	 */
	public static StateEventCode getSelectionEventCode() {
		return SelectionStateEventCode.getInstance();
	}
	
	/**
	 *	w肵J[\L[key codeɑΉԂ
	 *	Ȃꍇ́ADirection.NOԂ
	 *
	 *	@param	inKeyCode key code
	 *	@return	key codeɑΉ
	 */
	public static Direction resolveDirectionOf(final int inKeyCode) {
		if (inKeyCode == KeyEvent.VK_LEFT) return Direction.WEST;
		if (inKeyCode == KeyEvent.VK_RIGHT) return Direction.EAST;
		if (inKeyCode == KeyEvent.VK_UP) return Direction.NORTH;
		if (inKeyCode == KeyEvent.VK_DOWN) return Direction.SOUTH;
		
		return Direction.NO;
	}
	
	/**
	 *	CxgR[ho
	 *	DirectionStateEventCodẽCX^XłȂꍇA
	 *	Direction.NOԂ
	 *
	 *	@param	inEventCode	CxgR[h
	 *	@return	
	 */
	public static Direction resolveDirectionOf(StateEventCode inEventCode) {
		if (inEventCode instanceof DirectionStateEventCode) {
			return ((DirectionStateEventCode)inEventCode).getDirection();
		}
		
		return Direction.NO;
	}
	
	/**
	 *	@return	w肵Ƌt̕Ԃ
	 */
	public static Direction inverseDirection(Direction inDirection) {
		if (Direction.WEST == inDirection) return Direction.EAST;
		if (Direction.EAST == inDirection) return Direction.WEST;
		if (Direction.NORTH == inDirection) return Direction.SOUTH;
		if (Direction.SOUTH == inDirection) return Direction.NORTH;
		
		if (Direction.NORTH_WEST == inDirection) return Direction.SOUTH_EAST;
		if (Direction.NORTH_EAST == inDirection) return Direction.SOUTH_WEST;
		if (Direction.SOUTH_WEST == inDirection) return Direction.NORTH_EAST;
		if (Direction.SOUTH_EAST == inDirection) return Direction.NORTH_WEST;
		
		return Direction.NO;
	}
	
	/**
	 *	w肵X, Y̒PʕԂ
	 *	ԂlɂāAꂼDirection[0]XADirection[1]Yi[Ă
	 *	PʕƈvȂꍇADirection.NOi[
	 *
	 *	ex)
	 *	Direction.NORTH_EAST => [0] : Direction.EAST, [1] : Direction.NORTH
	 *	Direction.SOUTH      => [0] : Direction.NO,   [1] : Direction.SOUTH
	 */
	public static Direction[] getUnitDirection(Direction inDirection) {
		Direction[] aUnit = new Direction[] {Direction.NO, Direction.NO};
		
		java.awt.Point aDiff = inDirection.getDifference();
		
		for (int i = 0; i < DIRECTIONS.length; ++i) {
			java.awt.Point aUnitDiff = DIRECTIONS[i].getDifference();
			
			if (aDiff.x != 0 && aDiff.x == aUnitDiff.x) {
				aUnit[0] = DIRECTIONS[i];
			}
			if (aDiff.y != 0 && aDiff.y == aUnitDiff.y) {
				aUnit[1] = DIRECTIONS[i];
			}
		}
		
		return aUnit;
	}
}
