/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.framework.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class GUIUtility {
    public static final String INITIAL_TITLE = "<untitled>";

    public static void LayoutToCenter(Component inCompo) {
        Dimension dialogSize = inCompo.getSize();
        Dimension screenSize = GUIUtility.getEffectiveScreenSize();
        inCompo.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    public static Dimension getEffectiveScreenSize() {
        GraphicsEnvironment aEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration aConf = aEnv.getDefaultScreenDevice().getDefaultConfiguration();
        Toolkit aKit = Toolkit.getDefaultToolkit();
        Insets aInsets = aKit.getScreenInsets(aConf);
        Dimension aSize = aKit.getScreenSize();
        return new Dimension(aSize.width - aInsets.left - aInsets.right, aSize.height - aInsets.top - aInsets.bottom);
    }

    public static JFileChooser createFileChooser() {
        JFileChooser aChooser = new JFileChooser(){

            public void approveSelection() {
                File aOutFile = this.getSelectedFile();
                if (!aOutFile.exists()) {
                    super.approveSelection();
                    return;
                }
                int aSignal = GUIUtility.showFileExsitingNotice(this, aOutFile.getAbsolutePath());
                if (aSignal == 1) {
                    return;
                }
                super.approveSelection();
            }
        };
        aChooser.setCurrentDirectory(new File("problem"));
        aChooser.setFileFilter(new FileFilter(){

            public boolean accept(File inFile) {
                if (inFile.isDirectory()) {
                    return true;
                }
                int aIndex = inFile.getName().toLowerCase().indexOf(".xml");
                return 0 < aIndex;
            }

            public String getDescription() {
                return "XML file (version 1.0)";
            }
        });
        return aChooser;
    }

    public static int showBoardModifiedNotice(Component inOwner, String inFileName, boolean inIsClosing) {
        StringBuffer aBuf = new StringBuffer(128);
        aBuf.append("\u30d5\u30a1\u30a4\u30eb").append(inFileName).append("\u306f\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059\u3002\n");
        if (inIsClosing) {
            aBuf.append("\u9589\u3058\u308b\u524d\u306b");
        }
        aBuf.append("\u4fdd\u5b58\u3057\u307e\u3059\u304b ?");
        String aMessage = new String(aBuf);
        String aTitle = "";
        return JOptionPane.showConfirmDialog(inOwner, aMessage, aTitle, 1, 2);
    }

    public static int showFileExsitingNotice(Component inOwner, String inFileName) {
        String aMessage = inFileName + "\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002\n\u4fdd\u5b58\u3057\u307e\u3059\u304b ?";
        String aTitle = "\u540d\u524d\u3092\u3064\u3051\u3066\u4fdd\u5b58";
        return JOptionPane.showConfirmDialog(inOwner, aMessage, aTitle, 0, 2);
    }
}

