/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.fsm;

import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.AbstractState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.ColorState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.DefaultColorState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberState;

public class HashikakeNumberState
implements State {
    private State mNumberState;
    private AdjacentState[] mAdjacent;
    private State mColorState = new DefaultColorState();

    public HashikakeNumberState(State state, State state2) {
        if (!(state instanceof NumberState)) {
            throw new IllegalArgumentException("A specifiying state should be NumberState(passed state : " + state.getClass() + ")");
        }
        this.mNumberState = state;
        this.mAdjacent = new AdjacentState[]{new AdjacentState(state2, Direction.NORTH), new AdjacentState(state2, Direction.SOUTH), new AdjacentState(state2, Direction.WEST), new AdjacentState(state2, Direction.EAST)};
    }

    public State getNumberState() {
        return this.mNumberState;
    }

    public AdjacentState getAdjacentAt(int n) {
        return this.mAdjacent[n];
    }

    public AdjacentState findAdjacentOf(Direction direction) {
        for (int i = 0; i < this.mAdjacent.length; ++i) {
            if (this.mAdjacent[i].getDirection() != direction) continue;
            return this.mAdjacent[i];
        }
        return null;
    }

    public int getAdjacentCount() {
        return this.mAdjacent.length;
    }

    public void setColorState(ColorState colorState) {
        this.mColorState = colorState;
    }

    public State getColorState() {
        return this.mColorState;
    }

    public State onEnter(StateEventCode stateEventCode) {
        return this;
    }

    public static class AdjacentState
    extends AbstractState {
        private State mState;
        private Direction mDirection;

        public AdjacentState(State state, Direction direction) {
            this.mState = state;
            this.mDirection = direction;
        }

        public State getState() {
            return this.mState;
        }

        public void setState(State state) {
            this.mState = state;
        }

        public Direction getDirection() {
            return this.mDirection;
        }
    }
}

