/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.bench.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.BenchmarkMediator;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.Colleague;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.view.DirectoryChooser;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.view.HashikakeBenchmarkMediator;

public class HashikakeBench
extends JFrame {
    private static final int DEFAULT_SOLVE_COUNT = 5;
    private static final String DEFAULT_DIRECTORY = "problem";
    private LabeledTextField mSolvedDirField;
    private LabeledTextField mSolveCountField;
    private boolean mCountEnabled;

    protected void frameInit() {
        super.frameInit();
        this.setTitle("Hashikake benchmark tester");
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = null;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        Object object = new File(DEFAULT_DIRECTORY).getAbsolutePath();
        this.mSolvedDirField = new LabeledTextField("folder : ", (String)object, 24);
        container.add((Component)this.mSolvedDirField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        object = new JButton("...");
        ((AbstractButton)object).setMargin(new Insets(2, 2, 2, 2));
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = HashikakeBench.this.mSolvedDirField.getText();
                File file = DirectoryChooser.chooseDirectory((JButton)actionEvent.getSource(), new File(string));
                HashikakeBench.this.mSolvedDirField.setText(file.getAbsolutePath());
            }
        });
        container.add((Component)object, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        object = new JCheckBox("specifies measurment count");
        ((AbstractButton)object).addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                HashikakeBench.this.mCountEnabled = !HashikakeBench.this.mSolveCountField.isEnabled();
                HashikakeBench.this.mSolveCountField.setEnabled(HashikakeBench.this.mCountEnabled);
            }
        });
        container.add((Component)object, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        this.mSolveCountField = new LabeledTextField("times : ", String.valueOf(5), 3);
        this.mSolveCountField.setEnabled(false);
        container.add((Component)this.mSolveCountField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        container.add((Component)new JCheckBox("measuring both reset and solve time", true), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        object = new ButtonColleague();
        container.add((Component)object, gridBagConstraints);
        ((AbstractButton)object).setText("start");
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = HashikakeBench.this.mSolvedDirField.getText();
                int n = 5;
                if (HashikakeBench.this.mCountEnabled) {
                    try {
                        n = Integer.parseInt(HashikakeBench.this.mSolveCountField.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                File file = new File(string);
                BenchmarkMediator benchmarkMediator = HashikakeBenchmarkMediator.getInstance((Component)actionEvent.getSource());
                benchmarkMediator.addColleague((Colleague)actionEvent.getSource());
                benchmarkMediator.start(file, n);
            }
        });
    }

    private static class ButtonColleague
    extends JButton
    implements Colleague {
        private ButtonColleague() {
        }

        public void setUp() {
            this.setEnabled(false);
        }

        public void cleanUp() {
            this.setEnabled(true);
        }

        public void update() {
        }
    }

    private static class LabeledTextField
    extends JComponent {
        private JTextField mField;

        public LabeledTextField(String string, String string2, int n) {
            this.setLayout(new FlowLayout());
            this.add(new JLabel(string));
            this.mField = new JTextField(string2, n);
            this.add(this.mField);
        }

        public LabeledTextField(Document document, String string, String string2, int n) {
            this(string, string2, n);
            this.mField.setDocument(document);
        }

        public void setEnabled(boolean bl) {
            boolean bl2 = this.isEnabled();
            super.setEnabled(bl);
            Component[] componentArray = this.getComponents();
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                componentArray[i].setEnabled(bl);
            }
        }

        public String getText() {
            return this.mField.getText();
        }

        public void setText(String string) {
            this.mField.setText(string);
        }
    }
}

