/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.runtime.JiBXException;

public abstract class StringConversion {
    protected static final String UNMARSHAL_OPT_ATTRIBUTE = "org.jibx.runtime.impl.UnmarshallingContext.attributeText";
    protected static final String UNMARSHAL_OPT_ELEMENT = "org.jibx.runtime.impl.UnmarshallingContext.parseElementText";
    protected static final String UNMARSHAL_OPT_SIGNATURE = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;";
    protected static final String UNMARSHAL_REQ_ATTRIBUTE = "org.jibx.runtime.impl.UnmarshallingContext.attributeText";
    protected static final String UNMARSHAL_REQ_ELEMENT = "org.jibx.runtime.impl.UnmarshallingContext.parseElementText";
    protected static final String UNMARSHAL_REQ_SIGNATURE = "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;";
    protected static final String MARSHAL_ATTRIBUTE = "org.jibx.runtime.impl.MarshallingContext.attribute";
    protected static final String MARSHAL_ELEMENT = "org.jibx.runtime.impl.MarshallingContext.element";
    protected static final String MARSHAL_SIGNATURE = "(ILjava/lang/String;Ljava/lang/String;)Lorg/jibx/runtime/impl/MarshallingContext;";
    protected static final String COMPARE_OBJECTS_METHOD = "org.jibx.runtime.Utility.isEqual";
    protected static final String COMPARE_OBJECTS_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Object;)Z";
    public static final int MARSHAL_NAME_WORDS = 2;
    protected String m_formatName;
    protected Object m_default;
    protected ClassItem m_serializer;
    protected ClassItem m_deserializer;
    protected String m_typeName;
    protected String m_typeSignature;

    private StringConversion(String type) {
        this.m_typeName = type;
        this.m_typeSignature = Utility.getSignature((String)type);
    }

    protected StringConversion(String type, StringConversion inherit) {
        this(type);
        this.m_default = inherit.m_default;
        this.m_serializer = inherit.m_serializer;
        this.m_deserializer = inherit.m_deserializer;
    }

    StringConversion(Object dflt, String ser, String deser, String type) {
        this(type);
        this.m_default = dflt;
        try {
            if (ser != null) {
                this.setSerializer(ser);
            }
            if (deser != null) {
                this.setDeserializer(deser);
            }
        }
        catch (JiBXException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public abstract void genFromText(MethodBuilder var1) throws JiBXException;

    public abstract void genParseOptional(boolean var1, MethodBuilder var2) throws JiBXException;

    public abstract void genParseRequired(boolean var1, MethodBuilder var2) throws JiBXException;

    public void genWriteText(boolean attr, MethodBuilder mb) throws JiBXException {
        String name = attr ? MARSHAL_ATTRIBUTE : MARSHAL_ELEMENT;
        mb.appendCallVirtual(name, MARSHAL_SIGNATURE);
    }

    public void genPopValues(int count, MethodBuilder mb) {
        while (count >= 2) {
            mb.append((Instruction)InstructionConstants.POP2);
            count -= 2;
        }
        if (count > 0) {
            mb.append((Instruction)InstructionConstants.POP);
        }
    }

    protected abstract BranchHandle genToOptionalText(String var1, MethodBuilder var2, int var3) throws JiBXException;

    public void genToText(String type, MethodBuilder mb) throws JiBXException {
        if (this.m_serializer != null) {
            if (!this.isPrimitive()) {
                mb.appendCreateCast(type, this.m_serializer.getArgumentType(0));
            }
            mb.addMethodExceptions(this.m_serializer);
            mb.appendCall(this.m_serializer);
        } else {
            mb.appendCreateCast(type, "java.lang.String");
        }
    }

    public void genWriteOptional(boolean attr, String type, MethodBuilder mb) throws JiBXException {
        BranchHandle toend = this.genToOptionalText(type, mb, 2);
        this.genWriteText(attr, mb);
        if (toend != null) {
            mb.targetNext(toend);
        }
    }

    public void genWriteRequired(boolean attr, String type, MethodBuilder mb) throws JiBXException {
        this.genToText(type, mb);
        this.genWriteText(attr, mb);
    }

    public abstract boolean isPrimitive();

    protected void setSerializer(String ser) throws JiBXException {
        String[] tsigs = ClassItem.getSignatureVariants(this.m_typeName);
        String[] msigs = new String[tsigs.length];
        int i = 0;
        while (i < tsigs.length) {
            msigs[i] = "(" + tsigs[i] + ")Ljava/lang/String;";
            ++i;
        }
        ClassItem method = ClassItem.findStaticMethod(ser, msigs);
        if (method == null) {
            throw new JiBXException("Serializer " + ser + " not found");
        }
        this.m_serializer = method;
    }

    protected void setDeserializer(String deser) throws JiBXException {
        String[] msigs = new String[]{"(Ljava/lang/String;)"};
        ClassItem method = ClassItem.findStaticMethod(deser, msigs);
        if (method == null) {
            throw new JiBXException("Deserializer " + deser + " not found");
        }
        if (!ClassItem.isAssignable(method.getTypeName(), this.m_typeName)) {
            throw new JiBXException("Deserializer " + deser + " returns wrong type");
        }
        this.m_deserializer = method;
    }

    protected abstract Object convertDefault(String var1) throws JiBXException;

    public abstract StringConversion derive(String var1, String var2, String var3, String var4) throws JiBXException;
}

