/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFNULL;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.runtime.JiBXException;

public class PropertyDefinition {
    private final boolean m_isThis;
    private final boolean m_isImplicit;
    private final boolean m_isOptional;
    private final IContextObj m_objContext;
    private final String m_typeName;
    private final String m_getValueType;
    private final String m_setValueType;
    private final ClassItem m_fieldItem;
    private final ClassItem m_testMethod;
    private final ClassItem m_getMethod;
    private final ClassItem m_setMethod;

    public PropertyDefinition(IContainer parent, IContextObj obj, String type, boolean opt, String fname, String test, String get, String set) throws JiBXException {
        this.m_objContext = obj;
        this.m_isImplicit = false;
        this.m_isThis = false;
        this.m_isOptional = opt;
        ClassFile cf = this.m_objContext.getBoundClass().getClassFile();
        String dtype = null;
        String gtype = null;
        String stype = null;
        if (fname == null) {
            this.m_fieldItem = null;
        } else {
            this.m_fieldItem = cf.getField(fname);
            gtype = stype = this.m_fieldItem.getTypeName();
            dtype = stype;
        }
        if (test == null) {
            this.m_testMethod = null;
        } else if (opt) {
            this.m_testMethod = cf.getMethod(test, "()");
        } else {
            throw new JiBXException("Test method only allowed for optional properties");
        }
        if (get == null) {
            this.m_getMethod = null;
        } else {
            this.m_getMethod = cf.getMethod(get, "()");
            gtype = this.m_getMethod.getTypeName();
            if (dtype == null) {
                dtype = gtype;
            }
        }
        if (set == null) {
            this.m_setMethod = null;
        } else {
            this.m_setMethod = cf.getMethod(set, "(");
            String sig = this.m_setMethod.getSignature();
            String[] args = Utility.methodSignatureArgumentTypes((String)sig, (boolean)false);
            String ret = Utility.methodSignatureReturnType((String)sig, (boolean)false);
            if (args.length > 1 || !ret.equals("void")) {
                throw new JiBXException("Method \"" + this.m_setMethod.getName() + "\" not a valid set-method");
            }
            stype = args[0];
            if (dtype == null) {
                dtype = stype;
            }
        }
        this.m_getValueType = gtype;
        this.m_setValueType = stype;
        BindingDefinition root = parent.getBindingRoot();
        if (this.m_fieldItem == null) {
            if (root.isInput() && this.m_setMethod == null) {
                throw new JiBXException("Missing way to set value for input binding");
            }
            if (root.isOutput() && this.m_getMethod == null) {
                throw new JiBXException("Missing way to get value for output binding");
            }
        }
        if (type == null) {
            this.m_typeName = dtype;
        } else {
            this.m_typeName = type;
            boolean valid = true;
            if (root.isInput()) {
                valid = ClassItem.isAssignable(this.m_setValueType, type);
            }
            if (valid && root.isOutput()) {
                valid = ClassItem.isAssignable(type, this.m_getValueType);
            }
            if (!valid) {
                throw new JiBXException("Inconsistent types for property definition");
            }
        }
    }

    public PropertyDefinition(IContextObj obj) {
        this.m_objContext = obj;
        this.m_isThis = true;
        this.m_isOptional = false;
        this.m_isImplicit = false;
        ClassFile cf = this.m_objContext.getBoundClass().getClassFile();
        this.m_setMethod = null;
        this.m_getMethod = null;
        this.m_testMethod = null;
        this.m_fieldItem = null;
        this.m_getValueType = this.m_setValueType = cf.getName();
        this.m_typeName = this.m_setValueType;
    }

    public PropertyDefinition(String type, IContextObj obj) {
        this.m_objContext = obj;
        this.m_isImplicit = true;
        this.m_isOptional = false;
        this.m_isThis = false;
        this.m_setMethod = null;
        this.m_getMethod = null;
        this.m_testMethod = null;
        this.m_fieldItem = null;
        this.m_getValueType = this.m_setValueType = type;
        this.m_typeName = this.m_setValueType;
    }

    public boolean isThis() {
        return this.m_isThis;
    }

    public boolean isImplicit() {
        return this.m_isImplicit;
    }

    public boolean isOptional() {
        return this.m_isOptional;
    }

    public String getName() {
        if (this.m_isThis) {
            return "this";
        }
        if (this.m_fieldItem != null) {
            return this.m_fieldItem.getName();
        }
        if (this.m_getMethod != null) {
            String name = this.m_getMethod.getName();
            if (name.startsWith("get") && name.length() > 3) {
                name = name.substring(3);
            }
            return name;
        }
        String name = this.m_setMethod.getName();
        if (name.startsWith("set") && name.length() > 3) {
            name = name.substring(3);
        }
        return name;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public String getGetValueType() {
        return this.m_getValueType;
    }

    public String getSetValueType() {
        return this.m_setValueType;
    }

    public boolean hasTest() {
        return this.isOptional() && (this.m_testMethod != null || !ClassItem.isPrimitive(this.m_typeName));
    }

    public BranchHandle genTest(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_isThis) {
            throw new IllegalStateException("Internal error: No test for \"this\"");
        }
        if (this.m_isImplicit) {
            throw new IllegalStateException("Internal error: No test for implicit value from collection");
        }
        if (this.m_testMethod != null) {
            mb.addMethodExceptions(this.m_testMethod);
            mb.appendCall(this.m_testMethod);
            return mb.append((BranchInstruction)new IFEQ(null));
        }
        if (!ClassItem.isPrimitive(this.m_typeName)) {
            if (this.m_getMethod == null) {
                mb.appendGetField(this.m_fieldItem);
            } else {
                mb.addMethodExceptions(this.m_getMethod);
                mb.appendCall(this.m_getMethod);
            }
            return mb.append((BranchInstruction)new IFNULL(null));
        }
        return null;
    }

    public void genLoad(MethodBuilder mb) throws JiBXException {
        if (!this.m_isThis && !this.m_isImplicit) {
            ClassFile from = mb.getClassFile();
            ClassItem access = this.m_getMethod;
            if (access == null) {
                access = this.m_fieldItem;
            }
            if (!from.isAccessible(access)) {
                access = this.m_objContext.getBoundClass().getLoadMethod(access, mb.getClassFile());
            }
            if (access.isMethod()) {
                mb.addMethodExceptions(access);
                mb.appendCall(access);
            } else {
                mb.appendGetField(access);
            }
        }
    }

    public void genStore(MethodBuilder mb) throws JiBXException {
        if (!this.m_isThis && !this.m_isImplicit) {
            ClassFile from = mb.getClassFile();
            ClassItem access = this.m_setMethod;
            if (access == null) {
                access = this.m_fieldItem;
            }
            if (!from.isAccessible(access)) {
                access = this.m_objContext.getBoundClass().getStoreMethod(access, mb.getClassFile());
            }
            if (access.isMethod()) {
                mb.addMethodExceptions(access);
                mb.appendCall(access);
            } else {
                mb.appendPutField(access);
            }
        }
    }

    public String toString() {
        StringBuffer text = new StringBuffer("property ");
        if (this.m_isThis) {
            text.append("\"this\" ");
        } else if (this.m_isImplicit) {
            text.append("from collection ");
        } else if (this.m_fieldItem != null) {
            text.append(this.m_fieldItem.getName() + " ");
        } else {
            if (this.m_getMethod != null) {
                text.append("from " + this.m_getMethod.getName() + " ");
            }
            if (this.m_setMethod != null) {
                text.append("to " + this.m_getMethod.getName() + " ");
            }
        }
        text.append("(" + this.m_typeName + ")");
        return text.toString();
    }
}

