/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.NestedBase;
import org.jibx.runtime.JiBXException;

public class NestedStructure
extends NestedBase {
    private IComponent m_idChild;

    public NestedStructure(IContainer parent, IContextObj objc, boolean ord, boolean ctx) {
        super(parent, objc, ord, ctx);
    }

    public boolean hasAttribute() {
        return this.m_attributes != null && this.m_attributes.size() > 0;
    }

    public void genAttrPresentTest(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_attributes != null && this.m_attributes.size() > 0) {
            int count = this.m_attributes.size();
            if (count == 1) {
                ((IComponent)this.m_attributes.get(0)).genAttrPresentTest(mb);
            } else {
                BranchHandle[] tofound = new BranchHandle[count];
                int i = 0;
                while (i < count) {
                    IComponent comp = (IComponent)this.m_attributes.get(i);
                    comp.genAttrPresentTest(mb);
                    tofound[i] = mb.append((BranchInstruction)new IFNE(null));
                    ++i;
                }
                mb.append(InstructionConstants.ICONST_0);
                BranchHandle toend = mb.append((BranchInstruction)new GOTO(null));
                int i2 = 0;
                while (i2 < count) {
                    mb.targetNext(tofound[i2]);
                    ++i2;
                }
                mb.append(InstructionConstants.ICONST_1);
                mb.targetNext(toend);
            }
        } else {
            throw new IllegalStateException("Internal error - no attributes present");
        }
    }

    public void genAttributeUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_attributes != null && this.m_attributes.size() > 0) {
            int i = 0;
            while (i < this.m_attributes.size()) {
                IComponent attr = (IComponent)this.m_attributes.get(i);
                attr.genAttributeUnmarshal(mb);
                ++i;
            }
        } else {
            throw new IllegalStateException("Internal error - no attributes present");
        }
    }

    public void genAttributeMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_attributes != null && this.m_attributes.size() > 0) {
            int i = 0;
            while (i < this.m_attributes.size()) {
                IComponent attr = (IComponent)this.m_attributes.get(i);
                attr.genAttributeMarshal(mb);
                ++i;
            }
        } else {
            throw new IllegalStateException("Internal error - no attributes present");
        }
    }

    public boolean hasContent() {
        return this.m_contents.size() > 0;
    }

    public void genContentUnmarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_contents.size() > 0) {
            if (this.m_isOrdered) {
                int i = 0;
                while (i < this.m_contents.size()) {
                    IComponent child = (IComponent)this.m_contents.get(i);
                    child.genContentUnmarshal(mb);
                    ++i;
                }
            } else {
                BranchHandle link = null;
                InstructionHandle first = mb.append(InstructionConstants.NOP);
                int i = 0;
                while (i < this.m_contents.size()) {
                    if (link != null) {
                        mb.targetNext(link);
                    }
                    IComponent child = (IComponent)this.m_contents.get(i);
                    child.genContentPresentTest(mb);
                    link = mb.append((BranchInstruction)new IFEQ(null));
                    child.genContentUnmarshal(mb);
                    mb.append((BranchInstruction)new GOTO(first));
                    ++i;
                }
                mb.targetNext(link);
            }
        } else {
            throw new IllegalStateException("Internal error - no content present");
        }
    }

    public void genContentMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_contents.size() > 0) {
            int i = 0;
            while (i < this.m_contents.size()) {
                IComponent content = (IComponent)this.m_contents.get(i);
                content.genContentMarshal(mb);
                ++i;
            }
        } else {
            throw new IllegalStateException("Internal error - no content present");
        }
    }

    public boolean hasId() {
        return this.m_idChild != null;
    }

    public void genLoadId(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_idChild == null) {
            throw new IllegalStateException("No ID child defined");
        }
        this.m_idChild.genLoadId(mb);
    }

    public boolean checkContentSequence(boolean text) throws JiBXException {
        int i = 0;
        while (i < this.m_contents.size()) {
            IComponent content = (IComponent)this.m_contents.get(i);
            text = content.checkContentSequence(text);
            ++i;
        }
        return text;
    }

    public void setLinkages() throws JiBXException {
        int i = 0;
        while (i < this.m_contents.size()) {
            IComponent comp = (IComponent)this.m_contents.get(i);
            comp.setLinkages();
            if (comp.hasAttribute()) {
                if (this.m_attributes == null) {
                    this.m_attributes = new ArrayList();
                }
                this.m_attributes.add(comp);
            }
            if (!comp.hasContent()) {
                this.m_contents.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("structure " + (this.m_isOrdered ? "ordered" : "unordered"));
        if (this.m_idChild != null) {
            System.out.print(" (ID)");
        }
        System.out.println();
        int i = 0;
        while (i < this.m_contents.size()) {
            IComponent comp = (IComponent)this.m_contents.get(i);
            comp.print(depth + 1);
            ++i;
        }
    }
}

