/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.PassThroughComponent;
import org.jibx.binding.def.PropertyDefinition;
import org.jibx.runtime.JiBXException;

public class MappingReference
extends PassThroughComponent {
    private final IContainer m_container;
    private final PropertyDefinition m_property;
    private final String m_type;

    public MappingReference(IContainer contain, PropertyDefinition prop, String type) {
        this.m_container = contain;
        this.m_property = prop;
        this.m_type = type;
    }

    public MappingReference(IContainer parent, String type) {
        this(parent, null, type);
    }

    public String getType() {
        return this.m_type;
    }

    public void setLinkages() throws JiBXException {
        DefinitionContext defc = this.m_container.getDefinitionContext();
        IMapping mdef = defc.getClassMapping(this.m_type);
        IComponent wrap = mdef.buildRef(this.m_container, this.m_type, this.m_property);
        this.setWrappedComponent(wrap);
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("mapping reference to " + this.m_type);
        if (this.m_property != null) {
            System.out.print(" using " + this.m_property.toString());
        }
        System.out.println();
    }
}

