/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.runtime.JiBXException;

public class ContextMethodBuilder
extends ExceptionMethodBuilder {
    protected int m_objectSlot;
    protected String m_objectType;
    protected int m_contextSlot;
    protected String m_contextType;

    public ContextMethodBuilder(String name, Type ret, Type[] args, ClassFile cf, int access, int obj, String type, int ctx, String ctype) throws JiBXException {
        super(name, ret, args, cf, access);
        this.m_objectSlot = obj;
        this.m_objectType = type;
        this.m_contextSlot = ctx;
        this.m_contextType = ctype;
        this.addException("org.jibx.runtime.JiBXException");
    }

    public ContextMethodBuilder(String name, String sig, ClassFile cf, int access, int obj, String type, int ctx, String ctype) throws JiBXException {
        this(name, Type.getReturnType((String)sig), Type.getArgumentTypes((String)sig), cf, access, obj, type, ctx, ctype);
    }

    public ContextMethodBuilder(String name, String sig, ClassFile cf, int obj, String type, int ctx, String ctype) throws JiBXException {
        this(name, sig, cf, 17, obj, type, ctx, ctype);
    }

    public void setObjectSlot(int slot) {
        this.m_objectSlot = slot;
    }

    public InstructionHandle loadObject() {
        return this.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)this.m_objectSlot));
    }

    public void storeObject() {
        if (this.m_objectSlot < 0) {
            LocalVariableGen var = this.createLocal("obj", (Type)new ObjectType(this.m_objectType));
            this.m_objectSlot = var.getIndex();
        } else {
            this.append((Instruction)InstructionFactory.createStore((Type)Type.OBJECT, (int)this.m_objectSlot));
        }
    }

    public InstructionHandle loadObject(String type) {
        InstructionHandle handle = this.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)this.m_objectSlot));
        if (!this.m_objectType.equals(type)) {
            this.appendCreateCast(this.m_objectType, type);
        }
        return handle;
    }

    public InstructionHandle loadContext() {
        return this.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)this.m_contextSlot));
    }

    public InstructionHandle loadContext(String type) {
        InstructionHandle handle = this.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)this.m_contextSlot));
        if (!this.m_contextType.equals(type)) {
            this.appendCreateCast(this.m_contextType, type);
        }
        return handle;
    }
}

