/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.jibx.binding.Compile;
import org.jibx.binding.ant.BindingFileSet;
import org.jibx.binding.ant.ClassPathSet;
import org.jibx.runtime.JiBXException;

public class CompileTask
extends Task {
    private boolean load;
    private boolean verify;
    private boolean verbose;
    private List fileSet;
    private List bindingFileSet;
    private String bindingFile;

    public void init() throws BuildException {
        super.init();
        this.fileSet = new ArrayList();
        this.bindingFileSet = new ArrayList();
    }

    private String[] getPaths() {
        int size = this.fileSet.size();
        String[] pathArr = new String[size];
        int x = 0;
        while (x < size) {
            String path;
            FileSet fSet = (FileSet)this.fileSet.get(x);
            File directory = fSet.getDir(this.project);
            pathArr[x] = path = directory.getAbsolutePath();
            ++x;
        }
        if (this.verbose) {
            this.log("using the following paths:");
            int x2 = 0;
            while (x2 < size) {
                this.log("  " + pathArr[x2]);
                ++x2;
            }
        }
        return pathArr;
    }

    private String[] getBindings() {
        String[] bindings;
        if (this.bindingFileSet.size() == 0) {
            bindings = new String[]{this.bindingFile};
        } else {
            bindings = new String[this.bindingFileSet.size()];
            int i = 0;
            while (i < bindings.length) {
                BindingFileSet bPath = (BindingFileSet)((Object)this.bindingFileSet.get(i));
                DirectoryScanner dirScn = bPath.getDirectoryScanner(this.project);
                String[] bndingFiles = dirScn.getIncludedFiles();
                int x = 0;
                while (x < bndingFiles.length) {
                    String fullPath = dirScn.getBasedir() + System.getProperty("file.separator") + bndingFiles[x];
                    if (this.verbose) {
                        this.log("using the following binding: " + fullPath);
                    }
                    bindings[i] = fullPath;
                    ++x;
                }
                ++i;
            }
        }
        return bindings;
    }

    private void validateRequiredFields() throws BuildException {
        if (this.bindingFileSet.isEmpty() && this.bindingFile == null || this.fileSet.isEmpty()) {
            throw new BuildException("At least one binding and class fileset must be defined!");
        }
    }

    public void execute() throws BuildException {
        try {
            this.validateRequiredFields();
            String[] pathArr = this.getPaths();
            String[] bindings = this.getBindings();
            Compile compiler = new Compile();
            compiler.setLoad(false);
            compiler.setVerify(this.verify);
            compiler.setVerbose(this.verbose);
            compiler.compile(pathArr, bindings);
        }
        catch (JiBXException jEx) {
            jEx.printStackTrace();
            throw new BuildException("JiBXException in JiBX binding compilation", (Throwable)jEx);
        }
    }

    public void addClassPathSet(ClassPathSet fSet) {
        this.fileSet.add(fSet);
    }

    public void setBinding(String file) {
        this.bindingFile = file;
    }

    public void addBindingFileSet(BindingFileSet bfSet) {
        this.bindingFileSet.add(bfSet);
    }

    public void setVerify(boolean bool) {
        this.verify = bool;
    }

    public void setLoad(boolean bool) {
        this.load = bool;
    }

    public void setVerbose(boolean bool) {
        this.verbose = bool;
    }
}

