/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.bench.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.BenchReport;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.Colleague;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.SortStrategy;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.TableSortHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.model.ResultTableModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.bench.view.ClickableHeaderObserver;

class BenchmarkResultTable
extends JFrame
implements Colleague {
    private TableSortHandler mSortHandler = new NullSorter();
    static /* synthetic */ Class class$java$lang$Object;

    public BenchmarkResultTable(TableModel tableModel, TableSortHandler tableSortHandler) {
        if (null != tableSortHandler) {
            this.mSortHandler = tableSortHandler;
        }
        JFrame jFrame = new JFrame("result table");
        JTable jTable = new JTable();
        jTable.setModel(tableModel);
        jTable.setAutoResizeMode(3);
        jTable.setShowVerticalLines(false);
        jTable.setColumnSelectionAllowed(true);
        BenchResultCellRenderer benchResultCellRenderer = new BenchResultCellRenderer();
        ClickableHeaderRenderer clickableHeaderRenderer = new ClickableHeaderRenderer(benchResultCellRenderer);
        jTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = BenchmarkResultTable.class$("java.lang.Object")) : class$java$lang$Object, benchResultCellRenderer);
        jTable.getTableHeader().setDefaultRenderer(clickableHeaderRenderer);
        jTable.getTableHeader().addMouseListener(clickableHeaderRenderer);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.getContentPane().add((Component)jScrollPane, "Center");
        jFrame.pack();
    }

    public void setUp() {
        this.pack();
        this.setVisible(false);
    }

    public void cleanUp() {
        WindowListener[] windowListenerArray = this.getWindowListeners();
        for (int i = 0; i < windowListenerArray.length; ++i) {
            this.removeWindowListener(windowListenerArray[i]);
        }
        this.addWindowListener(new StandaloneWindowHandler());
        this.mSortHandler.sort();
        this.pack();
        this.setVisible(true);
    }

    public void update() {
        if (!this.isVisible()) {
            this.mSortHandler.sort();
        }
        this.setVisible(!this.isVisible());
    }

    public static void main(String[] stringArray) {
        BenchReport[] benchReportArray = new BenchReport[]{BenchReport.createReport(new ProblemInfo("hashi_02_01", 11, 10, 10, new String[0]), 99L, 101L, 100L, 2), BenchReport.illegalBenchReport(new ProblemInfo("hashi_03_01", 12, 15, 15, new String[0]), 3L)};
        ResultTableModel resultTableModel = new ResultTableModel(new String[]{"problem name", "min time", "max time", "average time", "count", "solved"});
        for (int i = 0; i < benchReportArray.length; ++i) {
            resultTableModel.addRow(benchReportArray[i].flatten());
        }
        new BenchmarkResultTable(resultTableModel, null).setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class NullSorter
    implements TableSortHandler {
        private NullSorter() {
        }

        public void sort() {
        }

        public void sort(int n) {
        }

        public void setSortStrategy(SortStrategy sortStrategy) {
        }

        public void setModel(TableModel tableModel) {
        }

        public int resolveRowIndex(int n) {
            return n;
        }
    }

    private class ClickableHeaderRenderer
    extends JButton
    implements TableCellRenderer,
    MouseListener {
        private final Insets EMPTY_INSETS = new Insets(1, 0, 1, 0);
        private TableColumn mColumn;
        private ClickableHeaderObserver mClickObserver;

        public ClickableHeaderRenderer(ClickableHeaderObserver clickableHeaderObserver) {
            this.setMargin(this.EMPTY_INSETS);
            this.mClickObserver = clickableHeaderObserver;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
                TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n2);
                boolean bl3 = tableColumn == this.mColumn;
                ButtonModel buttonModel = this.getModel();
                buttonModel.setArmed(bl3);
                buttonModel.setPressed(bl3);
            }
            this.setText(object == null ? "" : object.toString());
            return this;
        }

        public Insets getInsets() {
            return this.EMPTY_INSETS;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            int n = jTableHeader.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
            this.mColumn = jTableHeader.getColumnModel().getColumn(n);
            this.mClickObserver.updateLastClickedColumn(this.mColumn);
            Rectangle rectangle = jTableHeader.getHeaderRect(n);
            jTableHeader.repaint(rectangle);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            int n = jTableHeader.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
            Rectangle rectangle = jTableHeader.getHeaderRect(n);
            jTableHeader.repaint(rectangle);
            this.mColumn = null;
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
            n = jTableHeader.getColumnModel().getColumn(n).getModelIndex();
            BenchmarkResultTable.this.mSortHandler.sort(n);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }
    }

    private class BenchResultCellRenderer
    implements TableCellRenderer,
    ClickableHeaderObserver {
        private final Color SORTED_CELL_BACK_COLOR = Color.lightGray;
        private TableCellRenderer mRenderer = new DefaultTableCellRenderer();
        private TableColumn mLastClickedColumn;

        public void updateLastClickedColumn(TableColumn tableColumn) {
            this.mLastClickedColumn = tableColumn;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            Component component = this.mRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n2);
                if (tableColumn == this.mLastClickedColumn) {
                    component.setBackground(this.SORTED_CELL_BACK_COLOR);
                } else {
                    component.setBackground(Color.white);
                }
            }
            return component;
        }
    }

    private class StandaloneWindowHandler
    implements WindowListener {
        private StandaloneWindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            BenchmarkResultTable.this.mSortHandler = null;
            ((Window)windowEvent.getSource()).dispose();
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }
    }
}

