/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.creator.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.gr.java_conf.ktz.puzzle.framework.util.Command;
import jp.gr.java_conf.ktz.puzzle.framework.view.CommandContainer;
import jp.gr.java_conf.ktz.puzzle.framework.view.awt.AWTDispatchCommandQueue;
import jp.gr.java_conf.ktz.puzzle.framework.view.awt.BoardView;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.PositiveIntFormatter;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.ValidDocumentat;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeResultCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.PropertyBundle;

public class SizeChangeDialog
extends JFrame
implements CommandContainer {
    private BoardView mOwnerFrame;
    private JTextField mWidthField;
    private JTextField mHeightField;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeResultCommand;

    public static void showDialog(final BoardView boardView) {
        if (EventQueue.isDispatchThread()) {
            SizeChangeDialog sizeChangeDialog = new SizeChangeDialog();
            sizeChangeDialog.initialize(boardView);
            sizeChangeDialog.show();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    SizeChangeDialog.showDialog(boardView);
                }
            };
            EventQueue.invokeLater(runnable);
        }
    }

    public void initialize(BoardView boardView) {
        this.mOwnerFrame = boardView;
        AWTDispatchCommandQueue.postCommand((Command)new ResizeCommand((CommandContainer)this.mOwnerFrame, this));
    }

    protected void frameInit() {
        super.frameInit();
        String string = PropertyBundle.getInstance().getString("resize_dialog_title");
        this.setTitle(string);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel(new GridLayout(2, 2));
        container.add((Component)jPanel, "Center");
        string = PropertyBundle.getInstance().getString("width :");
        jPanel.add(new JLabel(string, 4));
        this.mWidthField = new JTextField();
        this.mWidthField.setDocument(new ValidDocumentat(new PositiveIntFormatter(2)));
        class FocusHandler
        implements FocusListener {
            FocusHandler() {
            }

            public void focusGained(FocusEvent focusEvent) {
                JTextField jTextField = (JTextField)focusEvent.getSource();
                jTextField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        }
        this.mWidthField.addFocusListener(new FocusHandler());
        class ApproveHandler
        implements KeyListener {
            ApproveHandler() {
            }

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                switch (n) {
                    case 27: {
                        SizeChangeDialog.this.cancelAction();
                        break;
                    }
                    case 10: {
                        SizeChangeDialog.this.approveAction();
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        }
        this.mWidthField.addKeyListener(new ApproveHandler());
        jPanel.add(this.mWidthField);
        string = PropertyBundle.getInstance().getString("height :");
        jPanel.add(new JLabel(string, 4));
        this.mHeightField = new JTextField();
        this.mHeightField.setDocument(new ValidDocumentat(new PositiveIntFormatter(2)));
        this.mHeightField.addFocusListener(new FocusHandler());
        this.mHeightField.addKeyListener(new ApproveHandler());
        jPanel.add(this.mHeightField);
        jPanel = new JPanel();
        container.add((Component)jPanel, "South");
        string = PropertyBundle.getInstance().getString("OK");
        JButton jButton = new JButton(string);
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SizeChangeDialog.this.approveAction();
            }
        });
        jButton.addKeyListener(new ApproveHandler());
        string = PropertyBundle.getInstance().getString("Cancel");
        jButton = new JButton(string);
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SizeChangeDialog.this.cancelAction();
            }
        });
        class CancelHandler
        implements KeyListener {
            CancelHandler() {
            }

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                switch (n) {
                    case 27: {
                        SizeChangeDialog.this.cancelAction();
                        break;
                    }
                    case 10: {
                        SizeChangeDialog.this.cancelAction();
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        }
        jButton.addKeyListener(new CancelHandler());
        this.pack();
    }

    private void approveAction() {
        try {
            int n = Integer.parseInt(this.mWidthField.getText());
            int n2 = Integer.parseInt(this.mHeightField.getText());
            ResizeResultCommand resizeResultCommand = new ResizeResultCommand((CommandContainer)this.mOwnerFrame, n, n2);
            AWTDispatchCommandQueue.postCommand((Command)resizeResultCommand);
            this.dispose();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void cancelAction() {
        this.dispose();
    }

    public void processCommand(Command command) {
        Class<?> clazz = command.getClass();
        if (clazz == (class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeResultCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeResultCommand = SizeChangeDialog.class$("jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeResultCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeResultCommand)) {
            int n = ((ResizeResultCommand)command).getWidth();
            int n2 = ((ResizeResultCommand)command).getHeight();
            this.mWidthField.setText(String.valueOf(n));
            this.mHeightField.setText(String.valueOf(n2));
        }
    }

    private SizeChangeDialog() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

