/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.creator.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.framework.DecoratedStateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BranchState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.HashikakeNumberState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.SpaceState;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class HashiCreStateManagerImpl
extends DecoratedStateManagerImpl {
    public static final String SPACE_ID = "s";
    private Map mStateMap = new HashMap();
    private State mTransit;

    public HashiCreStateManagerImpl() {
        this(null);
    }

    public HashiCreStateManagerImpl(StateManagerImpl stateManagerImpl) {
        super(stateManagerImpl);
        this.initTable();
    }

    private void initTable() {
        State[] stateArray = new State[]{SpaceState.getInstance(), new NumberState(1), new NumberState(2), new NumberState(3), new NumberState(4), new NumberState(5), new NumberState(6), new NumberState(7), new NumberState(8)};
        BranchState.TransitHint[] transitHintArray = new BranchState.TransitHint[stateArray.length];
        this.mStateMap.put(SPACE_ID, stateArray[0]);
        transitHintArray[0] = new BranchState.TransitHint(stateArray[0], new StateEventCode[]{UtilityFuncs.createSpaceCode()});
        for (int i = 1; i < stateArray.length; ++i) {
            String string = String.valueOf(i);
            this.mStateMap.put(string, stateArray[i]);
            transitHintArray[i] = new BranchState.TransitHint(stateArray[i], new StateEventCode[]{UtilityFuncs.createNumberCodeOf(i)});
        }
        this.mTransit = new BranchState(transitHintArray);
    }

    protected State createStateOfSelf(String string) {
        if (!this.mStateMap.containsKey(string)) {
            throw new IllegalArgumentException("The inStateID : " + string + " is illegal.");
        }
        return (State)this.mStateMap.get(string);
    }

    protected State createDefaultStateSelf() {
        return this.createStateOfSelf(SPACE_ID);
    }

    protected String findIdentityOfSelf(State state) {
        Iterator iterator = this.mStateMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getValue().equals(state)) continue;
            return (String)entry.getKey();
        }
        return SPACE_ID;
    }

    protected State dewrapState(State state) {
        if (state instanceof HashikakeNumberState) {
            return ((HashikakeNumberState)state).getNumberState();
        }
        return state;
    }

    protected State getNextStateSelf(State state) {
        throw new UnsupportedOperationException("getNextStateSelf(State) method is not supported.");
    }

    protected State getNextStateSelf(State state, StateEventCode stateEventCode) {
        return this.getTransitedState(state, stateEventCode);
    }

    protected State getPrevStateSelf(State state) {
        throw new UnsupportedOperationException("getPrevStateSelf(State) method is not supported.");
    }

    protected State getPrevStateSelf(State state, StateEventCode stateEventCode) {
        return this.getTransitedState(state, stateEventCode);
    }

    private State getTransitedState(State state, StateEventCode stateEventCode) {
        State state2 = this.mTransit.onEnter(stateEventCode);
        if (!this.isSpaceStateSelf(state2)) {
            state2 = new HashikakeNumberState((NumberState)state2, this.createDefaultState());
        }
        return state2;
    }

    protected boolean isNumberStateSelf(State state) {
        return state instanceof HashikakeNumberState;
    }

    protected boolean isSpaceStateSelf(State state) {
        return state instanceof SpaceState;
    }

    protected boolean isTransitSelf(State state) {
        throw new UnsupportedOperationException("isTransitSelf(State) method is not supported.");
    }

    protected boolean isTransitSelf(State state, StateEventCode stateEventCode) {
        State state2 = null;
        try {
            state2 = this.mTransit.onEnter(stateEventCode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return state2 != state;
    }

    protected boolean acceptableEventCode(StateEventCode stateEventCode) {
        return stateEventCode instanceof HashikakeStateEventCode;
    }
}

