/* EBhE֌W */

#include "bootpack.h"

void graphic_window(struct sheet *sht, int xsize, int ysize, char *title, char m)
{
	graphic_box(sht, COLOR_C6C6C6,       0,       0, xsize-1,       0);
	graphic_box(sht, COLOR_FFFFFF,       1,       1, xsize-2,       1);
	graphic_box(sht, COLOR_C6C6C6,       0,       0,       0, ysize-1);
	graphic_box(sht, COLOR_FFFFFF,       1,       1,       1, ysize-2);
	graphic_box(sht, COLOR_848484, xsize-2,       1, xsize-2, ysize-2);
	graphic_box(sht, COLOR_000000, xsize-1,       0, xsize-1, ysize-1);
	graphic_box(sht, COLOR_C6C6C6,       2,       2, xsize-3, ysize-3);
	graphic_box(sht, COLOR_848484,       1, ysize-2, xsize-2, ysize-2);
	graphic_box(sht, COLOR_000000,       0, ysize-1, xsize-1, ysize-1);
	graphic_wtitle(sht, xsize, title, m);
	return;
}

void graphic_wtitle(struct sheet *sht, int xsize, char *title, char m)
{
	static char closebtn[14][16] = {
		"OOOOOOOOOOOOOOO@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQ@@QQQQ@@QQ$@",
		"OQQQQ@@QQ@@QQQ$@",
		"OQQQQQ@@@@QQQQ$@",
		"OQQQQQQ@@QQQQQ$@",
		"OQQQQQ@@@@QQQQ$@",
		"OQQQQ@@QQ@@QQQ$@",
		"OQQQ@@QQQQ@@QQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"O$$$$$$$$$$$$$$@",
		"@@@@@@@@@@@@@@@@"
	};
	int x, y;
	unsigned char tc, tbc, c;

	if(m) {
		tc = COLOR_FFFFFF;
		tbc = COLOR_000084;
	} else {
		tc = COLOR_C6C6C6;
		tbc = COLOR_848484;
	}
	graphic_box(sht, tbc, 3, 3, xsize-4, 20);
	graphic_fonts(sht, tbc, tc, 24, 4, title);
	for(y = 0;y < 14;y++)
		for(x = 0;x < 16;x++) {
			c = closebtn[y][x];
			if(c == '@')
				c = COLOR_000000;
			else if(c == '$')
				c = COLOR_848484;
			else if(c == 'Q')
				c = COLOR_C6C6C6;
			else
				c = COLOR_FFFFFF;
			sht->buf[(5+y)*xsize+(xsize-21+x)] = c;
		}
	sheet_refresh(sht, 3, 3, xsize, 21);
	return;
}

void graphic_wctitle(struct sheet *sht, char m)
{
	int x, y;
	char c, tcn, tbn, tco, tbo;

	if(m) {
		tcn = COLOR_FFFFFF;
		tbn = COLOR_000084;
		tco = COLOR_C6C6C6;
		tbo = COLOR_848484;
	} else {
		tcn = COLOR_C6C6C6;
		tbn = COLOR_848484;
		tco = COLOR_FFFFFF;
		tbo = COLOR_000084;
	}
	for(y = 3;y <= 20;y++)
		for(x = 3;x <= sht->sx-4;x++) {
			c = sht->buf[y*sht->sx+x];
			if(c == tco && x <= sht->sx-22)
				c = tcn;
			else if(c == tbo)
				c = tbn;
			sht->buf[y*sht->sx+x] = c;
		}
	sheet_refresh(sht, 3, 3, sht->sx, 21);
	return;
}

void graphic_tbox(struct sheet *sht, unsigned char c, int x0, int y0, int sx, int sy)
{
	int x1 = x0+sx, y1 = y0+sy;

	graphic_box(sht, COLOR_848484, x0-2, y0-3, x1+1, y0-3);
	graphic_box(sht, COLOR_848484, x0-3, y0-3, x1-3, y1+1);
	graphic_box(sht, COLOR_FFFFFF, x0-3, y1+2, x1+1, y1+2);
	graphic_box(sht, COLOR_FFFFFF, x1+2, y0-3, x1+2, y1+2);
	graphic_box(sht, COLOR_000000, x0-1, y0-2,   x1, y0-2);
	graphic_box(sht, COLOR_000000, x0-2, y0-2, x0-2,   y1);
	graphic_box(sht, COLOR_C6C6C6, x0-2, y1+1,   x1, y1+1);
	graphic_box(sht, COLOR_C6C6C6, x1+1, y0-2, x1+1, y1+1);
	graphic_box(sht,            c, x0-1, y0-1,   x1,   y1);
	return;
}
