/* ^C}֌W */

#include "bootpack.h"

struct timers *timers;		/* Ǘp */
extern struct timer *ttimer;

void pit_init(void)
{
	outb(PIT_CTRL, 0x34);
	outb(PIT_CNT0, 0x9c);	/* 10msƂɊ荞 */
	outb(PIT_CNT0, 0x2e);

	timers->count = 0;
	timers->next = 0xffffffff;
	return;
}

void timers_init(void)
{
	struct timer *t;
	int i;

	timers = (struct timers *)memory_alloc(mem, sizeof(struct timers));
	for(i = 0; i < TIMER_MAX; i++) {
		timers->timer[i].flag = TIMER_NONE;
	}
	/* ԕ */
	t = timer_alloc();
	t->tout = 0xffffffff;
	t->flag |= TIMER_USING;
	t->next = 0;
	timers->t = t;
	timers->next = 0xffffffff;
	return;
}

void timer_ihandle(int *esp)
{
	struct timer *timer;
	char ts = 0;

	outb(PIC0_OCW2, 0x60);	/* IRQ-00tPIC0ɒʒm */
	timers->count++;
	if(timers->next > timers->count) {	/* ^CAEg݂Ȃ */
		return;
	}
	timer = timers->t;
	for(;;) {
		if(timer->tout > timers->count) {	/* ^CAEg͂Ȃ */
			break;
		}
		timer->flag &= ~TIMER_USING;
		timer->flag |= TIMER_ALLOC;
		if(timer != ttimer) {
			fifo_put(timer->fifo, timer->data);
		} else {
			ts = 1;
		}
		timer = timer->next;
	}
	/* ^CAEĝł炷 */
	timers->t = timer;
	timers->next = timers->t->tout;
	if(ts != 0) {
		task_switch();
	}
	return;
}

struct timer *timer_alloc(void)
{
	int i;

	for(i = 0; i < TIMER_MAX; i++) {
		if(timers->timer[i].flag == TIMER_NONE) {
			timers->timer[i].timers = timers;
			timers->timer[i].flag = TIMER_ALLOC;
			return &timers->timer[i];
		}
	}
	return 0;
}

void timer_free(struct timer *timer)
{
	timer->flag = TIMER_NONE;
	return;
}

void timer_init(struct timer *timer, struct fifo *fifo, int data)
{
	timer->fifo = fifo;
	timer->data = data;
	return;
}

void timer_set(struct timer *timer, unsigned int tout)
{
	struct timer *t, *s;
	int e;

	timer->flag &= ~TIMER_ALLOC;
	timer->flag |= TIMER_USING;
	timer->tout = timers->count+tout;
	e = leflags();
	cli();

	t = timer->timers->t;
	if(timer->tout <= t->tout) {	/* 擪ɓ */
		timers->t = timer;
		timer->next = t;
		timers->next = timer->tout;
		goto fin;
	}
	for(;;) {	/* ꏊ */
		s = t;
		t = t->next;
		if(timer->tout <= t->tout) {	/* Ԃɓ */
			s->next = timer;
			timer->next = t;
			goto fin;
		}
	}

fin:
	seflags(e);
	return;
}

void timer_cancel_auto(struct fifo *fifo)
{
	struct timer *t;
	int e, i;

	e = leflags();
	cli();
	for(i = 0; i < TIMER_MAX; i++) {
		t = &timers->timer[i];
		if((t->flag & TIMER_ACANCEL) != 0 && t->fifo == fifo) {
			timer_cancel(t);
			timer_free(t);
		}
	}
	seflags(e);
	return;
}

int timer_cancel(struct timer *timer)
{
	struct timer *t;
	int e;

	e = leflags();
	cli();
	if((timer->flag & TIMER_USING) != 0) {
		if(timer == timers->t) {	/* 擪̏ꍇ */
			t = timer->next;
			timers->t = t;
			timers->next = t->tout;
		} else {
			t = timers->t;
			for(;;) {
				if(t->next == timer) {
					break;
				}
				t = t->next;
			}
			t->next = timer->next;
		}
		timer->flag &= ~ TIMER_USING;
		timer->flag |= TIMER_ALLOC;
		seflags(e);
		return 1;
	}
	seflags(e);
	return 0;
}
