/* OtBbN֌W */

#include "bootpack.h"

void palette_init(void)
{
	static unsigned char rgb[16 * 3] = {
		0x00, 0x00, 0x00,	/*  0: */
		0xff, 0x00, 0x00,	/*  1:邢 */
		0x00, 0xff, 0x00,	/*  2:邢 */
		0xff, 0xff, 0x00,	/*  3:邢F */
		0x00, 0x00, 0xff,	/*  4:邢 */
		0xff, 0x00, 0xff,	/*  5:邢 */
		0x00, 0xff, 0xff,	/*  6:邢F */
		0xff, 0xff, 0xff,	/*  7: */
		0xc6, 0xc6, 0xc6,	/*  8:邢DF */
		0x84, 0x00, 0x00,	/*  9:邢 */
		0x00, 0x84, 0x00,	/* 10:邢 */
		0x84, 0x84, 0x00,	/* 11:邢F */
		0x00, 0x00, 0x84,	/* 12:邢 */
		0x84, 0x00, 0x84,	/* 13:邢 */
		0x00, 0x84, 0x84,	/* 14:邢F */
		0x84, 0x84, 0x84	/* 15:邢DF */
	};
	unsigned char rgb2[216 * 3];
	int r, g, b;

	/* 16Fݒ */
	palette_set(rgb, 0, 15);

	/* RGB6iK216Fݒ */
	for(b = 0; b < 6; b++) {
		for(g = 0; g < 6; g++) {
			for(r = 0; r < 6; r++) {
				rgb2[(r + g * 6 + b * 36) * 3] = r * 51;
				rgb2[(r + g * 6 + b * 36) * 3 + 1] = g * 51;
				rgb2[(r + g * 6 + b * 36) * 3 + 2] = b * 51;
			}
		}
	}
	palette_set(rgb2, 16, 231);
	return;
}

void palette_set(unsigned char *rgb, int start, int end)
{
	int eflags, i;

	eflags = leflags();	/* 荞݋tO̒lL^ */
	cli();			/* 荞݋֎~ɂ */
	outb(0x03c8, start);
	for(i = start; i <= end; i++) {
		outb(0x03c9, rgb[0] / 4);
		outb(0x03c9, rgb[1] / 4);
		outb(0x03c9, rgb[2] / 4);
		rgb += 3;
	}
	seflags(eflags);	/* 荞݋tO߂ */
	return;
}

void screen_init(struct sheet *sht)
{
	struct file *file;
	struct dll_strpicenv *env;
	struct rgb *pbuf = 0, *q;
	int size, info[8], sx = sht->sx, sy = sht->sy, x, y, i, j;
	char *fbuf, *p;

	file = file_search("back.jpg");
	if(file != 0) {	/* t@C݂B */
		i = 1;	/* 0ɂȂĂƐƊmFłB */
		size = file->size;
		fbuf = file_read(file->cno, &size);
		if(fbuf == 0) {
			memory_free(mem, (unsigned int) fbuf, size);
			return;
		}
		env = (struct dll_strpicenv *) memory_alloc(mem, sizeof(struct dll_strpicenv));
		if(info_JPEG(env, info, size, fbuf) != 0) {	/* jpegł */
			/* infȍpr
			 * info[0] : t@C^Cvi1:bmp, 2:jpegj
			 * info[1] : J[
			 * info[2] : xsize
			 * info[3] : ysize
			 */
			if(info[2] <= sx && info[3] <= sy) {	/* 傫Ȃ */
				pbuf = (struct rgb *) memory_alloc(mem, info[2] * info[3] * sizeof(struct rgb));
				i = decode0_JPEG(env, size, fbuf, 4, (char *) pbuf, 0);
			}
		} else if(info_BMP(env, info, size, fbuf) != 0) {	/* bmpł */
			if(info[2] <= sx && info[3] <= sy) {	/* 傫Ȃ */
				pbuf = (struct rgb *) memory_alloc(mem, info[2] * info[3] * sizeof(struct rgb));
				i = decode0_BMP(env, size, fbuf, 4, (char *) pbuf, 0);
			}
		}
		if(i == 0) {	/* ǂɐ */
			x = (sx - info[2]) / 2;
			y = (sy - info[3]) / 2;
			for(i = 0; i < info[3]; i++) {
				p = sht->buf + (y + i) * sx;
				q = pbuf + i * info[2];
				for(j = 0; j < info[2]; j++) {
					p[x + j] = rgb2pal(q[j].r, q[j].g, q[j].b, j, i);
				}
			}
		}
		if(pbuf != 0) {
			memory_free(mem, (unsigned int) pbuf, info[2] * info[3] * sizeof(struct rgb));
		}
		memory_free(mem, (unsigned int) env, sizeof(struct dll_strpicenv));
		memory_free(mem, (unsigned int) fbuf, size);
	}
	return;
}

void tbar_init(struct sheet *sht)
{
	int sx = sht->sx, sy = sht->sy;

	graphic_box(sht, COLOR_C6C6C6,       0, sy - 28,  sx - 1,  sy - 1);
	graphic_box(sht, COLOR_FFFFFF,       0, sy - 27,  sx - 1, sy - 27);

	graphic_box(sht, COLOR_FFFFFF,       3, sy - 24,      59, sy - 24);
	graphic_box(sht, COLOR_FFFFFF,       2, sy - 24,       2,  sy - 4);
	graphic_box(sht, COLOR_848484,       3,  sy - 4,      59,  sy - 4);
	graphic_box(sht, COLOR_848484,      59, sy - 23,      59,  sy - 5);
	graphic_box(sht, COLOR_000000,       2,  sy - 3,      59,  sy - 3);
	graphic_box(sht, COLOR_000000,      60, sy - 24,      60,  sy - 3);

	graphic_box(sht, COLOR_848484, sx - 95, sy - 24,  sx - 4, sy - 24);
	graphic_box(sht, COLOR_848484, sx - 95, sy - 23, sx - 95,  sy - 4);
	graphic_box(sht, COLOR_FFFFFF, sx - 95,  sy - 3,  sx - 4,  sy - 3);
	graphic_box(sht, COLOR_FFFFFF,  sx - 3, sy - 24,  sx - 3,  sy - 3);
	return;
}

void mcursor_init(unsigned char *mouse, char bc)
{
	static char cursor[16][10] = {
		"*.........",
		"**........",
		"*O*.......",
		"*OO*......",
		"*OOO*.....",
		"*OOOO*....",
		"*OOOOO*...",
		"*OOOOOO*..",
		"*OOOOOOO*.",
		"*OOOOO****",
		"*OO*OO*...",
		"*O*.*OO*..",
		"**..*OO*..",
		"*....*OO*.",
		".....*OO*.",
		"......**.."
	};
	int x, y;

	for(y = 0; y < 16; y++) {
		for(x = 0; x < 10; x++) {
			if(cursor[y][x] == '*') {
				mouse[y * 10 + x] = COLOR_000000;
			} else if(cursor[y][x] == 'O') {
				mouse[y * 10 + x] = COLOR_FFFFFF;
			} else if(cursor[y][x] == '.') {
				mouse[y * 10 + x] = bc;
			}
		}
	}
	return;
}

unsigned char rgb2pal(int r, int g, int b, int x, int y)
{
	static int t[4] = {3, 1, 0, 2};
	int i;

	x &= 1;	/*  */
	y &= 1;
	i = t[y * 2 + x];	/* ԐF邽߂̒萔 */
	r = (r * 21) / 256;	/* 0`20ɂ */
	g = (g * 21) / 256;
	b = (b * 21) / 256;
	r = (r + i) / 4;	/* 0`5ɂ */
	g = (g + i) / 4;
	b = (b + i) / 4;
	return 16 + r + g * 6 + b * 36;
}

void graphic_box(struct sheet *sht, unsigned char c, int x0, int y0, int x1, int y1)
{
	int x, y;

	for(y = y0; y <= y1; y++) {
		for(x = x0; x <= x1; x++) {
			sht->buf[y * sht->sx + x] = c;
		}
	}
	return;
}

void graphic_block(unsigned char *buf, int vxsize, int pxsize, int pysize, int px, int py, unsigned char *fbuf, int bxsize)
{
	int x, y;

	for(y = 0; y < pysize; y++) {
		for(x = 0; x < pxsize; x++) {
			buf[(py + y) * vxsize + (px + x)] = fbuf[y * bxsize + x];
		}
	}
	return;
}

void graphic_font(unsigned char *buf, int xsize, unsigned char c, int x, int y, unsigned char *font)
{
	char *p, d;
	int i;

	for(i = 0; i < 16; i++) {
		p = buf + (y + i) * xsize + x;
		d = font[i];
		if((d & 0x80) != 0) { p[0] = c; }
		if((d & 0x40) != 0) { p[1] = c; }
		if((d & 0x20) != 0) { p[2] = c; }
		if((d & 0x10) != 0) { p[3] = c; }
		if((d & 0x08) != 0) { p[4] = c; }
		if((d & 0x04) != 0) { p[5] = c; }
		if((d & 0x02) != 0) { p[6] = c; }
		if((d & 0x01) != 0) { p[7] = c; }
	}
	return;
}

void graphic_fonts(struct sheet *sht, int b, int c, int x, int y, unsigned char *s)
{
	int l;

	for(l = 0; s[l] != 0; l++) { }
	if(b != -1) {
		graphic_box(sht, b, x, y, x + l * 8 - 1,y + 15);
	}
	graphic_fontssub(sht->buf, sht->sx, c, x, y, s);
	sheet_refresh(sht, x - 8, y, x + l * 8, y + 16);
	return;
}

void graphic_nfonts(struct sheet *sht, int b, int c, int x, int y, unsigned char *s, int l)
{
	if(b != -1) {
		graphic_box(sht, b, x, y, x + l * 8 - 1,y + 15);
	}
	graphic_fontssub(sht->buf, sht->sx, c, x, y, s);
	sheet_refresh(sht, x - 8, y, x + l * 8, y + 16);
	return;
}

void graphic_fontssub(unsigned char *buf, int xsize, unsigned char c, int x, int y, unsigned char *s)
{
	struct task *task = task_now();
	char *font;
	int k, t;

	for(; *s != 0; *s++) {	/* VtgJIS[h */
		if(task->lbyte == 0) {
			if((0x81 <= *s && *s <= 0x9f) || (0xe0 <= *s && *s <= 0xfc)) {	/* Sp */
				task->lbyte = *s;
			} else {
				graphic_font(buf, xsize, c, x, y, nihongo + *s * 16);
			}
		} else {
			if(0x81 <= task->lbyte && task->lbyte <= 0x9f) {	/* 1 */
				k = (task->lbyte - 0x81) * 2;
			} else {	/* 2 */
				k = (task->lbyte - 0xe0) * 2 + 62;
			}
			if(0x40 <= *s && *s <= 0x7e) {	/* Ő */
				t = *s - 0x40;
			} else if(0x80 <= *s && *s <= 0x9e) {	/* Ő */
				t = *s - 0x80 + 63;
			} else {	/* ̋ */
				t = *s - 0x9f;
				k++;
			}
			task->lbyte = 0;
			font = nihongo + 256 * 16 + (k * 94 + t) * 32;
			graphic_font(buf, xsize, c, x - 8, y, font);	/*  */
			graphic_font(buf, xsize, c, x, y, font + 16);	/* E */
		}
		x += 8;
	}
	return;
}
