/* RTCƎv */

#include "bootpack.h"
#include <stdio.h>

struct clock clock;	/* VXeS */

void clock_task(struct sheet *sht)
{
	struct timer *timer;
	char s[12];
	int fbuf[32], i;

	fifo_init(&task_clock->fifo, task_clock, fbuf, 128);
	task_clock->fifo.task = task_clock;
	timer = timer_alloc();
	timer_init(timer, &task_clock->fifo, 1);
	timer_set(timer, 0);
	for(;;) {
		cli();
		if(fifo_stat(&task_clock->fifo) == 0) {
			task_sleep(task_clock);
			sti();
		} else {
			i = fifo_get(&task_clock->fifo);
			if(i == 1) {
				rtc_read(&clock);
				sprintf(s, "%02d/%02d %02d:%02d", clock.month, clock.day, clock.hour, clock.min);
				graphic_fonts(sht, COLOR_C6C6C6, COLOR_000000, shts->xsize - 92, 8, s);
				timer_set(timer, 100);
			}
		}
	}
}

void clock_tinit(struct sheet *sht_tbar)
{
	task_clock = task_alloc();
	task_clock->stack = memory_alloc(mem, 65536);
	task_clock->tss.eip = (int) &clock_task;
	task_clock->tss.esp = task_clock->stack + 65536 - 8;
	task_clock->tss.es = 1 * 8;
	task_clock->tss.cs = 2 * 8;
	task_clock->tss.ss = 1 * 8;
	task_clock->tss.ds = 1 * 8;
	task_clock->tss.fs = 1 * 8;
	task_clock->tss.gs = 1 * 8;

	*((int *) (task_clock->tss.esp + 4)) = (int) sht_tbar;
	task_run(task_clock, 2, 2);
	return;
}

void clock_get(struct clock *clck)
{
	clck->sec = clock.sec;
	clck->min = clock.min;
	clck->hour = clock.hour;
	clck->day = clock.day;
	clck->month = clock.month;
	clck->year = clock.year;
	return;
}

int cmos_read(unsigned char addr)
{
	outb(PORT_RTC_SREG, addr);
	return inb(PORT_RTC_DATA);
}

void rtc_read(struct clock *clock)
{
	static unsigned char addr[7] = {
		0x00, 0x02, 0x04, 0x07, 0x08, 0x09, 0x32
	};	/* bAAAAAÑAhX */
	static unsigned char max[7] = {
		0x60, 0x59, 0x23, 0x31, 0x12, 0x99, 0x99
	};	/* bAAAAAN̍ő吔 */
	int i;
	unsigned char t[8];
	char err;

	for(;;) {	/* ǂݍ݂܂ŌJԂ */
		err = 0;
		for(i = 0;i < 7;i++) {
			outb(PORT_RTC_SREG, addr[i]);
			t[i] = inb(PORT_RTC_DATA);
		}
		for(i = 0;i < 7;i++) {
			outb(PORT_RTC_SREG, addr[i]);
			if((int) t[i] != inb(PORT_RTC_DATA) || ((int) t[i] & 0x0f) > 9 || (int) t[i] > (int) max) {
				err = 1;
			}
		}
		if(err == 0) {	/* i[ */
			clock->sec = (t[0] >> 4) * 10 + (t[0] & 0x0f);
			clock->min = (t[1] >> 4) * 10 + (t[1] & 0x0f);
			clock->hour = (t[2] >> 4) * 10 + (t[2] & 0x0f);
			clock->day = (t[3] >> 4) * 10 + (t[3] & 0x0f);
			clock->month = (t[4] >> 4) * 10 + (t[4] & 0x0f);
			clock->year = (t[6] >> 4) * 1000 + (t[6] & 0x0f) * 100 + (t[5] >> 4) * 10 + (t[5] & 0x0f);
			return;
		}
	}
	return;
}
