; AZů֐

[format "WCOFF"]	; IuWFNgt@C
[instrset "i486p"]	; i486̖߂g
[bits 32]	 	; 32rbgp@B
[file "naskfunc.nas"]	; \[Xt@C
	global _hlt, _cli, _sti, _stihlt
	global _inb, _inw, _ind
	global _outb, _outw, _outd
	global _leflags, _seflags, _lcr0, _scr0
	global _lgdtr, _lidtr, _ltr
	global _farjmp, _farcall, _app_start
	global _except_asm_fpu, _except_asm_general, _except_asm_stack
	global _timer_aihandle, _keyboard_aihandle, _fdc_aihandle, _except_asm_dfint
	global _mouse_aihandle
	global _api_asm, _app_end
	global _memory_testsub
	global _clts, _fnsave, _frstor
	extern _except_fpu, _except_general, _except_stack
	extern _timer_ihandle, _keyboard_ihandle, _fdc_ihandle, _except_asm_dfint
	extern _mouse_ihandle
	extern _api

; ۂ̊֐
[section .txt]
_hlt:
	hlt
	ret

_cli:
	cli
	ret

_sti:
	sti
	ret

_stihlt:
	sti
	hlt
	ret

_inb:
	mov edx, [esp + 4]	; port
	mov eax, 0
	in al, dx
	ret

_inw:
	mov edx, [esp + 4]	; port
	mov eax, 0
	in ax, dx
	ret

_inbd:
	mov edx, [esp + 4]	; port
	in eax, dx
	ret

_outb:
	mov edx, [esp + 4]	; port
	mov al, [esp + 8]	; data
	out dx, al
	ret

_outw:
	mov edx, [esp + 4]	; port
	mov eax, [esp + 8]	; data
	out dx, ax
	ret

_outd:
	mov edx, [esp + 4]	; port
	mov eax, [esp + 8]	; data
	out dx, eax
	ret

_leflags:
	pushfd	; push eflags
	pop eax
	ret

_seflags:
	mov eax, [esp + 4]
	push eax
	popfd	; pop eflags
	ret

_lcr0:
	mov eax, cr0
	ret

_scr0:
	mov eax, [esp + 4]
	mov cr0, eax
	ret

_lgdtr:
	mov ax, [esp + 4]	; limit
	mov [esp + 6], ax	; esp+4l l l l a a a ǎ`
	lgdt [esp + 6]		; esp+6l l a a a ǎ`ɕς
	ret

_lidtr:
	mov ax, [esp + 4]	; limit
	mov [esp + 6], ax	; esp+4l l l l a a a ǎ`
	lidt [esp + 6]		; esp+6l l a a a ǎ`ɕς
	ret

_ltr:
	ltr [esp + 4]	; tr
	ret

_farjmp:
	jmp far [esp + 4]	; eip, cs
	ret

_farcall:
	call far [esp + 4]	; eip, cs
	ret

_app_start:
	pushad			; ׂĕۑ
	mov eax, [esp + 36]	; AvpEIP
	mov ecx, [esp + 40]	; AvpCS
	mov ebx, [esp + 44]	; AvpDS
	mov edx, [esp + 48]	; AvpESP
	mov ebp, [esp + 52]	; tss.esp0̃AhX
	mov [ebp], esp		; OSpESP
	mov [ebp + 4], ss		; OSpSS
	mov es, bx
	mov ds, bx
	mov fs, bx
	mov gs, bx
	; RETFŃAv֍s߂̃X^bNݒ
	or ecx, 3	; AvpCS3OR
	or ebx, 3	; AvpDS3OR
	push ebx	; AvSS
	push edx	; AvESP
	push ecx	; AvCS
	push eax	; AvEIP
	retf

_except_asm_fpu:
	sti
	push es
	push ds
	pushad
	mov eax, esp
	push eax
	mov ax, ss
	mov ds, ax
	mov es, ax
	call _except_fpu
	cmp eax, 0
	jne _app_end
	pop eax
	popad
	pop ds
	pop es
	iretd

_except_asm_stack:
	sti
	push es
	push ds
	pushad
	mov eax, esp
	push eax
	mov ax, ss
	mov ds, ax
	mov es, ax
	call _except_stack
	cmp eax, 0
	jne _app_end
	pop eax
	popad
	pop ds
	pop es
	add esp, 4
	iretd

_except_asm_general:
	sti
	push es
	push ds
	pushad
	mov eax, esp
	push eax
	mov ax, ss
	mov ds, ax
	mov es, ax
	call _except_general
	cmp eax, 0
	jne _app_end
	pop eax
	popad
	pop ds
	pop es
	add esp, 4	; O̊֐ւ̖߂𔲂ƌĂяoŌmo
	iretd

_timer_aihandle:
	push es
	push ds
	pushad
	mov eax, esp
	push eax
	mov ax, ss
	mov ds, ax
	mov es, ax
	call _timer_ihandle
	pop eax
	popad
	pop ds
	pop es
	iretd

_keyboard_aihandle:
	push es
	push ds
	pushad
	mov eax, esp
	push eax
	mov ax, ss
	mov ds, ax
	mov es, ax
	call _keyboard_ihandle
	pop eax
	popad
	pop ds
	pop es
	iretd

_fdc_aihandle:
	push es
	push ds
	pushad
	mov eax, esp
	push eax
	mov ax, ss
	mov ds, ax
	mov es, ax
	call _fdc_ihandle
	pop eax
	popad
	pop ds
	pop es
	iretd

_except_asm_dfint:
	sti
	push es
	push ds
	pushad
	mov eax, esp
	push eax
	mov ax, ss
	mov ds, ax
	mov es, ax
	call _except_asm_dfint
	cmp eax, 0
	jne _app_end
	pop eax
	popad
	pop ds
	pop es
	add esp, 4
	iretd

_mouse_aihandle:
	push es
	push ds
	pushad
	mov eax, esp
	push eax
	mov ax, ss
	mov ds, ax
	mov es, ax
	call _mouse_ihandle
	pop eax
	popad
	pop ds
	pop es
	iretd

_api_asm:
	sti
	push ds
	push es
	pushad		; ۑ̂
	pushad		; apiɓn
	mov ax, ss
	mov ds, ax	; OSp̃ZOgDSAESɂ
	mov es, ax
	call _api
	cmp eax, 0	; eax0łȂ΃AvI
	jne _app_end
	add esp, 32
	popad
	pop es
	pop ds
	iretd

_app_end:
	mov esp, [eax]
	mov dword [eax + 4], 0
	popad
	ret

_memory_testsub:
; CŏƃRpCœKĂ܂āA肭Ȃ̂ŃAZuŏ
	; WX^g߂ɃX^bNփvbV
	push edi
	push esi
	push ebx

	; p^[ƃ[vpϐi̐ݒ
	mov esi, 0xaa55aa55	; p^[P
	mov edi, 0x55aa55aa	; p^[Q
	mov eax, [esp + 12 + 4]	; i = start;

test_loop:
	; 4KB邽߁AŌ4Byte邽߂0x0ffc𑫂
	; O̒lāAp^[݁A]
	mov ebx, eax
	add ebx, 0x0ffc			; p = i+0x0ffc;
	mov edx, [ebx]			; old = *p;
	mov [ebx], esi			; *p = pat0;
	xor dword [ebx], 0xffffffff	; *p ^= 0xffffffff;

	; ]ʂA܂ĂȂȂA݂ȂƂ݂Ȃ
	cmp edi, [ebx]			; if(*p != pat1) goto test_fin;
	jne test_fin

	; x]āAɖ߂Ă邩mF
	xor dword[ebx], 0xffffffff	; *p ^= 0xffffffff;
	cmp esi, [ebx]			; if(*p != pat0) goto test_fin;
	jne test_fin

	; ̓eɖ߂āAAhX4KBāAŜ`FbN悤ɌJԂ
	mov [ebx], edx			; *p = old;
	add eax, 0x1000			; i += 0x1000;
	cmp eax, [esp + 12 + 8]		; if(i <= end) goto test_loop;
	jbe test_loop

	; WX^ɖ߂āA߂
	pop ebx
	pop esi
	pop edi
	ret

test_fin:
	; ̃f[^ƃWX^ɖ߂āA߂
	mov [ebx], edx			; *p = old;
	pop ebx
	pop esi
	pop edi
	ret

_clts:
	clts
	ret

_fnsave:
	mov eax, [esp + 4]	; addr
	fnsave [eax]
	ret

_frstor:
	mov eax, [esp + 4]	; addr
	frstor [eax]
	ret
