/* t@C֌W */

#include "bootpack.h"

int fat_read(int *fat, unsigned char *img)
{
	int i, j = 0;

	for(i = 0; i < 2880; i += 2) {
		fat[i] = (img[j] | img[j + 1] << 8) & 0xfff;
		fat[i + 1] = (img[j + 1] >> 4 | img[j + 2] << 4) & 0xfff;
		j += 3;
	}
	return 0;
}

int fat_write(unsigned char *img, int *fat)
{
	int i, j = 0;

	/* }X^FAT */
	for(i = 0; j < 2880; i += 3) {
		img[i] = (unsigned char) (fat[j] & 0x0ff);
		img[i + 1] = (unsigned char) ((fat[j + 1] & 0x00f) << 4 | (fat[j] & 0xf00) >> 8);
		img[i + 2] = (unsigned char) ((fat[j + 1] & 0xff0) >> 4);
		j += 2;
	}

	/* obNAbvFAT */
	for(j = 0; j < 2880; i += 3) {
		img[i] = (unsigned char) (fat[j] & 0x0ff);
		img[i + 1] = (unsigned char) ((fat[j + 1] & 0x00f) << 4 | (fat[j] & 0xf00) >> 8);
		img[i + 2] = (unsigned char) ((fat[j + 1] & 0xff0) >> 4);
		j += 2;
	}

	/* I/Oɏv */
	for(i = 1; i <= 18; i++) {
		io_req(IO_WRITE, i);
	}

	/* I/ȌԎ擾 */
	for(i = 1; i <= 18; i++) {
		j = io_stat(IO_WRITE, i);
		if(j == 1) {
			return 1;
		}
	}
	return 0;
}

int fat_get(int *fat)
{
	int i;

	for(i = 0; i < 2880; i++) {
		if(fat[i] == 0x000) {
			fat[i] = 0x1000;
			return i;
		}
	}
	return 0x000;
}

struct file *file_search(unsigned char *name)
{
	struct file *file = (struct file *) FILE_ENTRY_ADDR;
	int i, j;
	char s[11];

	/* t@C̏ */
	for(i = 0; i < 11; i++) {
		s[i] = ' ';
	}
	j = 0;
	for(i = 0; i < 11 && name[j]; j++) {
		if(name[j] == '.' && i <= 8) {
			i = 8;
		} else {
			s[i] = name[j];
			if('a' <= s[i] && s[i] <= 'z')	/* 啶֕ϊ */
				s[i] -= 0x20;
			i++;
		}
	}

	/* t@Č */
	for(i = 0;i < 224;i++) {
		if((file[i].name[0] != 0x00) && ((file[i].type&0x18) == 0)) {
			for(j = 0;j < 11;j++) {
				if(s[j] != file[i].name[j])
					break;
			}
			if(j == 11)
				return &file[i];
		} else
			return 0;
	}
	return 0;
}

struct file *file_create(unsigned char *name)
{
	struct file *file = file_search(name);
	unsigned short cno;
	int i, j, k;
	char s[11];

	if(file != 0) {
		return (struct file *) -1;
	} else {
		/* Gg */
		file = (struct file *) FILE_ENTRY_ADDR;
		for(i = 0; i < 224; i++) {
			if((file[i].name[0] == 0x00) || (file[i].name[0] == 0xe5)) {
				break;
			}
		}
		if(i == 224) {
			return (struct file *) -2;
		}
		k = i;
		file = &file[k];

		/* t@C̏ */
		for(i = 0; i < 11; i++) {
			s[i] = ' ';
		}
		j = 0;
		for(i = 0; i < 11 && name[j]; ) {
			if(name[j] == '.' && i <= 8) {
				i = 8;
				j++;
			} else {
				s[i] = name[j];
				if('a' <= s[i] && s[i] <= 'z') {/* 啶֕ϊ */
					s[i] -= 0x20;
				}
				i++;
				j++;
			}
		}
		for(i = 0; i < 11;i++) {
			file->name[i] = s[i];
		}

		/* ȅ */
		file->type = FILE_DEFAULT;
		cno = fat_get(fat);
		file->cno = cno;
		fat[cno] = 0x0fff;
		file->size = 0;

		/* ̏ */
		file_settime(file);
		return file;
	}

	return 0;
}

int file_delete(struct file *file)
{
	int cno, ncno, i;

	/* t@CGg̍폜 */
	file->name[0] = 0xe5;

	/* FATւ̃}[N */
	ncno = file->cno;
	for(; fat[ncno] >= 0x0ff8; ) {
		cno = ncno;
		ncno = fat[cno];
		fat[cno] = 0x0000;
	}
	fat_write((char *) FAT_ADDR, fat);
	if(i != 0) {
		return 1;
	}
	return 0;
}

char *file_read(int cno, int *s)
{
	char *b, *b2;
	int size = *s, size2, i;

	b = (char *)memory_alloc(mem, size);
	i = file_readsub(b, cno, size);
	if(i != 0) {
		return 0;
	}
	if(size >= 17) {
		if((size2 = tek_getsize(b)) > 0) {	/* tekkĂ */
			b2 = (char *)memory_alloc(mem, size2);
			tek_decomp(b, b2, size2);
			memory_free(mem, (int) b, size);
			b = b2;
			*s = size2;
		}
	}
	return b;
}

int file_write(struct fhandle *fh, int *fat, int size)
{
 	char *img = (char *) FILE_DATA_ADDR;
	int wsize = 0, ncno = fh->cno, cno = 0, size0 = size, i;
	char *buf;

	buf = fh->buf;
	for(; ; ) {
		cno = ncno;
		/* Ō512bȉȂ炵菈āA */
		if(size <= 512) {
			for(i = 0; i < size; i++) {
				img[cno * 512 + i] = buf[i];
			}
			wsize += i;
			if(fat[cno] == 0x1000) {
				fat[cno] = 0xfff;
			}
			/* I/Oɏv */
			io_req(IO_WRITE, 31 + cno);
			break;
		}

		/* C[W֏ */
		for(i = 0; i < 512; i++) {
			img[cno * 512 + i] = buf[i];
		}
		buf += 512;
		size -= 512;
		wsize += 512;

		/* I/Oɏv */
		io_req(IO_WRITE, 31 + cno);

		/* FATȂȂt */
		if(fat[cno] == 0x000 || fat[cno] >= 0xff8) {
			fat[cno] = 0xfff;
			ncno = fat_get(fat);
			fat[cno] = ncno;
		} else {
			ncno = fat[cno];
		}
	}

	/* I/ȌԎ擾 */
	cno = fh->cno;
	for(;;) {
		if(io_stat(IO_WRITE, 31 + cno) == 1) {
			return 1;
		}
		size0 -= 512;
		if(size0 <= 0) {
			break;
		}
		cno = fat[cno];
	}

	/* FATXV */
	i = fat_write((char *) FAT_ADDR, fat);
	if(i != 0) {
		return -1;
	}

	/* t@CGgXV */
	file_settime(fh->f);
	if(fh->f->size < fh->pos + wsize) {
		fh->size += wsize - fh->f->size % 512;
		fh->f->size = fh->size;
	}
	i = ((int) fh->f - DISKIMG_ADDR) / 512;
	io_req(IO_WRITE, i);
	if(io_stat(IO_WRITE, i) == 1) {
		return 1;
	}

	/* obt@ď */
	fh->bpos = 0;
	file_setbuf(fh, fat, cno);
	return wsize;
}

int file_readsub(char *buf, int cno, int size)
{
	char *img = (char *) FILE_DATA_ADDR;
	int cno2 = cno, size2 = size, i;

	/* I/Oɏv */
	for(;;) {
		io_req(IO_READ, 31 + cno2);
		if(size2 <= 0) {
			break;
		}
		size2 -= 512;
		cno2 = fat[cno2];
	}

	for(;;) {
		/* I/ȌԎ擾 */
		if(io_stat(IO_READ, 31 + cno) == 1) {
			return 1;
		}

		/* obt@֊i[ */
		if(size <= 512) {
			for(i = 0; i < size; i++) {
				buf[i] = img[cno * 512 + i];
			}
			return 0;
		}
		for(i = 0; i < 512; i++) {
			buf[i] = img[cno * 512 + i];
		}
		size -= 512;
		buf += 512;
		cno = fat[cno];
	}
}

void file_setbuf(struct fhandle *fh, int *fat, int sect)
{
	int i;
	char *img = (char *)FILE_DATA_ADDR;

	/* ؂ւOɍ̓etbV */
	if(fh->bpos != 0) {
		file_write(fh, fat, fh->bpos);
	}

	/* 4k̃obt@ۏႷBZN^̃f[^
	   ƂŏȑfB */
	memory_free(mem, (int) fh->buf, fh->bsize);
	fh->buf = (char *) memory_alloc(mem, 4096);
	fh->bsize = 4096;
	fh->cno = sect;
	for(i = 0; i < 512; i++) {
		if(img[fh->cno * 512 + i] != 0) {
			fh->buf[i] = img[fh->cno * 512 + i];
		}
	}
	return;
}

void file_settime(struct file *file)
{
	file->time = (clock.hour - 9) << 9 | clock.min << 5 | clock.sec >> 2;
	file->date = (clock.year - 1980) << 11 | clock.month << 5 | clock.day;
	return;
}
