/*
 * Decompiled with CFR 0.152.
 */
package org.yodatomato.haikubrowser.threads;

import java.util.List;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.yodatomato.haikubrowser.beans.Controls;
import org.yodatomato.haikubrowser.beans.DisplayEntry;
import org.yodatomato.haikubrowser.beans.Entry;
import org.yodatomato.haikubrowser.threads.AbstractDisplaySW;
import org.yodatomato.haikubrowser.util.Connector;

public class DisplayKeywordTimelineSW
extends AbstractDisplaySW {
    private DefaultTableModel targetTblModel;
    private JButton targetRedispBut;
    private JButton targetNextBut;
    private JTable targetTbl;
    private int pageNum;
    private String keywordStr;

    private DisplayKeywordTimelineSW() {
    }

    public DisplayKeywordTimelineSW(Controls control, int page, String keyword) {
        this();
        this.targetTblModel = control.getTargetModel();
        this.targetTbl = control.getTargetTable();
        this.targetRedispBut = control.getTargetRedisp();
        this.targetNextBut = control.getTargetNextp();
        this.pageNum = page;
        this.keywordStr = keyword;
    }

    @Override
    protected Object doInBackground() throws Exception {
        Connector conn = new Connector();
        this.targetRedispBut.setEnabled(false);
        this.targetNextBut.setEnabled(false);
        try {
            List<Entry> entries = conn.getKeywordTimeline(this.keywordStr, this.pageNum);
            int i = 0;
            while (i < entries.size()) {
                Entry entry = entries.get(i);
                DisplayEntry disp = this.getDisplayEntry(entry);
                this.targetTblModel.addRow(disp.returnObjectArray());
                this.targetTbl.setRowHeight(i, disp.getHeight());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    protected void done() {
        super.done();
        this.targetRedispBut.setEnabled(true);
        this.targetNextBut.setEnabled(true);
    }
}

