/*
 * Decompiled with CFR 0.152.
 */
package org.yodatomato.haikubrowser.main;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.yodatomato.haikubrowser.beans.Controls;
import org.yodatomato.haikubrowser.threads.AbstractDisplaySW;
import org.yodatomato.haikubrowser.threads.DisplayKeywordTimelineSW;
import org.yodatomato.haikubrowser.threads.DisplayPublicTimelineSW;
import org.yodatomato.haikubrowser.util.HaikuEntryTableModel;
import org.yodatomato.haikubrowser.util.HaikuUtil;

public class HaikuBrowser
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JTextField keywordField = null;
    private JButton redispButton = null;
    private JButton nextPage = null;
    private final SpringLayout layout = new SpringLayout();
    private JScrollPane scrollpaneForEntries = null;
    private JTable entryTable = null;
    private final String[] contentsName = new String[]{"Hiker", "Entry"};
    private HaikuEntryTableModel model = null;
    private String currentKeyword = "";
    private int currentPage = 1;
    private final String TITLE = "\u30cf\u30a4\u30af\u3076\u3089\u3046\u3056";
    private Controls control = null;

    public HaikuBrowser() {
        this.initialize();
    }

    public static void main(String[] args) {
        HaikuBrowser hb = new HaikuBrowser();
        hb.setDefaultCloseOperation(3);
        hb.setVisible(true);
    }

    private Controls getControl() {
        if (this.control == null) {
            this.control = new Controls();
            this.control.setTargetTable(this.getEntryTable());
            this.control.setTargetRedisp(this.getRedispButton());
            this.control.setTargetNextp(this.getNextPage());
            this.control.setTargetModel(this.model);
        }
        return this.control;
    }

    private void initialize() {
        this.setSize(700, 600);
        this.setContentPane(this.getJContentPane());
        this.setTitle("\u30cf\u30a4\u30af\u3076\u3089\u3046\u3056");
        DisplayPublicTimelineSW thread = new DisplayPublicTimelineSW(this.getControl(), this.currentPage);
        thread.execute();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(this.layout);
            this.jContentPane.add((Component)this.getKeywordField(), null);
            this.jContentPane.add((Component)this.getRedispButton(), null);
            this.jContentPane.add((Component)this.getScrollpaneForEntries(), null);
            this.jContentPane.add((Component)this.getNextPage(), null);
            this.setLayoutConstratint();
        }
        return this.jContentPane;
    }

    private JTextField getKeywordField() {
        if (this.keywordField == null) {
            this.keywordField = new JTextField();
        }
        return this.keywordField;
    }

    private JButton getRedispButton() {
        if (this.redispButton == null) {
            this.redispButton = new JButton();
            this.redispButton.setText("\u66f4\u65b0");
            this.redispButton.addActionListener(this);
        }
        return this.redispButton;
    }

    private JButton getNextPage() {
        if (this.nextPage == null) {
            this.nextPage = new JButton();
            this.nextPage.setText("\u25bc");
            this.nextPage.addActionListener(this);
            this.nextPage.setEnabled(false);
        }
        return this.nextPage;
    }

    private void setLayoutConstratint() {
        this.layout.putConstraint("North", (Component)this.getKeywordField(), 10, "North", (Component)this.jContentPane);
        this.layout.putConstraint("West", (Component)this.getKeywordField(), 5, "West", (Component)this.jContentPane);
        this.layout.putConstraint("North", (Component)this.getRedispButton(), 10, "North", (Component)this.jContentPane);
        this.layout.putConstraint("East", (Component)this.getRedispButton(), -5, "East", (Component)this.jContentPane);
        this.layout.putConstraint("East", (Component)this.getKeywordField(), -5, "West", (Component)this.getRedispButton());
        this.layout.putConstraint("South", (Component)this.getRedispButton(), 0, "South", (Component)this.getKeywordField());
        this.layout.putConstraint("North", (Component)this.getScrollpaneForEntries(), 10, "South", (Component)this.getKeywordField());
        this.layout.putConstraint("West", (Component)this.getScrollpaneForEntries(), 0, "West", (Component)this.getKeywordField());
        this.layout.putConstraint("East", (Component)this.getScrollpaneForEntries(), 0, "East", (Component)this.getRedispButton());
        this.layout.putConstraint("South", (Component)this.getScrollpaneForEntries(), 0, "North", (Component)this.getNextPage());
        this.layout.putConstraint("North", (Component)this.getNextPage(), -30, "South", (Component)this.jContentPane);
        this.layout.putConstraint("West", (Component)this.getNextPage(), 0, "West", (Component)this.getKeywordField());
        this.layout.putConstraint("East", (Component)this.getNextPage(), 50, "West", (Component)this.getKeywordField());
        this.layout.putConstraint("South", (Component)this.getNextPage(), -5, "South", (Component)this.jContentPane);
    }

    private JScrollPane getScrollpaneForEntries() {
        if (this.scrollpaneForEntries == null) {
            this.scrollpaneForEntries = new JScrollPane();
            this.scrollpaneForEntries.setViewportView(this.getEntryTable());
        }
        return this.scrollpaneForEntries;
    }

    private JTable getEntryTable() {
        if (this.entryTable == null) {
            this.model = new HaikuEntryTableModel(this.contentsName, 0);
            this.entryTable = new JTable(this.model);
            this.entryTable.setRowHeight(200);
            this.entryTable.setAutoResizeMode(3);
            this.entryTable.getColumnModel().getColumn(0).setPreferredWidth(100);
            this.entryTable.getColumnModel().getColumn(0).setMaxWidth(100);
        }
        return this.entryTable;
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        AbstractDisplaySW worker = null;
        if (action.getSource().equals(this.redispButton)) {
            int row = this.model.getRowCount() - 1;
            while (row >= 0) {
                this.model.removeRow(row);
                --row;
            }
            this.currentPage = 1;
            if (HaikuUtil.isNotEmpty(this.keywordField.getText())) {
                if (!this.currentKeyword.equals(this.keywordField.getText())) {
                    this.currentKeyword = this.keywordField.getText();
                }
                worker = new DisplayKeywordTimelineSW(this.getControl(), this.currentPage, this.currentKeyword);
            } else {
                this.currentKeyword = "";
                worker = new DisplayPublicTimelineSW(this.getControl(), this.currentPage);
            }
            worker.execute();
        } else if (action.getSource().equals(this.nextPage)) {
            ++this.currentPage;
            if (HaikuUtil.isNotEmpty(this.keywordField.getText())) {
                if (!this.currentKeyword.equals(this.keywordField.getText())) {
                    this.currentKeyword = this.keywordField.getText();
                }
                worker = new DisplayKeywordTimelineSW(this.getControl(), this.currentPage, this.currentKeyword);
            } else {
                this.currentKeyword = "";
                worker = new DisplayPublicTimelineSW(this.getControl(), this.currentPage);
            }
            worker.execute();
        }
    }
}

