/* $Id: togglebutton.cc 24 2003-12-20 01:38:09Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#include "togglebutton.h"

#include <boost/bind.hpp>
using boost::ref;
using boost::bind;

namespace Grs {

ToggleButton::ToggleButton(const char* name, const boost::function<void()>& start, const boost::function<void()>& stop)
    : Gtk::ToggleButton(name), m_start(start), m_stop(stop)
{
}

ToggleButton::ToggleButton(const char* name, Property<bool>& flag)
    : Gtk::ToggleButton(name)
{
    set_active(flag);
    flag.connect(bind(&Gtk::ToggleButton::set_active, ref(*this), ref(flag)));
    m_start = bind(&Property<bool>::set_value, ref(flag), true);
    m_stop = bind(&Property<bool>::set_value, ref(flag), false);
}


ToggleButton::ToggleButton(const char* name, const boost::function<void(bool)>& func)
    : Gtk::ToggleButton(name),
      m_start(boost::bind(func, true)), m_stop(boost::bind(func, false))
{
}

ToggleButton::~ToggleButton()
{
}

void
ToggleButton::on_toggled()
{
    if (get_active())
        m_start();
    else
        m_stop();
}

}
