/* $Id$
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#ifndef GRS_PROPERTY_TCC
#error "Don't include grs/property.tcc."
#endif

namespace Grs {

template < typename T >
Property<T>::Property(const T& val, const char* name)
    : m_val(val), m_name(name), m_signal()
{
}

template < typename T >
Property<T>::~Property()
{
}

template < typename T >
boost::signals::connection
Property<T>::connect(const typename boost::signal<void(T)>::slot_type& slot)
{
    return m_signal.connect(slot);
}

template < typename T >
void
Property<T>::set_value(const T& val)
{
    if (m_val != val)
        m_signal(m_val = val);
}

template < typename T >
void
Property<T>::set_name(const char* name)
{
    m_name = name;
}

template < typename T >
const T&
Property<T>::get_value() const
{
    return m_val;
}

template < typename T >
const Glib::ustring&
Property<T>::get_name() const
{
    return m_name;
}

template < typename T >
Property<T>::operator const T&() const
{
    return get_value();
}

template < typename T >
Property<T>&
Property<T>::operator=(const T& val)
{
    set_value(val);
    return *this;
}

template < typename T >
Property<T>&
Property<T>::operator+=(const T& val)
{
    set_value(m_val + val);
    return *this;
}

template < typename T >
Property<T>&
Property<T>::operator-=(const T& val)
{
    set_value(m_val - val);
    return *this;
}

template < typename T >
Property<T>&
Property<T>::operator*=(const T& val)
{
    set_value(m_val * val);
    return *this;
}

template < typename T >
Property<T>&
Property<T>::operator/=(const T& val)
{
    set_value(m_val / val);
    return *this;
}

template < typename T >
std::ostream&
operator<<(std::ostream& out, const Property<T>& property)
{
    out << property.get_name() << '\t' << property.get_value() << '\n';
    return out;
}

}
