#ifndef ROSSLER_SIM_H
#define ROSSLER_SIM_H

#include <grs/property.h>
#include "rossler.h"

class RosslerSim : public Rossler
{
public:
    Grs::Property<double> dt;
    Grs::Property<int> rep_num;
    Grs::Property<double> t;
    Grs::Property<double> x;
    Grs::Property<double> y;
    Grs::Property<double> z;

public:
    // 
    RosslerSim()
        : Rossler(), dt(0.1, "dt"), rep_num(100, "rep"),
          t(0.0, "t"), x(1.0, "x"), y(0.0, "y"), z(0.0, "z")
    {
    }

    // output η̤
    // ǽ̤ t, x, y, z 
    //  dt, ֤ 100 顼ˡ
    template < typename Output >
        void integrate(Output& output)
    {
        const unsigned dim = 3;
        double tt;
        std::vector<double> xx(dim);

        tt = t;
        xx[0] = x;
        xx[1] = y;
        xx[2] = z;

        std::vector<double> ff(dim);
        for (int n = 0; n < rep_num; ++n) {
            output << tt;
            for (unsigned i = 0; i < dim; ++i)
                output << '\t' << xx[i];
            output << '\n';

            operator()(xx, ff);

            tt += dt;
            for (unsigned i = 0; i < dim; ++i)
                xx[i] += dt*ff[i];
        }

        t = tt;
        x = xx[0];
        y = xx[1];
        z = xx[2];
    }
};

#endif
