#include "rossler_sim.h"
#include <grs/buttonbox.h>
#include <grs/valuelist.h>
#include <grs/graphwindow.h>
#include <grs/graphstream.h>

#include <boost/bind.hpp>
#include <iostream>
#include <fstream>

class RosslerGrs : public Grs::ButtonBoxWindow, public RosslerSim
{
public:
    typedef RosslerGrs Self;

    RosslerGrs()
        // window Υȥ
        : Grs::ButtonBoxWindow("Rossler"), RosslerSim(),
          parlist("parlist"), varlist("varlist"), graph("graph", 2),
        // line 򥰥դϿ
          g(), line1(graph[0]), line2(graph[1])
    {
        // Ͽؿ¹Ԥܥ
        add_func("Quit", boost::bind(&Self::hide, this));

        // дؿϿ -- boost::bind 
        // this->step() ¹Ԥޤ
        add_func("Step", boost::bind(&Self::step, this));

        // дؿϿ -- boost::bind 
        // this->step() ¹Ԥޤ
        add_file_selection("Save", boost::bind(&Self::save, this, _1));

        // åɤϿ -- START/STOP ܥޤ
        // ¹ϡϿؿ򷫤֤¹Ԥޤ
        // Ͽؿ false ֤STOP ܥ򲡤Ȥǽλ
        add_thread("", boost::bind(&Self::run, this));

        // ե饰Ͽ
        add_toggle("Output", out_flag);

        // parlist window ˥ѥ᡼Ͽޤ
        // Grs::ro ꤹȰʹߤѹԲĤΥѥ᡼
        // Grs::rw ꤹѹǽޤ
        parlist << dt << rep_num << a << b << c << Grs::ro << dt;
        // parlist window ɽ/ɽؤܥϿޤ
        add_window(parlist);

        // varlist window ˥ѥ᡼Ͽޤ
        // Grs::set_digits(int) Ǿʲηꤷޤ
        varlist << Grs::set_digits(1) << t
                << Grs::set_digits(6) << x << y << z;
        // varlist window ɽ/ɽؤܥϿޤ
        add_window(varlist);

        // graph 
        graph[0].x1 = -10.0;
        graph[0].x2 =  10.0;
        graph[0].y1 = -10.0;
        graph[0].y2 =  10.0;
        graph[1].y1 =  -5.0;
        graph[1].y2 =  25.0;
        add_window(graph);

        // line 
        line1.property_fill_color().set_value("red");
        line2.property_fill_color().set_value("blue");
    }

    void step()
    {
        g.clear();
        // integrate λ򥰥դκü
        graph[1].x1 = double(t);
        // ȯŸ -- Τ褦ʷǥǡߤ
        // g << t << '\t' << x << '\t' << y << '\'t << z << '\n';
        integrate(g);
        // integrate λ򥰥դαü
        graph[1].x2 = double(t);
        // x-y -> line1
        // Index(0) = x, Index(1) = y
        line1.property_points().set_value(
                g.get_points(Grs::Index(0), Grs::Index(1)));
        // t-z -> line2
        // g.get_points : ҤȤĤ x  t 
        line2.property_points().set_value(g.get_points(Grs::Index(2)));

        // out_flag  on ʤɸϤ
        if (out_flag) std::cout << g;
    }

    bool run()
    {
        step();
        return true;
    }

    bool save(const char* name)
    {
        std::ofstream out(name);
        if (!out) return false;
        out << g;
        return out;
    }

private:
    Grs::Property<bool> out_flag;
    Grs::ValueListWindow parlist;
    Grs::ValueListWindow varlist;
    Grs::GraphWindow       graph;
    Grs::GraphStream g;
    Gnome::Canvas::Line    line1;
    Gnome::Canvas::Line    line2;
};

#include <libgnomecanvasmm/init.h>
#include <gtkmm/main.h>

int
main(int argc, char** argv)
{
    Gnome::Canvas::init();
    Gtk::Main app(argc, argv);
    RosslerGrs sim;
    sim.show_all();
    Gtk::Main::run(sim);
    return 0;
}

