/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.greflect.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.greflect.TypeViolationException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Signature;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeGeneratorClassLoader
extends ClassLoader {
    private static final String[] NULL_STRINGS = new String[0];
    private static final String BYTECODE_CLASSNAME_PACKAGE = "jp.sourceforge.greflect.generated.";
    private static final String BYTECODE_CLASSNAME_PREFIX = "jp.sourceforge.greflect.generated.Ungeneric$$";
    private static final int BYTECODE_MODIFIER = 17;
    private static final short BYTECODE_VERSION_MAJOR = 49;
    private static final short BYTECODE_VERSION_MINOR = 0;
    private static final String ATTRIBUTE_NAME_SIGNATURE = "Signature";
    private static final int BYTEBUF_SIZE = 1024;
    private final Object lock = new Object();
    private int classId = 101;
    private Map<String, LoaderEntry> classesByName = new HashMap<String, LoaderEntry>();

    public BytecodeGeneratorClassLoader() {
    }

    public BytecodeGeneratorClassLoader(ClassLoader deferTo) {
        super(deferTo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constructor<?> generateClassAndGetConstructorFor(Constructor<?> super_cst, String class_signature) throws TypeViolationException, SecurityException, ClassNotFoundException {
        String clsname;
        if (super_cst.getDeclaringClass().getTypeParameters().length == 0) {
            return super_cst;
        }
        Object object = this.lock;
        synchronized (object) {
            clsname = BYTECODE_CLASSNAME_PREFIX + this.classId;
            ++this.classId;
            LoaderEntry e = new LoaderEntry();
            e.classSignature = class_signature;
            e.superConstructor = super_cst;
            this.classesByName.put(clsname, e);
        }
        Class<?> cls = this.loadClass(clsname, true);
        try {
            Constructor<?> cst = cls.getConstructor(super_cst.getParameterTypes());
            return cst;
        }
        catch (NoSuchMethodException ex) {
            throw new TypeViolationException(ex, "The constructor of the generated class is not found. Report it as a bug.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String class_name) throws ClassNotFoundException {
        Class<?> clazz;
        block12: {
            String clsSignature;
            Constructor<?> scst;
            if (class_name == null || !class_name.startsWith(BYTECODE_CLASSNAME_PACKAGE)) {
                throw new ClassNotFoundException("The BytecodeGeneratorClassLoader cannot load the class '" + class_name + "'. Revise ClassLoader setting.");
            }
            Object object = this.lock;
            synchronized (object) {
                LoaderEntry e = this.classesByName.get(class_name);
                if (e == null) {
                    throw new ClassNotFoundException("The generated class '" + class_name + "' is not found. Report it as a bug.");
                }
                scst = e.superConstructor;
                clsSignature = e.classSignature;
            }
            ByteArrayOutputStream bos = null;
            try {
                Class<?> cls;
                ClassGen clsgen = BytecodeGeneratorClassLoader.createUngenericClassGen(class_name, scst, clsSignature);
                bos = new ByteArrayOutputStream(1024);
                clsgen.getJavaClass().dump((OutputStream)bos);
                byte[] bytecode = bos.toByteArray();
                clazz = cls = this.defineClass(class_name, bytecode, 0, bytecode.length);
                if (bos == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                    throw throwable;
                }
                catch (TypeViolationException ex) {
                    throw new ClassNotFoundException("Loading generated class '" + class_name + "' fails to type violstion. Report it as a bug.", ex);
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("Loading generated class '" + class_name + "' fails to I/O. Report it as a bug.", ex);
                }
            }
            bos.close();
        }
        return clazz;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Type makeTypeForClass(Class<?> cls) throws TypeViolationException {
        BasicType t;
        int dim = 0;
        Class<?> c = cls;
        while (c.isArray()) {
            ++dim;
            c = c.getComponentType();
        }
        if (c.isPrimitive()) {
            if (c.equals(Integer.TYPE)) {
                t = BasicType.INT;
            } else if (c.equals(Boolean.TYPE)) {
                t = BasicType.BOOLEAN;
            } else if (c.equals(Byte.TYPE)) {
                t = BasicType.BYTE;
            } else if (c.equals(Double.TYPE)) {
                t = BasicType.DOUBLE;
            } else if (c.equals(Long.TYPE)) {
                t = BasicType.LONG;
            } else if (c.equals(Float.TYPE)) {
                t = BasicType.FLOAT;
            } else if (c.equals(Character.TYPE)) {
                t = BasicType.CHAR;
            } else if (c.equals(Short.TYPE)) {
                t = BasicType.SHORT;
            } else {
                if (!c.equals(Void.TYPE)) throw new TypeViolationException("The primitive type ''{0}'' is unknown. Report it as a bug.", cls);
                t = BasicType.VOID;
            }
        } else {
            t = new ObjectType(c.getName());
        }
        if (dim != 0) return new ArrayType((Type)t, dim);
        return t;
    }

    private static LoadInstruction makeLoadInstruction(Class<?> c, int ix) throws TypeViolationException {
        if (c.isPrimitive()) {
            if (c.equals(Integer.TYPE)) {
                return new ILOAD(ix);
            }
            if (c.equals(Boolean.TYPE)) {
                return new ILOAD(ix);
            }
            if (c.equals(Byte.TYPE)) {
                return new ILOAD(ix);
            }
            if (c.equals(Double.TYPE)) {
                return new DLOAD(ix);
            }
            if (c.equals(Long.TYPE)) {
                return new LLOAD(ix);
            }
            if (c.equals(Float.TYPE)) {
                return new FLOAD(ix);
            }
            if (c.equals(Character.TYPE)) {
                return new ILOAD(ix);
            }
            if (c.equals(Short.TYPE)) {
                return new ILOAD(ix);
            }
            if (c.equals(Void.TYPE)) {
                throw new TypeViolationException("No load instruction for ''{0}'' exists. Report it as a bug.", c);
            }
            throw new TypeViolationException("The primitive type ''{0}'' is unknown. Report it as a bug.", c);
        }
        return new ALOAD(ix);
    }

    static ClassGen createUngenericClassGen(String clsname, Constructor<?> cst, String clsSignature) throws TypeViolationException {
        Class<?> cls = cst.getDeclaringClass();
        Class<?>[] params = cst.getParameterTypes();
        if (cls.isInterface()) {
            throw new TypeViolationException("The type ''{0}'' is a Interface. Revise the type variable.", cls);
        }
        ClassGen clsgen = new ClassGen(clsname, cls.getName(), null, 17, NULL_STRINGS);
        clsgen.setMajor(49);
        clsgen.setMinor(0);
        ConstantPoolGen cpg = clsgen.getConstantPool();
        int ixsign = cpg.addUtf8(ATTRIBUTE_NAME_SIGNATURE);
        int ixsigv = cpg.addUtf8(clsSignature);
        clsgen.addAttribute((Attribute)new Signature(ixsign, 2, ixsigv, cpg.getConstantPool()));
        InstructionList il = new InstructionList();
        Type[] types = new Type[params.length];
        String[] paramnames = new String[params.length];
        int i = params.length;
        while (--i >= 0) {
            types[i] = BytecodeGeneratorClassLoader.makeTypeForClass(params[i]);
            paramnames[i] = "param" + i;
        }
        MethodGen mg = new MethodGen(1, (Type)Type.VOID, types, paramnames, "<init>", clsname, il, clsgen.getConstantPool());
        InstructionFactory factory = new InstructionFactory(clsgen);
        il.append((Instruction)new ALOAD(0));
        int n = 1;
        for (int i2 = 0; i2 < params.length; ++i2) {
            il.append((Instruction)BytecodeGeneratorClassLoader.makeLoadInstruction(params[i2], n));
            if (params[i2].equals(Double.TYPE) || params[i2].equals(Long.TYPE)) {
                n += 2;
                continue;
            }
            ++n;
        }
        il.append((Instruction)factory.createInvoke(cls.getName(), "<init>", (Type)Type.VOID, types, (short)183));
        il.append((Instruction)new RETURN());
        mg.setMaxStack();
        clsgen.addMethod(mg.getMethod());
        il.dispose();
        return clsgen;
    }

    class LoaderEntry {
        Constructor<?> superConstructor = null;
        String classSignature = null;

        LoaderEntry() {
        }
    }
}

