package jp.grain.samples.grain_blog;

import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import jp.grain.samples.grain_blog.bean.*;

import java.util.*;
import java.text.DateFormat;
import org.w3c.dom.*;
import org.xml.sax.SAXException;

public final class BlogServlet extends HttpServlet {

	static private Vector blog = new Vector();
	private Calendar rightNow = Calendar.getInstance();

	public void service(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException {

		String title = "", comment = "";
		
		
		Document doc;
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		try {
			DocumentBuilder builder = factory.newDocumentBuilder();
			doc = builder.parse(new ByteArrayInputStream(request.getQueryString().getBytes()));
		} catch (ParserConfigurationException e) {
			throw new ServletException(e);
		} catch (SAXException saxe) {
			throw new ServletException(saxe);
		} catch (IOException ioe) {
			throw new ServletException(ioe);
		}

		
		Element element = doc.getDocumentElement();
		NodeList nodes = element.getChildNodes();
		Node node = nodes.item(0);
		title = (node.getChildNodes().item(0)).getNodeValue();
		node = nodes.item(1);
		comment = (node.getChildNodes().item(0)).getNodeValue();
		MsgBean msgBean = new MsgBean(title, comment, DateFormat
				.getDateInstance().format(rightNow.getTime()));
		blog.add(msgBean);
		

		request.setAttribute("blog", blog);
		String nextPage = "/index.jsp";
		nextPage = response.encodeURL(nextPage);
		RequestDispatcher rd = getServletContext().getRequestDispatcher(
				nextPage);
		rd.forward(request, response);

	}
}