/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.tiles.AttributeDefinition;
import org.apache.struts.tiles.Controller;
import org.apache.struts.tiles.DefinitionNameAttribute;
import org.apache.struts.tiles.DirectStringAttribute;
import org.apache.struts.tiles.PathAttribute;
import org.apache.struts.tiles.UntypedAttribute;
import org.apache.struts.tiles.UrlController;
import org.apache.struts.tiles.xmlDefinition.XmlDefinition;
import org.apache.struts.util.RequestUtils;

public class ComponentDefinition
implements Serializable {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$struts$tiles$ComponentDefinition == null ? (class$org$apache$struts$tiles$ComponentDefinition = ComponentDefinition.class$("org.apache.struts.tiles.ComponentDefinition")) : class$org$apache$struts$tiles$ComponentDefinition));
    protected String name = null;
    protected String path = null;
    protected Map attributes = null;
    protected String role = null;
    protected String controller = null;
    protected String controllerType = null;
    public static final String URL = "url";
    public static final String CONTROLLER = "controller";
    public static final String ACTION = "action";
    private Controller controllerInstance = null;
    static /* synthetic */ Class class$org$apache$struts$tiles$ComponentDefinition;

    public ComponentDefinition() {
        this.attributes = new HashMap();
    }

    public ComponentDefinition(ComponentDefinition definition) {
        this.attributes = new HashMap(definition.getAttributes());
        this.name = definition.getName();
        this.path = definition.getPath();
        this.role = definition.getRole();
        this.controllerInstance = definition.getControllerInstance();
        this.controller = definition.getController();
        this.controllerType = definition.getControllerType();
    }

    public ComponentDefinition(XmlDefinition definition) {
        this((ComponentDefinition)definition);
    }

    public ComponentDefinition(String name, String path, Map attributes) {
        this.name = name;
        this.path = path;
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getPage() {
        return this.path;
    }

    public void setPage(String page) {
        this.path = page;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String aPath) {
        this.path = aPath;
    }

    public String getTemplate() {
        return this.path;
    }

    public void setTemplate(String template) {
        this.path = template;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void putAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public void put(String name, Object content) {
        this.put(name, content, false, null);
    }

    public void put(String name, Object content, boolean direct) {
        this.put(name, content, direct, null);
    }

    public void put(String name, Object content, boolean direct, String role) {
        if (direct) {
            this.put(name, content, "string", role);
        } else {
            this.put(name, content, "template", role);
        }
    }

    public void put(String name, Object content, String type, String role) {
        UntypedAttribute attribute = null;
        if (content != null && type != null && !(content instanceof AttributeDefinition)) {
            String strValue = content.toString();
            if (type.equalsIgnoreCase("string")) {
                attribute = new DirectStringAttribute(strValue);
            } else if (type.equalsIgnoreCase("page")) {
                attribute = new PathAttribute(strValue);
            } else if (type.equalsIgnoreCase("template")) {
                attribute = new PathAttribute(strValue);
            } else if (type.equalsIgnoreCase("instance")) {
                attribute = new DefinitionNameAttribute(strValue);
            } else if (type.equalsIgnoreCase("definition")) {
                attribute = new DefinitionNameAttribute(strValue);
            }
        }
        this.putAttribute(name, attribute);
    }

    public String toString() {
        return "{name=" + this.name + ", path=" + this.path + ", role=" + this.role + ", controller=" + this.controller + ", controllerType=" + this.controllerType + ", controllerInstance=" + this.controllerInstance + ", attributes=" + this.attributes + "}\n";
    }

    public String getControllerType() {
        return this.controllerType;
    }

    public void setControllerType(String controllerType) {
        this.controllerType = controllerType;
    }

    public void setControllerUrl(String controller) {
        this.setController(controller);
        this.setControllerType(URL);
    }

    public void setControllerClass(String controller) {
        this.setController(controller);
        this.setControllerType("classname");
    }

    public String getController() {
        return this.controller;
    }

    public void setController(String url) {
        this.controller = url;
    }

    public Controller getControllerInstance() {
        return this.controllerInstance;
    }

    public Controller getOrCreateController() throws InstantiationException {
        if (this.controllerInstance != null) {
            return this.controllerInstance;
        }
        if (this.controller == null && this.controllerType == null) {
            return null;
        }
        if (this.controllerType != null && this.controller == null) {
            throw new InstantiationException("Controller name should be defined if controllerType is set");
        }
        this.controllerInstance = ComponentDefinition.createController(this.controller, this.controllerType);
        return this.controllerInstance;
    }

    public void setControllerInstance(Controller controller) {
        this.controllerInstance = controller;
    }

    public static Controller createController(String name, String controllerType) throws InstantiationException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create controller name=" + name + ", type=" + controllerType));
        }
        Controller controller = null;
        if (controllerType == null) {
            try {
                return ComponentDefinition.createControllerFromClassname(name);
            }
            catch (InstantiationException ex) {
                controller = new UrlController(name);
            }
        } else if (URL.equalsIgnoreCase(controllerType)) {
            controller = new UrlController(name);
        } else if ("classname".equalsIgnoreCase(controllerType)) {
            controller = ComponentDefinition.createControllerFromClassname(name);
        }
        return controller;
    }

    public static Controller createControllerFromClassname(String classname) throws InstantiationException {
        try {
            Class requestedClass = RequestUtils.applicationClass(classname);
            Object instance = requestedClass.newInstance();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Controller created : " + instance));
            }
            return (Controller)instance;
        }
        catch (ClassNotFoundException ex) {
            throw new InstantiationException("Error - Class not found :" + ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new InstantiationException("Error - Illegal class access :" + ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw ex;
        }
        catch (ClassCastException ex) {
            throw new InstantiationException("Controller of class '" + classname + "' should implements 'Controller' or extends 'Action'");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

