/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"utils.h"
#include	"netutils.h"

int
_cmp(L_CHAR * a,L_CHAR *b)
{
	if ( a && b ) {
		if ( l_strcmp(a,b) )
			return -1;
	}
	else if ( a == 0 && b )
		return -1;
	else if ( a && b == 0 )
		return -1;
	return 0;
}

int
_cmp_server(L_CHAR * s1,L_CHAR * s2)
{
int my_ip;
	if ( s1 && s2 ) {
		return hostcmp(
			n_string(std_cm,s1),
			getHA_v4(0),
			n_string(std_cm,s2),
			getHA_v4(0));
	}
	my_ip = get_localhostip();
	if ( s1 ) {
		return hostcmp(
			n_string(std_cm,s1),
			getHA_v4(0),
			0,
			getHA_v4(my_ip));
	}
	else if ( s2 ) {
		return hostcmp(
			0,
			getHA_v4(my_ip),
			n_string(std_cm,s2),
			getHA_v4(0));
	}
	else	return 0;
}

int
url_cmp(URL * a,URL * b)
{
	if ( _cmp(a->proto,b->proto) )
		return -1;
	if ( _cmp_server(a->server,b->server) )
		return -1;
	if ( a->port != b->port )
		return -1;
	if ( _cmp(a->db,b->db) )
		return -1;
	if ( _cmp(a->resource,b->resource) )
		return -1;
	return 0;
}

