/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___RESOLVE_H___
#define ___RESOLVE_H___

typedef struct host_addr {
	short			type;
#define HAT_V4		4
#define HAT_V6		6
	short			size;
	union {
		unsigned int		v4;
		unsigned int		v6[4];
	} d;
} HOST_ADDR;

typedef struct host_entry {
	struct host_entry *	next;
	int			flags;
#define HEF_LOGHOST		0x00000001
#define HEF_NOW_RESOLV		0x00010000
	char *			canonical;
	char **			names;
	int			ips_length;
	HOST_ADDR *		ips;
	unsigned int		timer;
	unsigned int		access;
} HOST_ENTRY;


HOST_ENTRY * new_host_entry(int,int);

HOST_ENTRY * r_gethostbyaddr(HOST_ADDR a);
HOST_ENTRY * r_gethostbyname(char * name);
HOST_ADDR getHA_v4(unsigned int);
int cmp_HA(HOST_ADDR a,HOST_ADDR b);

/* entry for machine dependent */

HOST_ENTRY * intr_gethostbyaddr_rr(HOST_ADDR a);
HOST_ENTRY * intr_gethostbyname_rr(char * name);


#endif


