/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"gbacrp.h"

XL_SEXP * gb_MPPurge();


void
init_MPPurge(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"MPPurge"),
		get_func_prim(gb_MPPurge,FO_APPLICATIVE,0,2,2));
}



XL_SEXP *
gb_MPPurge(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * f;

set_cpu_msg(710000);
	f = get_el(s,1);
	if ( get_type(f) != XLT_STRING )
		goto type_missmatch;
	mpi_purge(f->string.data);

set_cpu_msg(0);
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"MPTpurge"),
		n_get_string("type missmatch"));
}

