/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"utils.h"

#ifdef WIN32
#include "windows.h"
#include "tlhelp32.h"
#endif

int
check_pid(int pid,char * pname)
{
#ifndef WIN32
	if ( getpgid(pid) < 0 )
		return -1;
#else
	HANDLE hSnapShot = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS,0);
	PROCESSENTRY32 pe;
	pe.dwSize = sizeof(pe);
	if(Process32First(hSnapShot, &pe)){
		do{
			if(pe.th32ProcessID == (DWORD)pid)
			{
				//if(!strcmp(pname, pe.szExeFile))
				if(strstr(pe.szExeFile,pname))
				{
					CloseHandle(hSnapShot);
					return 0;
				}
			}
		}while(Process32Next(hSnapShot, &pe));
	}
	CloseHandle(hSnapShot);
	return -1;
#endif
}

