/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"change_endian.h"
#include	"pdb.h"

void
change_endian_header(PN_HEADER * h)
{
	change_endian_s(h->type);
	change_endian_s(h->size);
}


void
change_endian_file_header(PN_FILE_HEADER * f)
{
	change_endian_header(&f->h);
	change_endian_i(f->type);
	change_endian_i(f->linear);
	change_endian_i(f->linear_length);
}

void
change_endian_2d_draw_header(PN_2D_DRAW_HEADER * d)
{
	change_endian_header(&d->h);
	change_endian_i(d->level);
	change_endian_d(d->resolution);
	change_endian_i(d->fofs);
	change_endian_gb_rect(&d->minrect);
}

void
change_endian_poly_point(PN_POLY_POINT * p)
{

	change_endian_header(&p->h);
	change_endian_s(p->no);
	change_endian_gb_point(&p->p);
}

void
change_endian_lno_poly_point(PN_POLY_POINT * p)
{
	change_endian_header(&p->h);
	change_endian_i(p->no);
	change_endian_gb_point(&p->p);
}


void
change_endian_tree_node_to_net(PN_TREE_NODE * tn)
{
int i;
	change_endian_header(&tn->h);
	change_endian_gb_rect(&tn->r);
	if ( tn->fofs_size < PTR_MAX/2 ) {
		for ( i = 0 ; i < tn->fofs_size ; i ++ ) {
			change_endian_i(tn->fo.lst[i].fofs);
			change_endian_i(tn->fo.lst[i].index);
		}
	}
	else {
		for ( i = 0 ; i < PTR_MAX ; i ++ ) {
			change_endian_i(tn->fo.fofs[i]);
		}
	}
	change_endian_s(tn->fofs_size);
}


void
change_endian_tree_node_to_host(PN_TREE_NODE * tn)
{
int i;
	change_endian_header(&tn->h);
	change_endian_gb_rect(&tn->r);
	change_endian_s(tn->fofs_size);
	if ( tn->fofs_size < PTR_MAX/2 ) {
		for ( i = 0 ; i < tn->fofs_size ; i ++ ) {
			change_endian_i(tn->fo.lst[i].fofs);
			change_endian_i(tn->fo.lst[i].index);
		}
	}
	else {

		for ( i = 0 ; i < PTR_MAX ; i ++ ) {
			change_endian_i(tn->fo.fofs[i]);
		}
	}
}


void
change_endian_poly_end(PN_POLY_END * e)
{
	change_endian_header(&e->h);
}

void
change_endian_polygon2d(PN_POLYGON2D * p)
{
	change_endian_header(&p->h);
	change_endian_gb_color(&p->padding_color);
	change_endian_gb_color(&p->line_color);
	change_endian_i(p->code);
	change_endian_s(p->type);
	change_endian_gb_rect(&p->minrect);
}


void
change_endian_lod_list_to_net(PN_LOD_LIST * s)
{
int i;
	change_endian_header(&s->h);
	for ( i = 0 ; i < s->max ; i ++ )
		change_endian_i(s->fofs[i]);
	change_endian_i(s->max);
}


void
change_endian_lod_list_to_host(PN_LOD_LIST * s)
{
int i;
	change_endian_header(&s->h);
	change_endian_i(s->max);
	for ( i = 0 ; i < s->max ; i ++ )
		change_endian_i(s->fofs[i]);
}


void
change_endian_code_index(CODE_INDEX * ci)
{
	change_endian_i(ci->fofs);
	change_endian_gb_rect(&ci->fofs);
}
