/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<winsock2.h>
#include	"memory_debug.h"
#include	"netutils.h"
#include	"utils.h"
#include	"task.h"

extern SEM netutils_lock;

int
hostcmp(char * h1,int ip1,char * h2,int ip2)
{
struct hostent * he1,* he2;
char * name1=0,* name2=0;
int ret;

	ip1 = htonl(ip1);
	ip2 = htonl(ip2);

	lock_task(netutils_lock);
	if ( h1 == 0 )
		he1 = gethostbyaddr((char*)&ip1,sizeof(int),AF_INET);
	else 	
		he1 = gethostbyname(h1);
	if ( he1 == 0 ){
		ret = -1;
		goto exit;
	}
	name1 = copy_str(he1->h_name);
	if ( h2 == 0 )
		he2 = gethostbyaddr((char*)&ip2,sizeof(int),AF_INET);
	else 	he2 = gethostbyname(h2);
	if ( he2 == 0 ){
		ret = -1;
		goto exit;
	}
	name2 = copy_str(he2->h_name);
	if ( strcmp(name1,name2) == 0 ) {
		ret = 0;
		goto exit;
	}
	ret = -1;
exit:
	if(name1)
		d_f_ree(name1);
	if(name2)
		d_f_ree(name2);
	unlock_task(netutils_lock, "hostcmp\n");
	return ret;
}
