//
// 
//	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
// 
//	This program is free software; you can redistribute it 
//	and/or modify it under the terms of the GLOBALBASE 
//	Library General Public License (G-LGPL) as published by 
//
//	http://www.globalbase.org/
// 
//	This program is distributed in the hope that it will be 
//	useful, but WITHOUT ANY WARRANTY; without even the 
//	implied warranty of MERCHANTABILITY or FITNESS FOR A 
//	PARTICULAR PURPOSE.
//
//

extern "C" {

#define STREAM_LIB

#include	"memory_debug.h"
#include	"server.h"
#include	"stream.h"
#include	"task.h"
#include	"CServerMaster.h"

extern SEM stream_lock;

void _s_open(STREAM * s,int mode);
void er_panic(char * str);

int s_close_accept(STREAM * s);

int s_error();
STREAM * s_error_stream();
STREAM * s_open_accept_desc;

S_TABLE s_accept_table = {
	'a',
	0,
	{0,0},
	0,
	s_error_stream,
	(int(*)())s_close_accept,
	s_error,
	s_error,
	s_error,
       	s_error,
	s_error_stream
};



STREAM *
init_server(int * open_port,int base_port,int limit)
{
STREAM *ret = (STREAM *)d_alloc(sizeof(STREAM),196);
	try {
		ret->accept.sm = new CServerMaster(open_port, base_port, limit);
	} catch (...) {
		printf("init server error : port %d\n", base_port);
		fflush(stdout);
		d_f_ree(ret);
		return 0;
	}
	ret->h.tbl = &s_accept_table;
	ret->h.thread = 0;
	lock_task(stream_lock);
	_s_open(ret,0);
	unlock_task(stream_lock,"init_server");	
	printf("init server : port %d\n", *open_port);
	return ret;
}

int
s_close_accept(STREAM * s)
{
	printf("close_accept : %d\n", (int)s);
	delete s->accept.sm;
	return 0;
}

} // extern "C"