/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___V_XL_TEXT_H___
#define ___V_XL_TEXT_H___


extern "C" {
#include	"gbgraph.h"
#include	"text_render.h"
#include	"stream.h"
}

#include	"v/VMacro.h"
#include	"v/VDraw.h"
#include	"v/VAlignView.h"

//
// TR Text Rendering 
//

typedef struct vtr_sequence {
	VObject *	(*new_box_vobj)
				(TR_SEQUENCE*,TR_BOX*);
	VObject *	base_obj;
} VTR_SEQUENCE;

typedef struct vtr_object {
	XLISP_ENV *	env;
	XL_SEXP *	sexp;
} VTR_OBJECT;

XL_SEXP * vtr_get_object_by_name(TR_SEQUENCE *,L_CHAR *);

//==============================================

#define VSF_XLTEXT_ALGORISM	(1<<0)
#define VSF_XLTEXT_EDITABLE	(1<<1)
#define VSF_XLTEXT_BATTR	(1<<2)
#define VSF_XLTEXT_CURRET	(1<<3)

typedef struct _VxlTextStatus {
	unsigned		algorism:2;
#define VXLT_A_DRAW	1
#define VXLT_A_TEXT	2
	unsigned		editable:1;
	TR_BOX_ATTR		battr;
	int			curret;
} VxlTextStatus;

class VxlText : public VMacro
{
  public:
	enum { object_type = VO_XTXT };

	virtual unsigned	get_type() const { return object_type; }

	static VxlText* create(const VObjectStatus *s, int flags, VExError *err=0) {
		return create(s, flags, 0, err);
	}
	static VxlText* create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VxlText*>(
			create_tmp(internal_new, object_type, s, flags, err,arg));
	}

	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	redraw(VRect* rect = 0) const;

	virtual VExError get_xltext_status(
				VxlTextStatus *,
				int flags) const;
	virtual VExError set_xltext_status(
				const VxlTextStatus *,
				int flags);

	virtual VError	set_xl_sexp(XLISP_ENV * e,XL_SEXP * s);
	virtual VError 	set_xl_sexp_loop(XLISP_ENV * e,XL_SEXP * s,int ps_flags);
	virtual XL_SEXP * get_object_by_name(L_CHAR * name);

	virtual void	waitsync(WAITSYNC_CLIENT * ,int);

	STREAM *	st;

	virtual int	_s_write(STREAM *,void *,int);
	virtual int	_s_read(STREAM *,void *,int);

	void	_text_cb();

  protected:

  	virtual ~VxlText();

	virtual VExError	create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg);
	virtual void	destroy_do(VObject *);
	virtual void	destroy_do_out_of_lock(VObject*);

	TR_SEQUENCE * 			tx_sq;
	TR_PTR				tx_curret;
	LC_WRITING_STYLE *		tx_ws;
	int				tx_size;
	TR_ATTR *			tx_attr;
	VxlTextStatus			tx_sts;

	union {
		VObject *			obj;
		VDraw *				draw;
		VHAlignView *			halign;
	}				tx_object;

  private:
	static VObject *internal_new(){
	VxlText * ret;
		ret = new VxlText();
		return ret;
	}
	VExError	create_do_VDraw();
	VExError	create_do_VText();

	XL_SEXP *	waitsync_sexp;
	VObjectStatus b_sts;
};


void free_VxlTextStatus(VxlTextStatus*);
char * VxlText_get_xltext_from_sf(
	VxlTextStatus * xsts,int * flags,
	XLISP_ENV * env,
	XL_SYM_FIELD * sf);


#endif

