/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___V_GB_GPS_BROWSER_H___
#define ___V_GB_GPS_BROWSER_H___


#include	"v/VMacro.h"
#include	"v/VButton.h"
#include	"v/VStaticText.h"

extern "C" {
#include	"serial_port.h"
#include	"locator.h"
}

class VgbGPSBrowser : public VMacro
{
  public:
	enum { object_type = VO_GPSB };

	virtual unsigned	get_type() const { return object_type; }

	static VgbGPSBrowser*
	create(const VObjectStatus *s, int flags, VExError* err=0) {
		return create(s, flags, 0, err);
	}
	static VgbGPSBrowser*
	create(const VObjectStatus *s, int flags, void * arg, VExError* err) {
		return static_cast<VgbGPSBrowser*>(
			create_tmp(internal_new, object_type, s, flags, err,arg));
	}

	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);

  protected:

  	virtual ~VgbGPSBrowser();

	virtual VExError	create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);
	
	static			V_CALLBACK_D(gps_selected);
	virtual void	gps_selected_do();
	static void		receive_gps_result(LOCATOR_INFO *li, const LOCATION_INFO *info);
	void			receive_gps_result_do(LOCATOR_INFO *li, const LOCATION_INFO *info);

	LOCATOR_INFO	*gps_info;
	VPopupButton	*gps_selector;
	VStaticText		*gps_output[4];

  private:
	static VObject *internal_new(){
	VgbGPSBrowser * ret;
		ret = new VgbGPSBrowser();
		return ret;
	}
};


#endif
