/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___RADAR_H___
#define ___RADAR_H___

#include	"gbgraph.h"
#include	"gbview.h"
#include	"queue.h"
#include	"lump.h"
#include	"routing.h"


#define GB_NAMESPACE	"xlp://isjhp1.nichibun.ac.jp:8080/gb_metadata"
#define RADAR_CACHE_SIZE		500
#define RADAR_MATRIX_CACHE_SIZE		100
#define RADAR_RECT_RATE			10
#define RADAR_DOTS			500
#define RADAR_DOTS_RATE			2
#define CLEAR_INTERVAL			50
#define WIN_SURF_RATE_MIN		10
#define WIN_SURF_RATE_MAX		11
#define RADAR_RESO_PTR_SIZE		8

#define WIN_RESO_WINDOW_MIN		2
#define WIN_RESO_WINDOW_MAX		800000

#define GLOBE_RESO_LIMIT		800

#define BEAM_TASKS			10

#define LOADING_INTERVAL		5
#define RADAR_ZONBIE_TIME		10

#define INIT_RECOMMEND_INTERVAL		10
#define RADAR_RI_RATE			0.1

#define DISTORTION_LIMIT		3

/* sethomestatus
#define OPENING_TIMEOUT			5

#define OS_GENESIS	0
#define OS_STANBY	1
#define OS_SETHOME	2
#define OS_SETHOME_COMPLETE	3
#define OS_RUN		4
#define OS_MAX		5
*/

/* rc_warp types */

#define WT_RECT		1
#define WT_CENTER	2
#define WT_TARGET	3
#define WT_WARP_POINT	4


typedef struct lump_crd_node {
	struct lump_crd_node *	lump_next;
	struct lump_crd_node *	crd_next;
	struct radar_lump *	lump;
	struct radar_crd *	crd;
} LUMP_CRD_NODE;

typedef struct radar_lump {
	struct radar_lump *	next;
	L_CHAR *		lumpcrd_path;
	L_CHAR *		db_path;
	GB_RECT			sphere;
	L_CHAR *		unit;
	L_CHAR *		reso_unit;
	REAL1			reso_min;
	REAL1			reso_max;
	LUMP_CRD_NODE *		crd;
//	INTEGER64		last_access_time;
	float			recommend_interval;
	int			q_len;
	INTEGER64		invalid;
	int			invalid_cnt;
} RADAR_LUMP;

typedef struct radar_node {
	struct radar_node *	crd_next;
	struct radar_node *	matrix_next;
	struct radar_crd *	crd;
	struct radar_matrix *	matrix;
} RADAR_NODE;

typedef struct radar_crd_lock {
	struct radar_crd_lock *	next;
	int			lock_id;
} RADAR_CRD_LOCK;

typedef struct radar_crd {
	int			bufid;
	int			lock;
//	RADAR_CRD_LOCK *	_lock;
	struct radar_crd *	next;
	struct radar_crd *	prev;
	int			flags;
#define RCF_INMATRIX		0x00000001
#define RCF_LARGE_CRD		0x00000002
	REAL1			resolution;
	REAL1			globe_resolution_limit;
	GB_RECT			minrect;
	L_CHAR *		crd_path;
	L_CHAR *		obj_path;
	RESOURCE *		crd_r;
	RESOURCE *		obj_r;
	BIB_LIST *		crd_bib;
	BIB_LIST *		obj_bib;
	RADAR_NODE *		list;
	L_CHAR *		base_url;
	LUMP_CRD_NODE *		lump;
	int			lump_handling;
	int *			q_thread_id;
	
	unsigned		invalid:1;
	REAL1			distortion;
} RADAR_CRD;

typedef struct radar_matrix {
	struct radar_matrix *	next;
	struct radar_matrix *	prev;
	REAL1			resolution;
	/* resolution - 2*resolution */
	REAL1			loaded_reso;
	GB_RECT			rect[2][2];
	struct radar_matrix *	mx[2][2];
	RADAR_NODE *		list;
	struct radar_matrix *	parent;
	struct q_thread_list *	root_qt;
} RADAR_MATRIX;


typedef struct t_load_to_beam {
	Q_HEADER		h;
	XL_SEXP *		query;
	GB_RECT			r;
	int			qt_id;
	REAL1			min;
	REAL1			max;
	L_CHAR *		base_url;
	RADAR_LUMP *		rl;
	INTEGER64		start_time;
	int			que_len;
} T_LOAD_TO_BEAM;

typedef struct t_beam_to_resource {
	Q_HEADER		h;
	XL_SEXP *		urls;
	int			qt_id;
} T_BEAM_TO_RESOURCE;

typedef struct t_resource_to_insert {
	Q_HEADER		h;
	LOAD_RESOURCE_WORK *	lr_crd;
	LOAD_RESOURCE_WORK *	lr_obj;
	int			mappath_loading;
	L_CHAR *		crd_path;
	L_CHAR *		obj_path;
	int			qt_id;
} T_RESOURCE_TO_INSERT;

typedef union radar_indicate {
	int			ary[1];
	struct {
		int		beam;
		int		loading_res[CRT_MAX+1];
		int		ready_res[CRT_MAX+1];
		int		load_to_beam;
		int		beam_to_resource;
		int		retrieve1;
		int		retrieve2;
	} d;
} RADAR_INDICATE;

#define R_IND_ARY_RES		((CRT_MAX+1)*2+1)
#define R_IND_ARY_LEN		(int)(sizeof(RADAR_INDICATE)/sizeof(int))


typedef struct query_thread {
	struct query_thread *	next;
	int			id;
	L_CHAR *		title;
	int			flags;
#define QTF_ACTIVE		0x00000001
#define QTF_TEMP		0x00000002
	int			mask;

	L_CHAR *		url;
	L_CHAR *		property;
	GB_TIME			content_period_from;
	GB_TIME			content_period_to;
	struct query_thread *	children;
	struct query_thread *	parent;
} QUERY_THREAD;

/* conversion mode */
#define QTH_MINIMUM_INFO	0
#define QTH_NOID_INFO		1
#define QTH_MAXIMUM_INFO	2

typedef struct q_thread_list {
	struct q_thread_list *	next;
	QUERY_THREAD *		qth;
	RADAR_MATRIX *		matrix;
	GB_RECT			large_crd;
	struct q_thread_list *	children;
	struct q_thread_list *	parent;
} Q_THREAD_LIST;



typedef struct warp_point_layer {
	struct warp_point_layer *	next;
	L_CHAR *			entry;
	int				flags;
} WARP_POINT_LAYER;

typedef struct warp_point {
	int			type;
#define WPT_SIMPLE		0x00000001
#define WPT_CRD			0x00000002
#define WPT_ONLY_ACTIVE		0x00000004
#define WPT_TARGET		0x00000008
	L_CHAR *		title;
	INTEGER64		tracking_time;
	QUERY_THREAD *		qth;
	REAL1			resolution;
	REAL1			rotate;
	GB_POINT		center;
	L_CHAR *		base;
	L_CHAR *		lock_base;
	WARP_POINT_LAYER *	layers;
} WARP_POINT;

typedef struct radar_history {
	struct radar_history *	next;
	struct radar_history *	prev;
	struct radar_history *	acc_prev;
/*
	QUERY_THREAD *		qth;
	REAL1			resolution;
	REAL1			rotate;
	GB_POINT		center;
	L_CHAR *		base;
	L_CHAR *		lock_base;
*/
	WARP_POINT *		wp;
} RADAR_HISTORY;

typedef struct radar_cache {
	int			status;
	GBVIEW_FLAME *		gf;

	RADAR_MATRIX		mtx_h;
	RADAR_CRD *		free_list;
	RADAR_CRD *		crd;
	GB_POINT *		ptr;
	REAL1 *			res;
	unsigned int		zonbie_time;
	unsigned int		last_loading_time;
	float			loading_interval;
	float			loading_interval_past;
	float			loading_interval_diff;
	INTEGER64		loading_interval_sample_time;
	int			matrix_count;
	L_CHAR *		base_url;
	int			base_url_lock;
	int			base_url_lock_task;
	GB_RECT			win_rect;
	REAL1			win_reso_window;
	REAL1			win_reso_max;

	char			win_delete_lock;
	char			retrieve_flag;
	int			lock;

	int			task_mode;
#define TM_MIN		0
#define TM_WMAN		1
#define TM_LOAD		2
#define TM_TRIG		3
#define TM_REMK		4
#define TM_INS		5

#define TMM_MIN		(1<<TM_MIN)
#define TMM_WMAN	(1<<TM_WMAN)
#define TMM_LOAD	(1<<TM_LOAD)
#define TMM_TRIG	(1<<TM_TRIG)
#define TMM_REMK	(1<<TM_REMK)
#define TMM_INS		(1<<TM_INS)

	int			dim;

	RADAR_HISTORY *		history;
	RADAR_HISTORY *		history_ptr;
	Q_THREAD_LIST *		q_thread_tmp;
	Q_THREAD_LIST *		q_thread_lst;
//	XL_SEXP *		query;
	char			query_mode;
	char			load_mode;
	int			remake_req;

	SYS_QUEUE		load_to_beam;
	SYS_QUEUE		beam_to_resource;
	SYS_QUEUE		resource_to_insert;

	REAL1			first_max;
	GB_RECT			first_r;

	int			lock_win_manage;
	char			win_manage_task_wp;
	char			loading_task_wp;
	char			min_route_task_wp;
	char			retrieve_task_wp;

	char			loading_task_active;
	char			win_manage_task_active;
	char			min_route_task_active;
	char			retrieve_task1_active;
	char			retrieve_task2_active;

	unsigned		win_manage_task_req:1;
	unsigned		loading_task_req:1;
	unsigned		min_route_task_req:1;

	unsigned 		win_load:1;
	unsigned 		delete_insert_flag:1;
	unsigned		base_change_flag:1;

	unsigned		win_remake:1;
	unsigned		win_force:1;
	int			change_condition_delete;


	void 			(*indicate_event)(RADAR_INDICATE *,void*);
	void *			indicate_event_work;
	RADAR_INDICATE		ri;

	void 			(*condition_event)(QUERY_THREAD *,void*);
	void *			condition_event_work;
	
	void			(*history_event)(struct radar_cache *,int direction,void*);
#define HED_FORWARD	1
#define HED_REVERSE	2
	void *			history_event_work;
	int			history_direction;

	void			(*status_event)(struct radar_cache * rc_ptr,void*);
	void *			status_event_work;

	float			recommend_interval;
	INTEGER64		last_access_loading;
	
	
	XLISP_ENV *		session_env;
	STREAM *		session_stream;

	int			mouse_mode;
#define RD_MOUSE_IDLE		0
#define RD_MOUSE_CLICK		0x02
#define RD_MOUSE_DOUBLE		0x04
#define RD_MOUSE_DOUBLE_FLOAT	0x08
#define RD_MOUSE_DRAG		0x10
#define RD_MOUSE_ZOOM_IN	0x20
#define RD_MOUSE_ZOOM_OUT	0x40
#define RD_MOUSE_ROTATE		0x80
	I_POINT			mouse_point;
	INTEGER64		mouse_time;

	struct radar_cache *	next;
} RADAR_CACHE;

typedef struct radar_matrix_list {
	struct radar_matrix_list *	next;
	RADAR_MATRIX *			mx;
} RADAR_MATRIX_LIST;

typedef struct crd_list {
	RADAR_CACHE *		rc_ptr;
	WF_ID			wfid;
	RADAR_CRD *		crd;
	unsigned		sts:4;
#define CLS_NONE		0
#define CLS_KEEP		1
#define CLS_REMOVE		2
#define CLS_INSERT		3
	unsigned 		base_lock:2;
} CRD_LIST;

typedef struct beam_query {
	RADAR_LUMP *		target_rl;
	L_CHAR *		base_url;
	int			aboat;
	GB_RECT			rect;
	REAL1			min;
	REAL1			max;
	XL_SEXP *		query;

	XL_SEXP *		result;
} BEAM_QUERY;

typedef struct t_retrieve {
	Q_HEADER		h;
	L_CHAR *		crd;
	L_CHAR *		obj;
	LUMP_ROUTE *		lr;
	RADAR_CACHE *		rc_ptr;
} T_RETRIEVE;


XL_SEXP *
virtual_lump(
	GB_RECT * rect,
	REAL1	reso_min,
	REAL1	reso_max,
	XL_SEXP * query);
XL_SEXP * radar_query_regulation(XL_SEXP *);

typedef struct heuristics_param {
	int		ses;
	REAL1		base_resolution;
} HEURISTICS_PARAM;

#define CRT_LOADING_RES_RESOLVE	(CRT_MAX)


typedef struct rc_loading_status {
	RADAR_INDICATE		ri;
	int			status;
	unsigned		search_loading:1;
	unsigned		layer_management:1;
	unsigned		change_base_coord:1;
} RC_LOADING_STATUS;


typedef struct loading_status {
	RC_LOADING_STATUS		rc;
	WF_LOADING_STATUS		wf;
} LOADING_STATUS;


QUERY_THREAD * rc_get_q_thread(RADAR_CACHE * rc_ptr);
int rc_set_q_thread(RADAR_CACHE * rc_ptr,QUERY_THREAD *);
int rc_replace_q_thread(RADAR_CACHE * rc_ptr,QUERY_THREAD *);
int rc_zoom(int ses,
	RADAR_CACHE * rc_ptr,
	RESOURCE * c,
	GB_RECT _r,
	REAL1 _rot);
int rc_delete_q_thread(RADAR_CACHE * rc_ptr,int _no);
int rc_insert_q_thread(RADAR_CACHE * rc_ptr,QUERY_THREAD *);

void
rc_set_indicate_event(
	RADAR_CACHE * rc,
	void (*func)(RADAR_INDICATE*,void*),
	void*work);
void
rc_set_condition_event(
	RADAR_CACHE * rc,
	void (*func)(QUERY_THREAD*,void*),
	void*work);

QUERY_THREAD *sexp_to_q_thread(XL_SEXP *);
void _xx_free_query_thread_1(RADAR_CACHE * rc_ptr,QUERY_THREAD * qt,char*,int);
void xx_free_query_thread(QUERY_THREAD*,char*,int);
#define _free_query_thread_1(rc_ptr,qt)	_xx_free_query_thread_1(rc_ptr,qt,__FILE__,__LINE__)
#define free_query_thread(qt)	xx_free_query_thread(qt,__FILE__,__LINE__)

/* NEW */
	
void gc_radar();

int _check_matrix_size(RADAR_MATRIX * mx);
int check_matrix_size(RADAR_CACHE * rc_ptr);
void init_radar();
void attach_radar(GBVIEW_FLAME * gf);
RADAR_CACHE * new_radar(GBVIEW_FLAME * gf);
RADAR_CACHE ** _radar_zonbie_tick(RADAR_CACHE ** rp);
void radar_zonbie_tick();
void detach_radar(RADAR_CACHE * rc_ptr);
void radar_status(RADAR_CACHE * r,int status);
void insert_beam_to_resource(RADAR_CACHE * rc_ptr,XL_SEXP * urls,int);
void free_load_to_beam(T_LOAD_TO_BEAM * n);
void free_resource_to_insert(T_RESOURCE_TO_INSERT * n);
void gc_radar_cache(RADAR_CACHE * rc_ptr);
void _wlock_base_url(RADAR_CACHE * rc_ptr,char * msg);
void _rlock_base_url(RADAR_CACHE * rc_ptr,char * msg);
void _unlock_base_url(RADAR_CACHE * rc_ptr);
void wlock_base_url(RADAR_CACHE * rc_ptr,char * msg);
void rlock_base_url(RADAR_CACHE * rc_ptr,char * msg);
void unlock_base_url(RADAR_CACHE * rc_ptr);
void _set_q_mode(RADAR_CACHE * rc_ptr);
void set_q_mode(RADAR_CACHE * rc_ptr);
void reset_q_mode(RADAR_CACHE * rc_ptr);
void set_l_mode(RADAR_CACHE * rc_ptr);
void reset_l_mode(RADAR_CACHE * rc_ptr);
void _set_opening_state(int state);
void set_opening_state(int state);
void _insert_radar_crd_ring(RADAR_CACHE * rc_ptr,RADAR_CRD * c);
int _rc_task_lock_check(RADAR_CACHE * rc_ptr,int t);
int rc_task_lock_check(RADAR_CACHE * rc_ptr,int t);
void _rc_task_lock(RADAR_CACHE * rc_ptr,int t);
void rc_task_lock(RADAR_CACHE * rc_ptr,int t);
void _rc_task_unlock(RADAR_CACHE * rc_ptr,int t);
void rc_task_unlock(RADAR_CACHE * rc_ptr,int t);
void _delete_radar_crd_ring(RADAR_CRD * c);
void _insert_radar_mtx_ring(RADAR_CACHE * rc_ptr,RADAR_MATRIX * mx);
void _delete_radar_mtx_ring(RADAR_MATRIX * mx);
RADAR_LUMP * _search_radar_lump(L_CHAR * lumpcrd_path);
void _insert_radar_lump(RADAR_CACHE * rc_ptr,RADAR_CRD * c,RADAR_LUMP * rl);
void _delete_lump_crd_node_from_lump(RADAR_LUMP * l);
void _free_radar_lump(RADAR_LUMP * l);
RADAR_LUMP * _copy_radar_lump_1(RADAR_LUMP * l);
RADAR_LUMP * _copy_radar_lump(RADAR_LUMP * l);
void _delete_lump_crd_node_from_crd(RADAR_CRD * c);
RADAR_LUMP * _new_radar_lump(L_CHAR * crd,L_CHAR * db);
int _insert_radar_lump_list(RADAR_LUMP * l);
L_CHAR * _get_minrect_unit(XL_SEXP * d);
L_CHAR * get_minrect_unit(XL_SEXP * d);
RADAR_LUMP * setup_radar_lump(int ses,L_CHAR * crd,L_CHAR * db);
RADAR_CRD * _search_crd_path(RADAR_CACHE * rc_ptr,L_CHAR * path);
void free_t_retrieve(T_RETRIEVE * r);
void _retrieve_lump(RADAR_CACHE * rc_ptr);
void retrieve_lump(RADAR_CACHE * rc_ptr);
void _wakeup_retrieve_lump_task(RADAR_CACHE* rc_ptr);
void wakeup_retrieve_lump_task(RADAR_CACHE* rc_ptr);
void _delete_turning_loaded_reso(RADAR_MATRIX * mx,REAL1 lr);
void _delete_node_from_crd(RADAR_CRD * c);
void dump_radar_crd_list(RADAR_CACHE * rc_ptr);
RADAR_CRD * new_radar_crd(RADAR_CACHE* rc_ptr);
void flush_radar_crd(RADAR_CRD * c);
void _wait_radar_crd(RADAR_CRD * c);
RADAR_CRD *
search_radar_crd(RADAR_CACHE * rc_ptr,L_CHAR * crd,L_CHAR * obj,int wait_flag);
RADAR_MATRIX * _new_radar_matrix(RADAR_CACHE * rc_ptr,Q_THREAD_LIST * qt);
void _check_mx_rect(int x,int y,RADAR_MATRIX *mx);
void _init_radar_matrix(RADAR_CACHE * rc_ptr,Q_THREAD_LIST * qt,GB_RECT * r);
void set_mx_rect(RADAR_MATRIX * mx,GB_POINT tl,GB_POINT c,GB_POINT br);
void check_mx_rect(RADAR_MATRIX * mx);
RADAR_MATRIX_LIST * _new_radar_matrix_list(RADAR_MATRIX * mx);
void _free_radar_matrix_list(RADAR_MATRIX_LIST * lst);
RADAR_MATRIX_LIST * append_rml(RADAR_MATRIX_LIST * lst1,RADAR_MATRIX_LIST * lst2);
RADAR_MATRIX_LIST *
__get_radar_matrix(RADAR_CACHE * rc_ptr,
	Q_THREAD_LIST * qtl,
	REAL1 reso,GB_RECT * r,RADAR_MATRIX * mx,
	int insert_flag);
void stepup_radar_matrix(RADAR_CACHE * rc_ptr,Q_THREAD_LIST * qt,int xx,int yy);
void including_matrix(RADAR_CACHE * rc_ptr,Q_THREAD_LIST * qt,GB_RECT * r);
RADAR_MATRIX_LIST *
_get_radar_matrix(RADAR_CACHE * rc_ptr,Q_THREAD_LIST * qt,REAL1 reso,GB_RECT * r,int insert_flag);
void _insert_radar_matrix(RADAR_CACHE * rc_ptr,RADAR_MATRIX * mx,RADAR_CRD * c);
void insert_radar_matrix(RADAR_CACHE * rc_ptr,int qt_id,RADAR_CRD * c,int lock_flag);
void get_fitting_line(
		int * fitting_p,
		REAL1 * tl,REAL1 * br,
		REAL1 target_tl,
		REAL1 target_br,
		REAL1 reso,
		REAL1 window_tl,
		REAL1 window_br,
		REAL1 rate);
GB_RECT
get_fitting_rect(int * fitting_p,GB_RECT * target,REAL1 reso,RADAR_CACHE * rc_ptr,
			Q_THREAD_LIST * qt);
void insert_radar_matrix(RADAR_CACHE * rc_ptr,int qt_id,RADAR_CRD * c,int lock_flag);
void _xx_free_node_from_matrix(RADAR_MATRIX * mx,char*,int);
void _xx_free_node_from_matrix2(RADAR_MATRIX * mx,char*,int);
void free_radar_matrix(RADAR_CACHE * rc_ptr,Q_THREAD_LIST * qt);
void _clean_top_of_matrix(RADAR_CACHE * rc_ptr,Q_THREAD_LIST * qt);
int __xx_clean_radar_matrix(RADAR_CACHE * rc_ptr,Q_THREAD_LIST * qt,RADAR_MATRIX * mx,char*,int);
void _xx_clean_force_matrix(RADAR_CACHE * rc_ptr,int clear_count,char*,int);
void xx_clean_radar_matrix(RADAR_CACHE * rc_ptr,Q_THREAD_LIST * qt,char*,int);
int set_ptr_list(RADAR_CACHE * rc_ptr,int ses,RADAR_CRD * c);
int _insert_radar_url(RADAR_CACHE * rc_ptr,int qt_id,int ses,L_CHAR * crd,L_CHAR * obj,int wup_flag);
int remake_cache(RADAR_CACHE * rc_ptr,int ses,int type,WF_ID current,WF_ID next);
int cmp_wf_crd(CRD_LIST * c1,CRD_LIST * c2);
AVT_NODE * get_wf_tree(RADAR_CACHE * rc_ptr);
int cmp_reso_sort(CRD_LIST * c1,CRD_LIST * c2);
int reso_sort(AVT_NODE * a,AVT_NODE ** tree);
RADAR_MATRIX_LIST *  get_parent(RADAR_MATRIX_LIST * lst);
void _free_wf_tree(AVT_NODE * tree);
RADAR_MATRIX * _new_radar_matrix2(RADAR_CACHE * rc_ptr,Q_THREAD_LIST * qt,REAL1 reso,GB_RECT * r);
int free_crd_lock(AVT_NODE * a);
int h_limit_reso_func(AVT_NODE * a,HEURISTICS_PARAM * w);
void h_search_limit_resolution(AVT_NODE * wf_tree,
	HEURISTICS_PARAM * p);

void heuristics_search(AVT_NODE * wf_tree,HEURISTICS_PARAM * p);
void _dump_the_matrix(RADAR_MATRIX * mx,int level,GB_RECT * r);
void dump_the_matrix_qt(RADAR_CACHE * rc_ptr,Q_THREAD_LIST * qt,GB_RECT * r,int ind);
void dump_the_matrix(RADAR_CACHE * rc_ptr,GB_RECT * r);
WF_ID win_manage(RADAR_CACHE * rc_ptr,WF_ID * next,int ses,REAL1 reso,GB_RECT * r);
int in_condition(RADAR_CACHE * rc_ptr,GB_RECT * r,REAL1 window,REAL1 max);
void _xx_empty_radar_matrix(RADAR_MATRIX * mx,int fn_flag,char*,int);
void query_trigger(RADAR_CACHE * rc_ptr,int fn_flag);
void _query_trigger2(RADAR_CACHE * rc_ptr);
void query_trigger2(RADAR_CACHE * rc_ptr);
int __include_query_check(XL_SEXP * rc_q,XL_SEXP * q);
int _include_query_check(XL_SEXP * rc_q,XL_SEXP * q);
XL_SEXP * include_query_check(XL_SEXP * rc_query,XL_SEXP * query);
RADAR_CACHE * get_sf_rc_ptr(XLISP_ENV * env,XL_SYM_FIELD * sf);
int beam_convert(int ses,L_CHAR * burl,RADAR_LUMP * rl,
		GB_RECT * r,REAL1 * min,REAL1 * max,
		L_CHAR ** unit_p,L_CHAR ** r_unit_p);
void test_lock(int f);
RADAR_LUMP * merge_radar_lump(RADAR_LUMP * rl,RADAR_LUMP * rl2);
void beam_to_remote(RADAR_CACHE * rc_ptr,
	int ses,GB_RECT * r,REAL1 min,REAL1 max,XL_SEXP * q,int qt_id,int insert_que_flag);
int insert_check(SYS_QUEUE * q,T_RESOURCE_TO_INSERT * n,L_CHAR * obj_url);
void beam_load(RADAR_CACHE * rc_ptr,XL_SEXP * lst,int qt_id);
XL_SEXP * beam_to_lump(RADAR_CACHE * rc_ptr,int ses,GB_RECT * r,REAL1 min,REAL1 max,int id);
void get_center_reso(GBVIEW_FLAME * gf,GB_POINT * p,REAL1 * reso,GB_RECT * r);
int goto_zoom(RADAR_CACHE * rc_ptr,int ses,GBVIEW_FLAME * gf,L_CHAR * target);
void adjust_rect_by_reso(
	RADAR_CACHE * rc_ptr,
	GB_RECT * r,
	REAL1 v_reso_min,
	REAL1 v_reso_max);
int loading_first(RADAR_CACHE * rc_ptr,int qt_id,GB_RECT * last_r,REAL1 * last_max,int ses);
int _loading_lump(
	RADAR_CACHE * rc_ptr,
	int qt_id,
	int ses,
	GB_RECT * r,
	REAL1 min,
	REAL1 max);
void _turning_loaded_reso(RADAR_MATRIX * mx,REAL1 lr);
void turning_loaded_reso(RADAR_MATRIX * mx);
int _loading_cube(RADAR_CACHE * rc_ptr,int qt_id,int ses,RADAR_MATRIX * mx,REAL1 min,REAL1 max);
int loading_matrix(
	RADAR_CACHE * rc_ptr,
	int qt_id,
	GB_RECT * last_r,
	REAL1 * last_window,REAL1 * last_max,int ses);
int min_route_radar_pre_handle(RADAR_CACHE * rc_ptr);
int min_route_radar(RADAR_CACHE * rc_ptr,int ses);
void _fitting_check(RADAR_CACHE * rc_ptr,Q_THREAD_LIST * qt,GB_RECT * r);

XL_SEXP * get_url_pair_URL(XL_SEXP * result,XL_SEXP * q);
XL_SEXP * get_url_pair_list(XL_SEXP * result,XL_SEXP * q);
XL_SEXP * get_url_pair_pair(XL_SEXP * result,XL_SEXP * q);
int check_filter_query_AND(
	L_CHAR * crd,
	L_CHAR * obj,
	XL_SEXP * q);
int check_filter_query_OR(
	L_CHAR * crd,
	L_CHAR * obj,
	XL_SEXP * q);
int check_filter_query_NOT(
	L_CHAR * crd,
	L_CHAR * obj,
	XL_SEXP * q);
int check_filter_query_URL(
	L_CHAR * crd,
	L_CHAR * obj,
	XL_SEXP * q);
int check_filter_query_qualifier(L_CHAR * crd,L_CHAR * obj,XL_SEXP * q);
int check_filter_query_pair(
	L_CHAR * crd,
	L_CHAR * obj,
	XL_SEXP * q);
void _call_indicate_event(RADAR_CACHE * rc,int change);
void call_indicate_event(RADAR_CACHE * rc,int change);
void _rc_set_indicate_event(
	RADAR_CACHE * rc,
	void (*func)(RADAR_INDICATE*,void*),
	void*work);
void _call_condition_event(RADAR_CACHE * rc,QUERY_THREAD *);
void _rc_set_condition_event(
	RADAR_CACHE * rc,
	void (*func)(QUERY_THREAD*,void*),
	void*work);
int copy_ri(RADAR_INDICATE * ri1,RADAR_INDICATE * ri2);

int  q_thread_id_len(int * id_list);
int * insert_q_thread_id(int * id_list,int id);
Q_THREAD_LIST ** 
insert_q_thread_list_ptr(Q_THREAD_LIST ** qtl,Q_THREAD_LIST * qt);
int _get_new_id(RADAR_CACHE * rc_ptr);
void _copy_q_thread(
	QUERY_THREAD * q1,
	QUERY_THREAD * q2,
	int flag);
QUERY_THREAD * copy_q_thread(QUERY_THREAD * q);
void
duplicate_q_thread(
	QUERY_THREAD * q1,
	QUERY_THREAD * q2);
QUERY_THREAD * _new_q_thread(RADAR_CACHE * rc_ptr,
	QUERY_THREAD * data);
int _delete_q_thread(RADAR_CACHE * rc_ptr,int id);
int _cmp_q_thread_string(L_CHAR * a,L_CHAR * b);
int _cmp_q_thread_gb_time(GB_TIME * a1,GB_TIME * a2);
Q_THREAD_LIST * _search_q_thread_by_content(RADAR_CACHE * rc_ptr,QUERY_THREAD * q);
Q_THREAD_LIST * _search_q_thread(RADAR_CACHE * rc_ptr,int id);
Q_THREAD_LIST * search_q_thread(RADAR_CACHE *rc_ptr,int id);
int * _get_valid_qt_id_list(RADAR_CACHE * rc_ptr);
int * get_valid_qt_id_list(RADAR_CACHE * rc_ptr);
XL_SEXP * q_thread_to_sexp(QUERY_THREAD * qt,int mode);
XL_SEXP * q_thread_to_sexp_1(QUERY_THREAD * qt,int mode);


RADAR_MATRIX_LIST *
_get_radar_matrix_all(RADAR_CACHE * rc_ptr,REAL1 reso,GB_RECT * r,int insert_flag);
void _xx_free_radar_matrix_all(RADAR_CACHE * rc_ptr,char*,int);
void xx_free_radar_matrix_all(RADAR_CACHE * rc_ptr,char*,int);
int _cmp_q_thread(QUERY_THREAD * q1,QUERY_THREAD * q2,int flag);
REAL1 _get_qt_min_reso(RADAR_CACHE * rc_ptr);
void _xx_empty_radar_matrix_in_query(RADAR_CACHE * rc_ptr,int fn_flag,char*,int);
int _rc_insert_q_thread(
	RADAR_CACHE * rc_ptr,
	QUERY_THREAD * q_list);
int sexp_to_q_thread_1(QUERY_THREAD * q,XL_SEXP * s);
QUERY_THREAD * _get_q_thread(
	RADAR_CACHE * rc_ptr);
void _fitting_check_all(RADAR_CACHE * rc_ptr,GB_RECT * r);
void _free_query_thread_list(RADAR_CACHE * rc_ptr,Q_THREAD_LIST * qt,int);
void free_query_thread_list(Q_THREAD_LIST * qt,int);
L_CHAR * get_q_thread_subtitle(QUERY_THREAD * qth);
L_CHAR * get_q_thread_title(QUERY_THREAD * qth);
int rc_warp(
	RADAR_CACHE * rc_ptr,
	int type,
	GB_RECT * rect,
	GB_POINT * center,
	REAL1 resolution,
	REAL1 rotate,
	L_CHAR * target,
	WARP_POINT*,
	int);
int get_rc_loading_status(RADAR_CACHE * rc_ptr,RC_LOADING_STATUS * rcs);
int
rc_next_history(RADAR_CACHE * rc_ptr);
int
rc_prev_history(RADAR_CACHE * rc_ptr);
int
rc_insert_history(RADAR_CACHE * rc_ptr);
void
rc_set_history_event(RADAR_CACHE * rc_ptr,void (*func)(RADAR_CACHE *,int,void*),void *work);
void
rc_set_status_event(RADAR_CACHE * rc_ptr,void (*func)(RADAR_CACHE *,void*),void *work);
WARP_POINT *
rc_get_warp_point(RADAR_CACHE *rc_ptr,int type);
void
free_warp_point_layer(WARP_POINT_LAYER * l);
void
free_warp_point(WARP_POINT * wp);
WARP_POINT *
sexp2wp(XL_SEXP * s);
XL_SEXP *
wp2sexp(WARP_POINT * wp);
WARP_POINT *
rc_copy_warp_point(WARP_POINT * wp);
int 
rc_trackback(XL_SEXP ** retp,RADAR_CACHE * rc_ptr,L_CHAR * path);

WARP_POINT *
rc_eurl2wp(L_CHAR * url);
int
rc_close_session(RADAR_CACHE * rc_ptr);
int
_rc_close_session(RADAR_CACHE * rc_ptr);
int
rc_get_mouse_mode(RADAR_CACHE * rc_ptr,int * mode,I_POINT * ptr,INTEGER64 * tim,int flags,int wait_flag);
int
rc_set_mouse_mode(RADAR_CACHE * rc_ptr,int mode,I_POINT ptr,INTEGER64 tim);



#endif

