/**********************************************************************
 
	Copyright (C) 2007- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___FA_CACHE_H___
#define ___FA_CACHE_H___

#include "machine/include.h"
#include "avt.h"


#define FAC_SIZE		4096
#define FAC_DEFAULT_ENTRIES	((128*1024*1024)/FAC_SIZE)
#define FAC_DIRTY_RATE		0.75

typedef struct fac_entry_header {
	struct fac_entry_header *	next;
	struct fac_entry_header *	prev;
} FAC_ENTRY_HEADER;

typedef struct fac_entry {
	FAC_ENTRY_HEADER	h;
	unsigned		dirty:1;
	U_INTEGER64		offset;
	U_INTEGER64		access_time;
	U_INTEGER64		create_time;
	int			len;
	char *			data;
	struct fac_info *	info;
} FAC_ENTRY;

typedef struct fac_info_header {
	struct fac_info_header * next;
	struct fac_info_header * prev;
} FAC_INFO_HEADER;

typedef struct fac_info {
	FAC_INFO_HEADER		h;
	U_INTEGER64		seek_point;
	U_INTEGER64		file_size;
	U_INTEGER64		real_file_size;
	AVT_NODE *		entries_tree;

/* init is required */
	int			fd;
	unsigned		long_file:1;
} FAC_INFO;

typedef struct fac_general {
	FAC_ENTRY_HEADER	entries;
	FAC_INFO_HEADER		info_list;
	int			total_entries;
	int			interval;
	int			entries_nos;
	int			dirty_nos;
} FAC_GENERAL;

extern FAC_GENERAL fac_general_info;

void fac_init_general();
void fac_init(FAC_INFO * info);
void fac_close(FAC_INFO * info);
void fac_flush(FAC_INFO* info);
int fac_read(FAC_INFO * info,void * data,int len);
int fac_write(FAC_INFO * info,void * data,int len);
INTEGER64 fac_lseek(FAC_INFO * info,INTEGER64 ofs,int pos);
int fac_truncate(FAC_INFO * info,U_INTEGER64 length);


#endif

