/**********************************************************************
 
	Copyright (C) 2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"heuristics_win_frame.h"
#include	"xl.h"
#include	"memory_debug.h"
#include	"associate64.h"
#include	"win_flame.h"
#include	"lock_level.h"
#include	"pri_level.h"
#include	"xlerror.h"
#include	"rcache.h"


typedef struct gf_list {
	struct gf_list *	next;
	int			type;
	GBVIEW_FLAME *		gf;
} GF_LIST;

SEM hwf_lock;
int hwf_key = -1,hwf_index = -1;
GF_LIST * gf_list;

void hwf_task(TKEY);
XL_SEXP *
xl_hwfSetup(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);

void
init_hwf()
{
	hwf_lock = new_lock(LL_HWF);

	set_env(gblisp_top_env1,l_string(std_cm,"hwfSetup"),
		get_func_prim(xl_hwfSetup,FO_APPLICATIVE,0,1,1));
}

HWF *
new_hwf(HWF * next,L_CHAR * url)
{
HWF * ret;
	ret = d_alloc(sizeof(*ret));
	ret->url = ll_copy_str(url);
	ret->flags = 0;
	ret->next = next;
	return ret;
}

void
free_hwf(HWF * h)
{
HWF * n;
	for ( ; h ; ) {
		n = h->next;
		d_f_ree(h->url);
		d_f_ree(h);
		h = n;
	}
}

L_CHAR * 
get_string_index(HWF * in)
{
L_CHAR * ret;
int size;
HWF * hp;
L_CHAR * ptr;
	size = 0;
	for ( hp = in ; hp ;  size += l_strlen(hp->url), hp = hp->next );
	ret = d_alloc((size+1)*sizeof(L_CHAR));
	ptr = ret;
	for ( hp = in ; hp ; hp = hp->next , ptr += size ) {
		size = l_strlen(hp->url);
		l_strcpy(ptr,hp->url);
	}
	return ret;
}

void
divide_hwf(HWF**ret_a,HWF**ret_b,HWF * in)
{
HWF * a;
	*ret_a = 0;
	*ret_b = 0;
	for ( ; in ; ) {
		a = in;
		in = in->next;
		a->next = *ret_a;
		*ret_a = a;
		if ( in == 0 )
			break;
		a = in;
		in = in->next;
		a->next = *ret_b;
		*ret_b = a;
	}
}

HWF *
sort_hwf(HWF * u)
{
HWF * a,* b,* ret, * c;
HWF ** rp;
int r;
	if ( u == 0 )
		return 0;
	if ( u->next == 0 )
		return u;
	divide_hwf(&a,&b,u);
	a = sort_hwf(a);
	b = sort_hwf(b);
	ret = 0;
	rp = &ret;
	for ( ; a && b ; ) {
		r = l_strcmp(a->url,b->url);
		if ( r < 0 ) {
			c = a;
			a = a->next;
			c->next = 0;
			*rp = c;
			rp = &c->next;
		}
		else if ( r == 0 ) {
			c = a;
			*rp = c;
			rp = &c->next;
			c->next = 0;
			c = b;
			c->next = 0;
			*rp = c;
			rp = &c->next;
		}
		else {
			c = b;
			b = b->next;
			c->next = 0;
			*rp = c;
			rp = &c->next;
		}
	}
	if ( a )
		*rp = a;
	else	*rp = b;
	return ret;
}

void
print_hwf(char * msg,HWF * u)
{
	ss_printf("HWF %s\n",msg);
	for ( ; u ; u = u->next )
		ss_printf(" %ls (%x)\n",u->url,u->flags);
	ss_printf("HWF END\n");
}



int
_call_hwf(HWF_CALL * work)
{
HWF_CALL c;
HWF hwf;
int ret;
HWF * target;
	if ( work->org_ptr == 0 ) {
		return (*work->h->func)(work);
	}
	c = *work;
	hwf = *c.org_ptr;
	target = c.org_ptr;
	hwf.next = 0;
	if ( c.target == 0 )
		c.target = &hwf;
	else 	*c.tail_p = &hwf;
	c.tail_p = &hwf.next;
	c.cnt ++;
	c.org_ptr = c.org_ptr->next;
	ret = _call_hwf(&c);
	if ( hwf.flags & HWFF_IGNORE )
		return ret;
	target->flags = hwf.flags;
	if ( ret < 0 )
		return ret;

	c = *work;
	c.org_ptr = c.org_ptr->next;
	return _call_hwf(&c);
}

int
call_hwf(HWF_CALL_HEADER * work)
{
HWF_CALL c;
	c.h = work;
	c.cnt = 0;
	c.target = 0;
	c.tail_p = 0;
	c.org_ptr = work->org;
	return _call_hwf(&c);
}


int
_insert_hwf(HWF_CALL * c)
{
L_CHAR * ix;
XL_SEXP * data;
HWF * p;
	if ( c->cnt < 1 )
		return 0;
	ix = get_string_index(c->target);
	gc_push(0,0,"_insert_hwf");
	data = 0;
	for ( p = c->target ; p ; p = p->next ) {
		if ( p->flags )
			data = cons(get_integer(1,0),data);
		else	data = cons(get_integer(0,0),data);
	}
	data = cons(get_integer(get_xltime(),0),reverse(data));
//ss_printf("INSERT TARGET = %ls\n",ix);
	l_insert_associate64(hwf_key,get_index64(hwf_key,hwf_index),ix,data);
	d_f_ree(ix);
	gc_pop(0,0);
	return 0;
}


void
insert_hwf(HWF * org)
{
HWF_CALL_HEADER h;
	h.org = org;
	h.func = _insert_hwf;
	call_hwf(&h);
}


int
_match_hwf(HWF_CALL * c)
{
XL_SEXP * data,*d;
ASSOC64_STRING_OPT opt;
HWF * p;
L_CHAR * ix;
int size;
	if ( c->cnt < 1 )
		return 0;
	ix = get_string_index(c->target);
	opt.flags = 0;
	gc_push(0,0,"_match_hwf");
	data = l_search_associate64(hwf_key,get_index64(hwf_key,hwf_index),ix,&opt);
	if ( data == 0 ) {
		gc_pop(0,0);
		d_f_ree(ix);
		return 0;
	}
	size = 0;
	data = cdr(data);
	for ( p = c->target ; p ; p = p->next ) {
		size += l_strlen(p->url);
		if ( size > opt.size ) {
			for ( p = p->next ; p ; p = p->next )
				p->flags |= HWFF_IGNORE;
			gc_pop(0,0);
			return 0;
		}
		d = car(data);
		data = cdr(data);
		if ( get_type(d) != XLT_INTEGER )
			er_panic("_match_hwf");
		if ( d->integer.data )
			p->flags = HWFF_SEE|HWFF_ACTIVE;
		else	p->flags = HWFF_ACTIVE;
	}
	d_f_ree(ix);
	gc_pop(0,0);
	return -1;
}

void
match_hwf(HWF * org)
{
HWF_CALL_HEADER h;
	h.org = org;
	h.func = _match_hwf;
	call_hwf(&h);
}


void
frame_to_hwf(GBVIEW_FLAME * gf)
{
GBVIEW_STATUS sts;
GBVIEW_LAYER_STATUS * ls;
HWF * hp;
int x,y;
	
	hp = 0;
	gc_push(0,0,"frrame_loop_task");
	wf_status_flags(gf,&sts,SF_LAYER_DETAILS);
	for ( ls = sts.layers ; ls ; ls = ls->next ) {
		x = ls->small_rect.br.x - ls->small_rect.tl.x;
		y = ls->small_rect.br.y - ls->small_rect.br.y;
		if ( x < gf->win_width/2 && y < gf->win_height/2 )
			continue;
		hp = new_hwf(hp,ls->entry_url);
		if ( (ls->flags & WFF_HIDE) ) {
			hp->flags = 0;
		}
		else {
			hp->flags = HWFF_SEE;
		}
	}
	hp = sort_hwf(hp);
	insert_hwf(hp);
	free_hwf(hp);
	gc_pop(0,0);
}

void
hwf_to_frame(GBVIEW_FLAME * gf)
{
GBVIEW_STATUS sts;
GBVIEW_LAYER_STATUS * ls;
HWF * hp,*hp2;
int x,y;
	
	hp = 0;
	gc_push(0,0,"frrame_loop_task");
	wf_status_flags(gf,&sts,SF_LAYER_DETAILS);
	for ( ls = sts.layers ; ls ; ls = ls->next ) {
		x = ls->small_rect.br.x - ls->small_rect.tl.x;
		y = ls->small_rect.br.y - ls->small_rect.br.y;
		if ( x < gf->win_width/2 && y < gf->win_height/2 )
			continue;
		hp = new_hwf(hp,ls->entry_url);
		if ( (ls->flags & WFF_HIDE) ) {
			hp->flags = 0;
		}
		else {
			hp->flags = HWFF_SEE;
		}
		if ( ls->flags & WFF_USER )
			hp->flags |= HWFF_USER;

	}
	hp = sort_hwf(hp);
	match_hwf(hp);
	for ( hp2 = hp ; hp2 ; hp2 = hp2->next ) {
		if ( hp2->flags & HWFF_USER  )
			continue;
		if ( (hp2->flags & HWFF_ACTIVE) == 0 )
			continue;
ss_printf("hwf_to_frame 1\n");
		if ( hp2->flags & HWFF_SEE )
			wf_set_overlay(gf,hp2->url,WFF_USER_NEGATE,WFF_HIDE);
		else	wf_set_overlay(gf,hp2->url,WFF_HIDE|WFF_USER_NEGATE,WFF_HIDE);
	}
	free_hwf(hp);
	gc_pop(0,0);
}

void
xx_wakeup_hwf(GBVIEW_FLAME * gf,int type,char * file,int line)
{
GF_LIST * gfl;

	lock_task(hwf_lock);
	if ( hwf_key < 0 || hwf_index < 0 )
		goto end;
	for ( gfl = gf_list ; gfl ; gfl = gfl->next ) {
		if ( gfl->gf == gf )
			break;
	}
	if ( gfl == 0 ) {
		gfl = d_alloc(sizeof(*gfl));
		gfl->gf = gf;
		gfl->type = type;
		gfl->next = gf_list;
		gf_list = gfl;
		create_task(hwf_task,(int)gfl,PRI_RCACHE);
	}
	else {
		gfl->type |= type;
	}
end:
	unlock_task(hwf_lock,"wakeup_hwf");
}

/*
hwf_key < 0 , hwf_index < 0 
	no connect
hwf_key < 0 , hwf_index = 0
	progress open
hwf_key >= 0 , hwf_index >= 0 
	open
hwf_key >= 0 , hwf_index < 0
	progress close
*/

void
_open_hwf()
{
L_CHAR * filepath;
L_CHAR * filepath2;
int key;



retry:
	if ( hwf_index >= 0 ) {
		return;
	}
	if ( hwf_key >= 0 && hwf_index < 0 ) {
		sleep_task((int)&hwf_key,hwf_lock);
		lock_task(hwf_lock);
		goto retry;
	}
	hwf_index = 0;
	wakeup_task((int)&hwf_key);
	unlock_task(hwf_lock,"open_hwf");
	filepath = get_rcache_file_name("hwf.asc");
	key = l_open_associate64(
		get_machine_filename_string(filepath),
		O_RDWR,
		0644,
		PF_USEFREELIST,
		FT_HWF,
		"utf-8");
	if ( key < 0 ) {
		filepath2 = get_rcache_file_name("hwf.bak");
		if ( copy_file(get_machine_filename_string(filepath2),n_string(std_cm,filepath)) < 0 )
			goto create_file;
		key = l_open_associate64(
			n_string(std_cm,filepath),
			O_RDWR,
			0644,
			PF_USEFREELIST,
			FT_HWF,
			"utf-8");
		if ( key < 0 ) {
		create_file:
			key = l_open_associate64(
				get_machine_filename_string(filepath),
				O_CREAT|O_RDWR|O_TRUNC,
				0644,
				PF_USEFREELIST,
				FT_HWF,
				"utf-8");
		}
		d_f_ree(filepath2);
	}

	d_f_ree(filepath);

	if ( key < 0 ) {
		hwf_index = -1;
		lock_task(hwf_lock);
		return;
	}
	new_index64(key,AIT_STRING,ASC_INDEX_HWF);
	lock_task(hwf_lock);
	hwf_index = ASC_INDEX_HWF;
	hwf_key = key;
}

void
_close_hwf()
{
int key;
L_CHAR * filepath,*filepath2;

retry:
	if ( hwf_index < 0 && hwf_key < 0 ) {
		return;
	}
	if ( hwf_key < 0 && hwf_index >= 0 ) {
		sleep_task((int)&hwf_key,hwf_lock);
		lock_task(hwf_lock);
		goto retry;
	}
	key = hwf_key;
	hwf_index = -1;
	wakeup_task((int)&hwf_key);
	for ( ; gf_list ; ) {
		sleep_task((int)&gf_list,hwf_lock);
		lock_task(hwf_lock);
	}
	unlock_task(hwf_lock,"close_hwf");

	l_close_associate64(key);

	lock_task(hwf_lock);
	hwf_key = -1;
	wakeup_task((int)&hwf_key);

	filepath = get_rcache_file_name("hwf.asc");
	filepath2 = get_rcache_file_name("hwf.bak");
	copy_file(get_machine_filename_string(filepath),get_machine_filename_string(filepath2));
	d_f_ree(filepath);
	d_f_ree(filepath2);
}

void
open_hwf()
{
	lock_task(hwf_lock);
	_open_hwf();
	unlock_task(hwf_lock,"open_hwf");
}

void
close_hwf()
{
	lock_task(hwf_lock);
	_close_hwf();
	unlock_task(hwf_lock,"open_hwf");
}

int
toggle_hwf(int mode)
{
int ret;
	lock_task(hwf_lock);
	if ( mode ) {
		if ( set_hwf(-1,0) ) {
			if ( hwf_index < 0 )
				_open_hwf();
		}
		else {	
			if ( hwf_index >= 0 )
				_close_hwf();
		}
		if ( hwf_index >= 0 )
			ret = 1;
		else	ret = 0;
	}
	else {
		if ( hwf_index >= 0 ) {
			_close_hwf();
			ret = 0;
			set_hwf(0,1);
		}
		else {
			_open_hwf();
			set_hwf(1,1);
			ret = 1;
		}
	}
	unlock_task(hwf_lock,"open_hwf");
	return ret;
}



void
hwf_task(TKEY d)
{
GF_LIST * gfl,** gflp;
int type;
XL_INTERPRETER * xli;

	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);

	gfl = (GF_LIST*)GET_TKEY(d);

	for ( ; ; ) {
		lock_task(hwf_lock);
		type = gfl->type;
		gfl->type = 0;
		if ( type == 0 || hwf_key < 0 || hwf_index < 0 ) {
			for ( gflp = &gf_list ; *gflp  ; gflp = &(*gflp)->next )
				if ( *gflp == gfl )
					break;
			if ( *gflp == 0 )
				er_panic("hwf_task");
			*gflp = gfl->next;
			d_f_ree(gfl);
			if ( gf_list == 0 )
				wakeup_task((int)&gf_list);
			unlock_task(hwf_lock,"hwf_task");
			break;
		}
		unlock_task(hwf_lock,"hwf_task");

l_check_cache64("hwf-1");
		if ( type & HWFF_TYPE_TO_HWF )
			frame_to_hwf(gfl->gf);
l_check_cache64("hwf-2");
		if ( type & HWFF_TYPE_TO_FRAME )
			hwf_to_frame(gfl->gf);
l_check_cache64("hwf-3");
	}
	close_self_interpreter();
}

XL_SEXP *
xl_hwfSetup(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * mode;
	mode = get_sf_attribute(sf,l_string(std_cm,"mode"));
	if ( mode == 0 ) {
		toggle_hwf(0);
	}
	else if ( l_strcmp(mode,l_string(std_cm,"toggle")) == 0 ) {
		toggle_hwf(0);
	}
	else if ( l_strcmp(mode,l_string(std_cm,"open")) == 0 ) {
		open_hwf();
		set_hwf(1,1);
	}
	else if ( l_strcmp(mode,l_string(std_cm,"close")) == 0 ) {
		close_hwf();
		set_hwf(1,0);
	}
	else if ( l_strcmp(mode,l_string(std_cm,"status")) == 0 ) {
		return get_integer(toggle_hwf(1),0);
	}
	else {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm," hwfSetup"),
			List(n_get_string("invalid mode attribute"),
				get_string(mode),-1));
	}
	return 0;
}



